# HttpRequestProxy 插件使用说明

## 插件简介

HttpRequestProxy 是TIS系统的HTTP代理配置插件，用于统一管理系统所有外部HTTP请求的代理设置。当您的TIS部署在内网环境，需要通过代理服务器访问外部资源时，可以使用本插件进行全局配置。

在企业内网环境中，出于安全考虑，服务器通常无法直接访问互联网。此时，TIS在执行数据同步任务时，如果需要访问外部API接口、下载资源文件或者连接云端数据源，就必须通过企业的代理服务器进行中转。本插件正是为解决这一需求而设计的。

## 📊 常用代理软件对比概览
| 软件名称 | 官网地址 | 类型 | 主要特点 | 适合场景 | 许可证 |
|---------|----------|------|---------|---------|--------|
| **Squid** | [http://www.squid-cache.org/](http://www.squid-cache.org/) | 开源 | 功能全面，支持缓存、认证 | 大中型企业、ISP | GPL |
| **Nginx** | [https://nginx.org/](https://nginx.org/) | 开源 | 高性能，反向代理/负载均衡 | Web服务器兼代理 | BSD |
| **Apache Traffic Server** | [https://trafficserver.apache.org/](https://trafficserver.apache.org/) | 开源 | 高性能，云原生友好 | 大型互联网企业 | Apache 2.0 |
| **CCProxy** | [http://www.ccproxy.com/](http://www.ccproxy.com/) | 商业 | 中文界面，易用性强 | 中小企业、教育机构 | 商业 |
| **WinGate** | [https://www.wingate.com/](https://www.wingate.com/) | 商业 | 功能集成，Windows友好 | Windows环境企业 | 商业 |
| **3proxy** | [https://3proxy.ru/](https://3proxy.ru/) | 开源 | 轻量级，跨平台 | 小型企业、嵌入式 | BSD |
| **Tinyproxy** | [https://tinyproxy.github.io/](https://tinyproxy.github.io/) | 开源 | 极简设计，低内存占用 | 小型企业或部门级代理 | GPL |
| **Polipo** | [https://www.pps.univ-paris-diderot.fr/~jch/software/polipo/](https://www.pps.univ-paris-diderot.fr/~jch/software/polipo/) | 开源 | 智能Web缓存，流量压缩 | 开发环境、个人使用 | MIT |

## 核心作用

- **统一代理管理**：为TIS系统的所有外部HTTP请求配置统一的代理服务器，无需在每个功能模块或数据源连接中单独设置，大幅简化配置工作，降低出错风险
- **灵活开关控制**：支持运行期动态启用或禁用代理，方便在网络环境变化时快速调整访问策略，例如在测试环境和生产环境之间切换时无需修改其他配置
- **安全认证支持**：支持配置代理服务器的用户认证信息，满足企业级代理服务器的安全管控要求，确保只有授权用户才能使用代理服务

## 适用场景

- 企业内网环境部署，需要访问外部API或云服务
- 数据同步任务涉及外网数据源的访问
- 需要通过代理服务器进行网络访问控制和审计
- 跨网络区域的数据传输需要经过安全网关

## 工作机制

插件采用全局生效机制。配置保存后，系统会立即应用代理设置，所有后续的外部HTTP请求都会自动通过指定的代理服务器进行转发，无需重启TIS服务。

**验证流程**：
1. 保存配置时，系统会自动验证代理主机地址是否可达
2. 检查代理端口是否可用
3. 通过实际发送测试请求验证代理服务器是否正常工作
4. 验证通过后才会保存配置并生效，确保配置的正确性

**生效时机**：
- 配置保存成功后立即生效，影响所有新发起的HTTP请求
- 删除配置后自动恢复为直连模式
- 可通过启用开关在运行期临时切换代理状态，无需删除配置

## 使用建议

建议在正式使用前，先在测试环境中验证代理服务器的连通性和认证信息的准确性。配置过程中如遇到验证失败，请检查代理服务器地址、端口以及网络防火墙设置。对于需要用户认证的代理服务器，务必确认用户名和密码的正确性。

在生产环境中启用代理后，建议保留启用开关为开启状态，仅在特殊情况下临时关闭，以保持网络访问策略的一致性。
