/*
 *  Copyright 2008 The Apache Software Foundation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.apache.ibatis.ibator.generator.ibatis2.sqlmap.elements;

import org.apache.ibatis.ibator.api.dom.xml.Attribute;
import org.apache.ibatis.ibator.api.dom.xml.XmlElement;

import com.koubei.abator.KoubeiIbatorPlugin;

/**
 * 生成查询列
 *
 * @author 百岁（baisui@2dfire.com）
 * @date 2019年6月11日
 */
public class SelectTargetColsByExampleWithoutBLOBsElementGenerator extends SelectByExampleWithoutBLOBsElementGenerator {

    public SelectTargetColsByExampleWithoutBLOBsElementGenerator() {
        super();
    }

    // <select id="ibatorgenerated_selectByExample2" resultClass="java.util.HashMap"
    // parameterClass="com.taobao.com.dfire.tis.realtime.transfer.dal.pojo.TotalpayCriteria"
    // >
    // select
    // <iterate property="cols" conjunction=",">$cols[]$</iterate>

    @Override
    protected void addSelectCol(StringBuilder sb) {
        sb.append("\n<iterate property=\"cols\" conjunction=\",\" prepend=\",\">$cols[].name$</iterate>");
    }

    @Override
    protected void addElementAttribute(XmlElement answer) {

        answer.addAttribute(new Attribute("id", //$NON-NLS-1$
                KoubeiIbatorPlugin.MAPNAME_SELECT_TARGET_COLS));


        answer.addAttribute(new Attribute("resultClass" //
				, this.ibatorContext.getUserConfig().getRowMapClassFullName())); //$NON-NLS-1$
    }

}
