/*
 *  Copyright 2008 The Apache Software Foundation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.apache.ibatis.ibator.generator.ibatis2.sqlmap.elements;

import org.apache.ibatis.ibator.api.FullyQualifiedTable;
import org.apache.ibatis.ibator.api.IntrospectedColumn;
import org.apache.ibatis.ibator.api.dom.java.FullyQualifiedJavaType;
import org.apache.ibatis.ibator.api.dom.xml.Attribute;
import org.apache.ibatis.ibator.api.dom.xml.TextElement;
import org.apache.ibatis.ibator.api.dom.xml.XmlElement;
import org.apache.ibatis.ibator.generator.ibatis2.XmlConstants;
import org.apache.ibatis.ibator.internal.util.StringUtility;

/**
 * @author 百岁（baisui@2dfire.com）
 *
 * @date 2019年6月11日
 */
public class SelectByExampleWithoutBLOBsElementGenerator extends AbstractXmlElementGenerator {

	public SelectByExampleWithoutBLOBsElementGenerator() {
		super();
	}

	private static final String TAB_ALIAS_AA = "aa";
	private static final String TAB_ALIAS_BB = "bb";

	@Override
	public final void addElements(XmlElement parentElement) {
		FullyQualifiedTable table = introspectedTable.getFullyQualifiedTable();
		FullyQualifiedJavaType fqjt = introspectedTable.getExampleType();

		XmlElement answer = new XmlElement("select"); //$NON-NLS-1$

		// baisui extra new method for subclass overwrite 20190611
		addElementAttribute(answer);
		answer.addAttribute(new Attribute("parameterClass", fqjt.getFullyQualifiedName())); //$NON-NLS-1$

		ibatorContext.getCommentGenerator().addComment(answer);

		StringBuilder sb = new StringBuilder();
		// baisui modify 20110705
		sb.append("select "); //$NON-NLS-1$

		boolean comma = false;
		if (StringUtility.stringHasValue(introspectedTable.getSelectByExampleQueryId())) {
			sb.append('\'');
			sb.append(introspectedTable.getSelectByExampleQueryId());
			sb.append("' as QUERYID"); //$NON-NLS-1$
			comma = true;
		}

		// baisui modify 20110705
		// 取得主键索引
		for (IntrospectedColumn introspectedColumn : introspectedTable.getPrimaryKeyColumns()) {
			if (comma) {
				sb.append(", "); //$NON-NLS-1$
			} else {
				comma = true;
			}

			sb.append(TAB_ALIAS_AA).append(".").append(introspectedColumn.getSelectListPhrase()).append(" AS ")
					.append(introspectedColumn.getSelectListPhrase());
		}

		addSelectCol(sb);

		answer.addElement((new TextElement(sb.toString())));

		sb.setLength(0);

		sb.append(" from ( select ");

		// baisui 添加主键列
		comma = false;
		for (IntrospectedColumn column : introspectedTable.getPrimaryKeyColumns()) {

			if (comma) {
				sb.append(",");
			} else {
				comma = true;
			}

			sb.append(column.getAliasedEscapedColumnName());
		}

		sb.append(" from ").append(table.getAliasedFullyQualifiedTableNameAtRuntime()).append(" ");
		answer.addElement((new TextElement(sb.toString())));
		// where criteria
		// start==================================================================
		XmlElement isParameterPresenteElement = new XmlElement("isParameterPresent"); //$NON-NLS-1$
		answer.addElement(isParameterPresenteElement);

		XmlElement includeElement = new XmlElement("include"); //$NON-NLS-1$
		includeElement.addAttribute(new Attribute("refid", //$NON-NLS-1$
				table.getSqlMapNamespace() + "." + XmlConstants.EXAMPLE_WHERE_CLAUSE_ID)); //$NON-NLS-1$
		isParameterPresenteElement.addElement(includeElement);

		XmlElement isNotNullElement = new XmlElement("isNotNull"); //$NON-NLS-1$
		isNotNullElement.addAttribute(new Attribute("property", "orderByClause")); //$NON-NLS-1$ //$NON-NLS-2$
		isNotNullElement.addElement(new TextElement("order by $orderByClause$")); //$NON-NLS-1$
		isParameterPresenteElement.addElement(isNotNullElement);
		isParameterPresenteElement.addElement(new TextElement("limit #skip#,#pageSize#"));
		// where criteria
		// end==================================================================
		sb.setLength(0);
		sb.append("   ) bb inner join ").append(table.getAliasedFullyQualifiedTableNameAtRuntime()).append(" ")
				.append(TAB_ALIAS_AA);

		sb.append(" on "); //$NON-NLS-1$

		// baisui 设置inner join的连接条件
		boolean and = false;
		for (IntrospectedColumn column : introspectedTable.getPrimaryKeyColumns()) {

			if (and) {
				sb.append(" and ");
			} else {
				and = true;
			}

			sb.append(TAB_ALIAS_AA).append(".").append(column.getAliasedEscapedColumnName());
			sb.append("=");
			sb.append(TAB_ALIAS_BB).append(".").append(column.getAliasedEscapedColumnName());
		}

		answer.addElement((new TextElement(sb.toString())));
		// ========================================================================================================

		if (ibatorContext.getPlugins().sqlMapSelectByExampleWithoutBLOBsElementGenerated(answer, introspectedTable)) {
			parentElement.addElement(answer);
		}
	}

	protected void addSelectCol(StringBuilder sb) {
		boolean comma = false;
		// 取得非主键的列
		for (IntrospectedColumn introspectedColumn : introspectedTable.getBaseColumns()) {
			if (comma) {
				sb.append(", "); //$NON-NLS-1$
			} else {
				comma = true;
			}
			sb.append(introspectedColumn.getSelectListPhrase());
		}
	}

	protected void addElementAttribute(XmlElement answer) {
		answer.addAttribute(new Attribute("id", //$NON-NLS-1$
				XmlConstants.SELECT_BY_EXAMPLE_STATEMENT_ID));
		answer.addAttribute(new Attribute("resultMap", XmlConstants.BASE_RESULT_MAP_ID)); //$NON-NLS-1$
	}
}
