/*
 *  Copyright 2008 The Apache Software Foundation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.apache.ibatis.ibator.generator.ibatis2.sqlmap.elements;

import org.apache.ibatis.ibator.api.FullyQualifiedTable;
import org.apache.ibatis.ibator.api.IntrospectedColumn;
import org.apache.ibatis.ibator.api.dom.java.FullyQualifiedJavaType;
import org.apache.ibatis.ibator.api.dom.xml.Attribute;
import org.apache.ibatis.ibator.api.dom.xml.TextElement;
import org.apache.ibatis.ibator.api.dom.xml.XmlElement;
import org.apache.ibatis.ibator.config.GeneratedKey;
import org.apache.ibatis.ibator.generator.ibatis2.XmlConstants;

/**
 * 
 * @author Jeff Butler
 * 
 */
public class InsertElementGenerator extends AbstractXmlElementGenerator {

	public InsertElementGenerator() {
		super();
	}

	@Override
	public void addElements(XmlElement parentElement) {
		XmlElement answer = new XmlElement("insert"); //$NON-NLS-1$

		FullyQualifiedTable table = introspectedTable.getFullyQualifiedTable();
		answer.addAttribute(new Attribute(
				"id", XmlConstants.INSERT_STATEMENT_ID)); //$NON-NLS-1$

		FullyQualifiedJavaType parameterType = introspectedTable.getRules()
				.calculateAllFieldsClass();

		answer.addAttribute(new Attribute("parameterClass", //$NON-NLS-1$
				parameterType.getFullyQualifiedName()));

		ibatorContext.getCommentGenerator().addComment(answer);

		GeneratedKey gk = introspectedTable.getGeneratedKey();

		// if (gk != null && gk.isBeforeInsert()) {
		// IntrospectedColumn introspectedColumn = introspectedTable
		// .getColumn(gk.getColumn());
		// // if the column is null, then it's a configuration error. The
		// // warning has already been reported
		// if (introspectedColumn != null) {
		// // pre-generated key
		// answer.addElement(getSelectKey(introspectedColumn, gk));
		// }
		// }

		StringBuilder insertClause = new StringBuilder();
		StringBuilder valuesClause = new StringBuilder();

		insertClause.append("insert into "); //$NON-NLS-1$
		insertClause.append(table.getFullyQualifiedTableNameAtRuntime());
		insertClause.append(" ("); //$NON-NLS-1$

		valuesClause.append("values ("); //$NON-NLS-1$

		boolean comma = false;
		for (IntrospectedColumn introspectedColumn : introspectedTable
				.getAllColumns()) {
			if (introspectedColumn.isIdentity()) {
				// cannot set values on identity fields
				continue;
			}

			if (comma) {
				insertClause.append(", "); //$NON-NLS-1$
				valuesClause.append(", "); //$NON-NLS-1$
			} else {
				comma = true; // turn on comma for next time
			}

			insertClause.append(introspectedColumn.getEscapedColumnName());
			valuesClause.append(introspectedColumn
					.getIbatisFormattedParameterClause());
		}
		insertClause.append(')');
		valuesClause.append(')');

		answer.addElement(new TextElement(insertClause.toString()));
		answer.addElement(new TextElement(valuesClause.toString()));
		// baisui commented ,since this seem as insignificant
		// if (gk != null && !gk.isBeforeInsert()) {
		// IntrospectedColumn introspectedColumn =
		// introspectedTable.getColumn(gk.getColumn());
		// // if the column is null, then it's a configuration error. The
		// // warning has already been reported
		// if (introspectedColumn != null) {
		// // pre-generated key
		// answer.addElement(getSelectKey(introspectedColumn, gk));
		// }
		// }
		if (gk != null) {
			answer.addElement(gk.toXmlElement());
		}
		// add end

		if (ibatorContext.getPlugins().sqlMapInsertElementGenerated(answer,
				introspectedTable)) {
			parentElement.addElement(answer);
		}
	}
}
