package org.apache.ibatis.ibator.generator.ibatis2.dao.elements;

import java.text.MessageFormat;

import org.apache.ibatis.ibator.api.FullyQualifiedTable;
import org.apache.ibatis.ibator.generator.ibatis2.XmlConstants;


public class KoubeiCountFromWriteDBByExampleMethodGenerator extends
		CountByExampleMethodGenerator {

	public KoubeiCountFromWriteDBByExampleMethodGenerator(
			boolean generateForJava5) {
		super(generateForJava5);
	}

	@Override
	protected String getMethodName() {
		return "countFromWriteDB";
	}

	@Override
	protected String getCountExecuteMethodBody(FullyQualifiedTable table) {
		// return super.getCountExecuteMethodBody(table);
		return MessageFormat
				.format("this.countFromWriterDB(\"{0}.{1}\",{2});",
						new Object[] { table.getSqlMapNamespace(),
								XmlConstants.COUNT_BY_EXAMPLE_STATEMENT_ID,
								"example" });
	}

}
