/**
 *
 */
package com.koubei.abator.xml;

import com.koubei.abator.IUserDefineProperties;
import org.apache.ibatis.ibator.api.IntrospectedTable;
import org.apache.ibatis.ibator.api.dom.xml.Attribute;
import org.apache.ibatis.ibator.api.dom.xml.Document;
import org.apache.ibatis.ibator.api.dom.xml.XmlElement;
import org.apache.ibatis.ibator.config.IbatorContext;

import java.text.MessageFormat;
import java.util.List;

/**
 * @author 百岁（baisui@taobao.com）
 * @date 2012-4-28
 */
public class SpringDocument extends Document {

    public static final String BASIC_DAO = "DAO";
    public static final String FACADE_IMPL_NAME = "DAOFacadeImpl";
    public static final MessageFormat FACADE_IMPL_FULL_NAME = new MessageFormat(".impl.{0}" + FACADE_IMPL_NAME);
	public static final String DB_FACADE_INSTANCE_SUFFIX = "DAOFacade";
    private final IbatorContext ibatorContext;

    public SpringDocument(IbatorContext ibatorContext) {

        // <!DOCTYPE beans PUBLIC "-//SPRING//DTD BEAN//EN"
        // "http://www.springframework.org/dtd/spring-beans.dtd">

        super("-//SPRING//DTD BEAN//EN", "http://www.springframework.org/dtd/spring-beans.dtd");

        this.ibatorContext = ibatorContext;

        XmlElement element = new XmlElement("beans");
        // element.addAttribute(new Attribute("default-autowire",
        // "http://www.w3.org/2001/XMLSchema-instance"));
        // element.addAttribute(new Attribute("xmlns",
        // "http://www.springframework.org/schema/beans"));
        // element.addAttribute(new Attribute("xmlns:p",
        // "http://www.springframework.org/schema/p"));
        //
        // final String value =
        // "http://www.springframework.org/schema/beans
        // http://www.springframework.org/schema/beans/spring-beans.xsd";
        // element.addAttribute(new Attribute("xsi:schemaLocation", value));

        this.setRootElement(element);

    }

    public void addDatasource() {

        IUserDefineProperties userProps = this.ibatorContext.getUserConfig();

        if (userProps.generateDataSourceConfig()) {
            ExtendProp datasource = new ExtendProp("bean");
            datasource.addAttribute(
                    new Attribute("id", this.ibatorContext.getDatabaseName() + SpringDocument.BASIC_DATA_SOURCE));
            datasource.addAttribute(new Attribute("class", "org.apache.commons.dbcp.BasicDataSource"));
            datasource.addAttribute(new Attribute("destroy-method", "close"));

            datasource.addPropElement("driverClassName", "com.mysql.jdbc.Driver");
            datasource.addPropElement("url", this.ibatorContext.getConnectionUrl());
            datasource.addPropElement("username", this.ibatorContext.getUsername());
            datasource.addPropElement("password", this.ibatorContext.getPassword());
            datasource.addPropElement("validationQuery", "select 1");

            this.getRootElement().addElement(datasource);
        }

    }

    public void addDaoConfig(IntrospectedTable table) {

        XmlElement element = new XmlElement("bean");
        element.addAttribute(new Attribute("id", table.getDAOObjName()));
        element.addAttribute(new Attribute("class", table.getDAOImplementationType().getFullyQualifiedName()));
        element.addAttribute(new Attribute("parent", this.ibatorContext.getDatabaseName() + BASIC_DAO));

        this.getRootElement().addElement(element);

    }

    public static final String BASIC_DATA_SOURCE = "Datasource";

    public void addBasicDAO() {

        final XmlElement element = new XmlElement("bean");
        element.addAttribute(new Attribute("id", this.ibatorContext.getDatabaseName() + SpringDocument.BASIC_DAO));

        element.addAttribute(new Attribute("class", "org.springframework.orm.ibatis.support.SqlMapClientDaoSupport"));
        element.addAttribute(new Attribute("abstract", "true"));

        XmlElement prop = new XmlElement("property");
        prop.addAttribute(new Attribute("name", "dataSource"));
        prop.addAttribute(new Attribute("ref", this.ibatorContext.getDatabaseName() + BASIC_DATA_SOURCE));
        element.addElement(prop);

        prop = new XmlElement("property");
        prop.addAttribute(new Attribute("name", "sqlMapClient"));

        XmlElement sqlMapClientFactoryBean = new XmlElement("bean");
        sqlMapClientFactoryBean
                .addAttribute(new Attribute("class", "org.springframework.orm.ibatis.SqlMapClientFactoryBean"));

        XmlElement configLocation = new XmlElement("property");

        configLocation.addAttribute(new Attribute("name", "configLocation"));
        configLocation.addAttribute(new Attribute("value", ibatorContext.getSqlMapConfigPath()));

        sqlMapClientFactoryBean.addElement(configLocation);

        prop.addElement(sqlMapClientFactoryBean);
        element.addElement(prop);

        this.getRootElement().addElement(element);
    }



    public void addFacadeImpl(List<IntrospectedTable> introspectedTables) {

        final XmlElement element = new XmlElement("bean");

        element.addAttribute(new Attribute("id", this.ibatorContext.getDatabaseName() + DB_FACADE_INSTANCE_SUFFIX));

        element.addAttribute(new Attribute("class", ibatorContext.getDAOFacadeImpl().getFullyQualifiedName()));

        // <constructor-arg index="0" ref="appPackageDAO" />
        int i = 0;
        for (IntrospectedTable tab : introspectedTables) {
            XmlElement construct = new XmlElement("constructor-arg");
            construct.addAttribute(new Attribute("index", String.valueOf(i++)));
            construct.addAttribute(new Attribute("ref", tab.getDAOObjName()));
            element.addElement(construct);
        }

        this.getRootElement().addElement(element);

    }

    public static void main(String[] arg) {

    }

    // protected void addDoctype(StringBuilder sb) {
    // }
}
