package com.koubei.abator.plugin;

import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.ibator.api.GeneratedJavaFile;
import org.apache.ibatis.ibator.api.IbatorPluginAdapter;
import org.apache.ibatis.ibator.api.IntrospectedColumn;
import org.apache.ibatis.ibator.api.IntrospectedTable;
import org.apache.ibatis.ibator.api.dom.java.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 生成表对应的meta信息，列、PK等
 *
 * @author 百岁（baisui@2dfire.com）
 * @date 2019年6月11日
 */
public class TableMetaInfoPlugin extends IbatorPluginAdapter {

    @Override
    public boolean validate(List<String> warnings) {
        return true;
    }

    public List<GeneratedJavaFile> contextGenerateAdditionalJavaFiles(IntrospectedTable introspectedTable) {

        List<GeneratedJavaFile> result = new ArrayList<GeneratedJavaFile>();

        FullyQualifiedJavaType type = new FullyQualifiedJavaType(
                introspectedTable.getJavaModelPackage() + "." + introspectedTable.getTableMetaEnumName());

        TopLevelEnumeration enumeration = new TopLevelEnumeration(type);
        enumeration.setVisibility(JavaVisibility.PUBLIC);

        Set<String> pks = introspectedTable.getPrimaryKeyColumns().stream().map((r) -> r.getActualColumnName()).collect(Collectors.toSet());
        boolean isPk;
        for (IntrospectedColumn col : introspectedTable.getAllColumns()) {
            isPk = pks.contains(col.getActualColumnName());
            enumeration.addEnumConstant(StringUtils.upperCase(col.getActualColumnName()) + "(\""
                    + col.getActualColumnName() + "\"," + col.getJdbcType() + "," + (isPk) + ")");
        }

        Method constructor = new Method();
        constructor.setConstructor(true);
        constructor.setName(introspectedTable.getTableMetaEnumName());
        constructor.setVisibility(JavaVisibility.PRIVATE);
        Parameter param = new Parameter(FullyQualifiedJavaType.getStringInstance(), "name");
        constructor.addParameter(param);

        param = new Parameter(FullyQualifiedJavaType.getIntInstance(), "jdbcType");
        constructor.addParameter(param);

        // 标示是否是主键
        param = new Parameter(FullyQualifiedJavaType.getBooleanPrimitiveInstance(), "pk");
        constructor.addParameter(param);

        constructor.addBodyLine("this.jdbcType = jdbcType;");
        constructor.addBodyLine("this.name = name;");
        constructor.addBodyLine("this.pk = pk;");

        enumeration.addMethod(constructor);

//        Field nameField = new Field();
//        nameField.setFinal(true);
//        nameField.setName("name");
//        nameField.setType(FullyQualifiedJavaType.getStringInstance());
//        nameField.setVisibility(JavaVisibility.PRIVATE);
//
//        enumeration.addField(nameField);
//
//        Field jdbcTypeField = new Field();
//        jdbcTypeField.setFinal(true);
//        jdbcTypeField.setName("jdbcType");
//        jdbcTypeField.setType(FullyQualifiedJavaType.getIntInstance());
//        jdbcTypeField.setVisibility(JavaVisibility.PRIVATE);
//        enumeration.addField(jdbcTypeField);

        getPrivateField(enumeration, "name", FullyQualifiedJavaType.getStringInstance());
        getPrivateField(enumeration, "jdbcType", FullyQualifiedJavaType.getIntInstance());
        getPrivateField(enumeration, "pk", FullyQualifiedJavaType.getBooleanPrimitiveInstance());

        Method getName = new Method();
        getName.setConstructor(false);
        getName.setName("getName");
        getName.setReturnType(FullyQualifiedJavaType.getStringInstance());
        getName.setVisibility(JavaVisibility.PUBLIC);
        getName.addBodyLine("return this.name;");
        enumeration.addMethod(getName);

        Method getJdbcType = new Method();
        getJdbcType.setConstructor(false);
        getJdbcType.setName("getJdbcType");
        getJdbcType.setReturnType(FullyQualifiedJavaType.getIntInstance());
        getJdbcType.setVisibility(JavaVisibility.PUBLIC);
        getJdbcType.addBodyLine("return this.jdbcType;");
        enumeration.addMethod(getJdbcType);

        Method getPk = new Method();
        getPk.setConstructor(false);
        getPk.setName("isPK");
        getPk.setReturnType(FullyQualifiedJavaType.getBooleanPrimitiveInstance());
        getPk.setVisibility(JavaVisibility.PUBLIC);
        getPk.addBodyLine("return this.pk;");
        enumeration.addMethod(getPk);

        Field pksField = new Field();
        pksField.setFinal(true);
        pksField.setStatic(true);
        pksField.setName("pks");
        pksField.setType(
                new FullyQualifiedJavaType("java.util.List<" + introspectedTable.getTableMetaEnumName() + ">"));
        pksField.setVisibility(JavaVisibility.PRIVATE);

        StringBuilder addBuilder = new StringBuilder();
        introspectedTable.getPrimaryKeyColumns().stream()
                .map((r) -> ".add(" + StringUtils.upperCase(r.getActualColumnName()) + ")").forEach((e) -> {
            addBuilder.append(e);
        });

        pksField.setInitializationString("(new ImmutableList.Builder<" + introspectedTable.getTableMetaEnumName()
                + ">())" + addBuilder.toString() + ".build()");

        enumeration.addField(pksField);

        Method getPKsMethod = new Method();
        getPKsMethod.setConstructor(false);
        getPKsMethod.setName("getPKs");
        getPKsMethod.setReturnType(
                new FullyQualifiedJavaType("java.util.List<" + introspectedTable.getTableMetaEnumName() + ">"));
        getPKsMethod.setVisibility(JavaVisibility.PUBLIC);
        getPKsMethod.setStatic(true);
        getPKsMethod.addBodyLine("return pks;");

        enumeration.addMethod(getPKsMethod);
        enumeration.addImportedType(new FullyQualifiedJavaType("java.util.List"));
        enumeration.addImportedType(new FullyQualifiedJavaType("com.google.common.collect.ImmutableList"));

        GeneratedJavaFile gJavaFile = new GeneratedJavaFile(enumeration,
                ibatorContext.getJavaModelGeneratorConfiguration().getTargetProject());
        result.add(gJavaFile);

        return result;
    }

    private void getPrivateField(TopLevelEnumeration enumeration, String fieldName, FullyQualifiedJavaType type) {
        Field pkField = new Field();
        pkField.setFinal(true);
        pkField.setName(fieldName);
        pkField.setType(type);
        pkField.setVisibility(JavaVisibility.PRIVATE);
        enumeration.addField(pkField);
    }

}
