package com.koubei.abator.plugin;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

import org.apache.ibatis.ibator.api.GeneratedJavaFile;
import org.apache.ibatis.ibator.api.GeneratedXmlFile;
import org.apache.ibatis.ibator.api.IbatorPlugin;
import org.apache.ibatis.ibator.api.IbatorPluginAdapter;
import org.apache.ibatis.ibator.api.IntrospectedColumn;
import org.apache.ibatis.ibator.api.IntrospectedTable;
import org.apache.ibatis.ibator.api.dom.java.Field;
import org.apache.ibatis.ibator.api.dom.java.Interface;
import org.apache.ibatis.ibator.api.dom.java.TopLevelClass;
import org.apache.ibatis.ibator.api.dom.xml.Document;
import org.apache.ibatis.ibator.api.dom.xml.XmlElement;
import org.apache.ibatis.ibator.config.IbatorContext;

import com.koubei.abator.KoubeiIbatorRunner;

/**
 * @author 百岁（baisui@2dfire.com）
 * @date 2019年6月12日
 */
public class DiableUpdateInsertDeletePlugin extends IbatorPluginAdapter {

    private static final Pattern PATTERN_MODIFY_METHOD = Pattern.compile("Update|Insert|Delete");

    public static void main(String[] args) {

        // Matcher matcher = PATTERN_MODIFY_METHOD.matcher("daosnsertMethodGenerated");
        // if (matcher.find()) {
        // System.out.println("matcher.find()");
        // } else {
        // System.out.println("not matcher.find()");
        // }

        DiableUpdateInsertDeletePlugin plugin = new DiableUpdateInsertDeletePlugin();

        plugin.modelExampleClassGenerated(null, null);

    }

    private IbatorPlugin delegatePlugin;

    public DiableUpdateInsertDeletePlugin() {


    }

    public int hashCode() {
        return PATTERN_MODIFY_METHOD.hashCode();
    }

    public boolean equals(Object obj) {
        return PATTERN_MODIFY_METHOD.equals(obj);
    }

    public String pattern() {
        return PATTERN_MODIFY_METHOD.pattern();
    }

    public String toString() {
        return PATTERN_MODIFY_METHOD.toString();
    }

    public Matcher matcher(CharSequence input) {
        return PATTERN_MODIFY_METHOD.matcher(input);
    }

    public int flags() {
        return PATTERN_MODIFY_METHOD.flags();
    }

    public String[] split(CharSequence input, int limit) {
        return PATTERN_MODIFY_METHOD.split(input, limit);
    }

    public String[] split(CharSequence input) {
        return PATTERN_MODIFY_METHOD.split(input);
    }

    public Predicate<String> asPredicate() {
        return PATTERN_MODIFY_METHOD.asPredicate();
    }

    public Stream<String> splitAsStream(CharSequence input) {
        return PATTERN_MODIFY_METHOD.splitAsStream(input);
    }

    public void setIbatorContext(IbatorContext ibatorContext) {

    	this.ibatorContext = ibatorContext;
		if (this.ibatorContext == null) {
			throw new IllegalStateException("ibatorContext can not be null");
		}

		this.delegatePlugin = (IbatorPlugin) Proxy.newProxyInstance(
				DiableUpdateInsertDeletePlugin.class.getClassLoader(), new Class<?>[]{IbatorPlugin.class},
				new InvocationHandler() {
					@Override
					public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {

						Matcher matcher = null;
						if (method.getReturnType().isPrimitive()) {

							matcher = PATTERN_MODIFY_METHOD.matcher(method.getName());
							if (matcher.find()) {
								return !ibatorContext.getUserConfig().isDisableGenerateModifyDAOMethod();
							} else {
								return true;
							}

						}

						return null;
					}
				});


        delegatePlugin.setIbatorContext(ibatorContext);
    }

    public void setProperties(Properties properties) {
        delegatePlugin.setProperties(properties);
    }

    public void initialized(IntrospectedTable introspectedTable) {
        delegatePlugin.initialized(introspectedTable);
    }

    public List<GeneratedJavaFile> contextGenerateAdditionalJavaFiles(List<IntrospectedTable> introspectedTables) {
        return delegatePlugin.contextGenerateAdditionalJavaFiles(introspectedTables);
    }

    public List<GeneratedJavaFile> contextGenerateAdditionalJavaFiles(IntrospectedTable introspectedTable) {
        return delegatePlugin.contextGenerateAdditionalJavaFiles(introspectedTable);
    }

    public List<GeneratedXmlFile> contextGenerateAdditionalXmlFiles(List<IntrospectedTable> introspectedTables) {
        return delegatePlugin.contextGenerateAdditionalXmlFiles(introspectedTables);
    }

    public List<GeneratedXmlFile> contextGenerateAdditionalXmlFiles(IntrospectedTable introspectedTable) {
        return delegatePlugin.contextGenerateAdditionalXmlFiles(introspectedTable);
    }

    public boolean daoInterfaceGenerated(Interface interfaze, IntrospectedTable introspectedTable) {
        return delegatePlugin.daoInterfaceGenerated(interfaze, introspectedTable);
    }

    public boolean daoImplementationGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return delegatePlugin.daoImplementationGenerated(topLevelClass, introspectedTable);
    }

    public boolean daoCountByExampleMethodGenerated(org.apache.ibatis.ibator.api.dom.java.Method method,
                                                    TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return delegatePlugin.daoCountByExampleMethodGenerated(method, topLevelClass, introspectedTable);
    }

    public boolean daoDeleteByExampleMethodGenerated(org.apache.ibatis.ibator.api.dom.java.Method method,
                                                     TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return delegatePlugin.daoDeleteByExampleMethodGenerated(method, topLevelClass, introspectedTable);
    }

    public boolean daoDeleteByPrimaryKeyMethodGenerated(org.apache.ibatis.ibator.api.dom.java.Method method,
                                                        TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return delegatePlugin.daoDeleteByPrimaryKeyMethodGenerated(method, topLevelClass, introspectedTable);
    }

    public boolean daoInsertMethodGenerated(org.apache.ibatis.ibator.api.dom.java.Method method,
                                            TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return delegatePlugin.daoInsertMethodGenerated(method, topLevelClass, introspectedTable);
    }

    public boolean daoInsertSelectiveMethodGenerated(org.apache.ibatis.ibator.api.dom.java.Method method,
                                                     TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return delegatePlugin.daoInsertSelectiveMethodGenerated(method, topLevelClass, introspectedTable);
    }

    public boolean daoSelectByExampleWithBLOBsMethodGenerated(org.apache.ibatis.ibator.api.dom.java.Method method,
                                                              TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return delegatePlugin.daoSelectByExampleWithBLOBsMethodGenerated(method, topLevelClass, introspectedTable);
    }

    public boolean daoSelectByExampleWithoutBLOBsMethodGenerated(org.apache.ibatis.ibator.api.dom.java.Method method,
                                                                 TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return delegatePlugin.daoSelectByExampleWithoutBLOBsMethodGenerated(method, topLevelClass, introspectedTable);
    }

    public boolean daoSelectByPrimaryKeyMethodGenerated(org.apache.ibatis.ibator.api.dom.java.Method method,
                                                        TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return delegatePlugin.daoSelectByPrimaryKeyMethodGenerated(method, topLevelClass, introspectedTable);
    }

    public boolean daoUpdateByExampleSelectiveMethodGenerated(org.apache.ibatis.ibator.api.dom.java.Method method,
                                                              TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return delegatePlugin.daoUpdateByExampleSelectiveMethodGenerated(method, topLevelClass, introspectedTable);
    }

    public boolean daoUpdateByExampleWithBLOBsMethodGenerated(org.apache.ibatis.ibator.api.dom.java.Method method,
                                                              TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return delegatePlugin.daoUpdateByExampleWithBLOBsMethodGenerated(method, topLevelClass, introspectedTable);
    }

    public boolean daoUpdateByExampleWithoutBLOBsMethodGenerated(org.apache.ibatis.ibator.api.dom.java.Method method,
                                                                 TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return delegatePlugin.daoUpdateByExampleWithoutBLOBsMethodGenerated(method, topLevelClass, introspectedTable);
    }

    public boolean daoUpdateByPrimaryKeySelectiveMethodGenerated(org.apache.ibatis.ibator.api.dom.java.Method method,
                                                                 TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return delegatePlugin.daoUpdateByPrimaryKeySelectiveMethodGenerated(method, topLevelClass, introspectedTable);
    }

    public boolean daoUpdateByPrimaryKeyWithBLOBsMethodGenerated(org.apache.ibatis.ibator.api.dom.java.Method method,
                                                                 TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return delegatePlugin.daoUpdateByPrimaryKeyWithBLOBsMethodGenerated(method, topLevelClass, introspectedTable);
    }

    public boolean daoUpdateByPrimaryKeyWithoutBLOBsMethodGenerated(org.apache.ibatis.ibator.api.dom.java.Method method,
                                                                    TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return delegatePlugin.daoUpdateByPrimaryKeyWithoutBLOBsMethodGenerated(method, topLevelClass,
                introspectedTable);
    }

    public boolean daoCountByExampleMethodGenerated(org.apache.ibatis.ibator.api.dom.java.Method method,
                                                    Interface interfaze, IntrospectedTable introspectedTable) {
        return delegatePlugin.daoCountByExampleMethodGenerated(method, interfaze, introspectedTable);
    }

    public boolean daoDeleteByExampleMethodGenerated(org.apache.ibatis.ibator.api.dom.java.Method method,
                                                     Interface interfaze, IntrospectedTable introspectedTable) {
        return delegatePlugin.daoDeleteByExampleMethodGenerated(method, interfaze, introspectedTable);
    }

    public boolean daoDeleteByPrimaryKeyMethodGenerated(org.apache.ibatis.ibator.api.dom.java.Method method,
                                                        Interface interfaze, IntrospectedTable introspectedTable) {
        return delegatePlugin.daoDeleteByPrimaryKeyMethodGenerated(method, interfaze, introspectedTable);
    }

    public boolean daoInsertMethodGenerated(org.apache.ibatis.ibator.api.dom.java.Method method, Interface interfaze,
                                            IntrospectedTable introspectedTable) {
        return delegatePlugin.daoInsertMethodGenerated(method, interfaze, introspectedTable);
    }

    public boolean daoInsertSelectiveMethodGenerated(org.apache.ibatis.ibator.api.dom.java.Method method,
                                                     Interface interfaze, IntrospectedTable introspectedTable) {
        return delegatePlugin.daoInsertSelectiveMethodGenerated(method, interfaze, introspectedTable);
    }

    public boolean daoSelectByExampleWithBLOBsMethodGenerated(org.apache.ibatis.ibator.api.dom.java.Method method,
                                                              Interface interfaze, IntrospectedTable introspectedTable) {
        return delegatePlugin.daoSelectByExampleWithBLOBsMethodGenerated(method, interfaze, introspectedTable);
    }

    public boolean daoSelectByExampleWithoutBLOBsMethodGenerated(org.apache.ibatis.ibator.api.dom.java.Method method,
                                                                 Interface interfaze, IntrospectedTable introspectedTable) {
        return delegatePlugin.daoSelectByExampleWithoutBLOBsMethodGenerated(method, interfaze, introspectedTable);
    }

    public boolean daoSelectByPrimaryKeyMethodGenerated(org.apache.ibatis.ibator.api.dom.java.Method method,
                                                        Interface interfaze, IntrospectedTable introspectedTable) {
        return delegatePlugin.daoSelectByPrimaryKeyMethodGenerated(method, interfaze, introspectedTable);
    }

    public boolean daoUpdateByExampleSelectiveMethodGenerated(org.apache.ibatis.ibator.api.dom.java.Method method,
                                                              Interface interfaze, IntrospectedTable introspectedTable) {
        return delegatePlugin.daoUpdateByExampleSelectiveMethodGenerated(method, interfaze, introspectedTable);
    }

    public boolean daoUpdateByExampleWithBLOBsMethodGenerated(org.apache.ibatis.ibator.api.dom.java.Method method,
                                                              Interface interfaze, IntrospectedTable introspectedTable) {
        return delegatePlugin.daoUpdateByExampleWithBLOBsMethodGenerated(method, interfaze, introspectedTable);
    }

    public boolean daoUpdateByExampleWithoutBLOBsMethodGenerated(org.apache.ibatis.ibator.api.dom.java.Method method,
                                                                 Interface interfaze, IntrospectedTable introspectedTable) {
        return delegatePlugin.daoUpdateByExampleWithoutBLOBsMethodGenerated(method, interfaze, introspectedTable);
    }

    public boolean daoUpdateByPrimaryKeySelectiveMethodGenerated(org.apache.ibatis.ibator.api.dom.java.Method method,
                                                                 Interface interfaze, IntrospectedTable introspectedTable) {
        return delegatePlugin.daoUpdateByPrimaryKeySelectiveMethodGenerated(method, interfaze, introspectedTable);
    }

    public boolean daoUpdateByPrimaryKeyWithBLOBsMethodGenerated(org.apache.ibatis.ibator.api.dom.java.Method method,
                                                                 Interface interfaze, IntrospectedTable introspectedTable) {
        return delegatePlugin.daoUpdateByPrimaryKeyWithBLOBsMethodGenerated(method, interfaze, introspectedTable);
    }

    public boolean daoUpdateByPrimaryKeyWithoutBLOBsMethodGenerated(org.apache.ibatis.ibator.api.dom.java.Method method,
                                                                    Interface interfaze, IntrospectedTable introspectedTable) {
        return delegatePlugin.daoUpdateByPrimaryKeyWithoutBLOBsMethodGenerated(method, interfaze, introspectedTable);
    }

    public boolean modelFieldGenerated(Field field, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn,
                                       IntrospectedTable introspectedTable, ModelClassType modelClassType) {
        return delegatePlugin.modelFieldGenerated(field, topLevelClass, introspectedColumn, introspectedTable,
                modelClassType);
    }

    public boolean modelGetterMethodGenerated(org.apache.ibatis.ibator.api.dom.java.Method method,
                                              TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable,
                                              ModelClassType modelClassType) {
        return delegatePlugin.modelGetterMethodGenerated(method, topLevelClass, introspectedColumn, introspectedTable,
                modelClassType);
    }

    public boolean modelSetterMethodGenerated(org.apache.ibatis.ibator.api.dom.java.Method method,
                                              TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable,
                                              ModelClassType modelClassType) {
        return delegatePlugin.modelSetterMethodGenerated(method, topLevelClass, introspectedColumn, introspectedTable,
                modelClassType);
    }

    public boolean modelPrimaryKeyClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return delegatePlugin.modelPrimaryKeyClassGenerated(topLevelClass, introspectedTable);
    }

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return delegatePlugin.modelBaseRecordClassGenerated(topLevelClass, introspectedTable);
    }

    public boolean modelRecordWithBLOBsClassGenerated(TopLevelClass topLevelClass,
                                                      IntrospectedTable introspectedTable) {
        return delegatePlugin.modelRecordWithBLOBsClassGenerated(topLevelClass, introspectedTable);
    }

    public boolean modelExampleClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return delegatePlugin.modelExampleClassGenerated(topLevelClass, introspectedTable);
    }

    public boolean sqlMapGenerated(GeneratedXmlFile sqlMap, IntrospectedTable introspectedTable) {
        return delegatePlugin.sqlMapGenerated(sqlMap, introspectedTable);
    }

    public boolean sqlMapDocumentGenerated(Document document, IntrospectedTable introspectedTable) {
        return delegatePlugin.sqlMapDocumentGenerated(document, introspectedTable);
    }

    public boolean sqlMapResultMapWithoutBLOBsElementGenerated(XmlElement element,
                                                               IntrospectedTable introspectedTable) {
        return delegatePlugin.sqlMapResultMapWithoutBLOBsElementGenerated(element, introspectedTable);
    }

    public boolean sqlMapCountByExampleElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return delegatePlugin.sqlMapCountByExampleElementGenerated(element, introspectedTable);
    }

    public boolean sqlMapDeleteByExampleElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return delegatePlugin.sqlMapDeleteByExampleElementGenerated(element, introspectedTable);
    }

    public boolean sqlMapDeleteByPrimaryKeyElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return delegatePlugin.sqlMapDeleteByPrimaryKeyElementGenerated(element, introspectedTable);
    }

    public boolean sqlMapExampleWhereClauseElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return delegatePlugin.sqlMapExampleWhereClauseElementGenerated(element, introspectedTable);
    }

    public boolean sqlMapInsertElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return delegatePlugin.sqlMapInsertElementGenerated(element, introspectedTable);
    }

    public boolean sqlMapInsertSelectiveElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return delegatePlugin.sqlMapInsertSelectiveElementGenerated(element, introspectedTable);
    }

    public boolean sqlMapResultMapWithBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return delegatePlugin.sqlMapResultMapWithBLOBsElementGenerated(element, introspectedTable);
    }

    public boolean sqlMapSelectByPrimaryKeyElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return delegatePlugin.sqlMapSelectByPrimaryKeyElementGenerated(element, introspectedTable);
    }

    public boolean sqlMapSelectByExampleWithoutBLOBsElementGenerated(XmlElement element,
                                                                     IntrospectedTable introspectedTable) {
        return delegatePlugin.sqlMapSelectByExampleWithoutBLOBsElementGenerated(element, introspectedTable);
    }

    public boolean sqlMapSelectByExampleWithBLOBsElementGenerated(XmlElement element,
                                                                  IntrospectedTable introspectedTable) {
        return delegatePlugin.sqlMapSelectByExampleWithBLOBsElementGenerated(element, introspectedTable);
    }

    public boolean sqlMapUpdateByExampleSelectiveElementGenerated(XmlElement element,
                                                                  IntrospectedTable introspectedTable) {
        return delegatePlugin.sqlMapUpdateByExampleSelectiveElementGenerated(element, introspectedTable);
    }

    public boolean sqlMapUpdateByExampleWithBLOBsElementGenerated(XmlElement element,
                                                                  IntrospectedTable introspectedTable) {
        return delegatePlugin.sqlMapUpdateByExampleWithBLOBsElementGenerated(element, introspectedTable);
    }

    public boolean sqlMapUpdateByExampleWithoutBLOBsElementGenerated(XmlElement element,
                                                                     IntrospectedTable introspectedTable) {
        return delegatePlugin.sqlMapUpdateByExampleWithoutBLOBsElementGenerated(element, introspectedTable);
    }

    public boolean sqlMapUpdateByPrimaryKeySelectiveElementGenerated(XmlElement element,
                                                                     IntrospectedTable introspectedTable) {
        return delegatePlugin.sqlMapUpdateByPrimaryKeySelectiveElementGenerated(element, introspectedTable);
    }

    public boolean sqlMapUpdateByPrimaryKeyWithBLOBsElementGenerated(XmlElement element,
                                                                     IntrospectedTable introspectedTable) {
        return delegatePlugin.sqlMapUpdateByPrimaryKeyWithBLOBsElementGenerated(element, introspectedTable);
    }

    public boolean sqlMapUpdateByPrimaryKeyWithoutBLOBsElementGenerated(XmlElement element,
                                                                        IntrospectedTable introspectedTable) {
        return delegatePlugin.sqlMapUpdateByPrimaryKeyWithoutBLOBsElementGenerated(element, introspectedTable);
    }

    @Override
    public boolean validate(List<String> warnings) {




        return true;
    }

}
