/**
 * Project: ibator_koubei
 * 
 * File Created at 2009-10-20
 */
package com.koubei.abator;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.ibatis.ibator.config.IbatorContext;
import org.apache.ibatis.ibator.config.ModelType;
import org.apache.ibatis.ibator.config.TableConfiguration;
import org.apache.ibatis.ibator.internal.util.JavaBeansUtil;


public class KoubeiTableConfiguration extends TableConfiguration {

	public KoubeiTableConfiguration(String tableName,
			IbatorContext ibatorContext) {
		super(ibatorContext);
		this.setTableName(tableName);
		this.addProperty("useActualColumnNames", "false");
	}

	@Override
	public String getDomainObjectName() {
		return JavaBeansUtil.getCamelCaseString(this.getTableName(), true);
	}

	@Override
	public boolean areAnyStatementsEnabled() {
		return true;
	}
	@Override
	public ModelType getModelType() {
		return ModelType.FLAT;
	}
	@Override
	public boolean isColumnIgnored(String columnName) {
		return false;
	}

	@Override
	public boolean isCountByExampleStatementEnabled() {
		return true;
	}

	@Override
	public boolean isDeleteByExampleStatementEnabled() {
		return true;
	}

	@Override
	public boolean isDeleteByPrimaryKeyStatementEnabled() {
		return true;
	}

	// @Override
	// public boolean isDelimitIdentifiers() {
	//		
	// return super.isDelimitIdentifiers();
	// }

	@Override
	public boolean isInsertStatementEnabled() {
		return true;
	}

	@Override
	public boolean isSelectByExampleStatementEnabled() {
		return true;
	}

	@Override
	public boolean isSelectByPrimaryKeyStatementEnabled() {
		return true;
	}

	@Override
	public boolean isUpdateByExampleStatementEnabled() {
		return true;
	}

	@Override
	public boolean isUpdateByPrimaryKeyStatementEnabled() {
		return false;
	}

	@Override
	public boolean isWildcardEscapingEnabled() {
		return false;
	}

	private static final Pattern p1 = Pattern.compile("[^_]+");
	public static void main(String[] arg) {
		// System.out.println( "".replaceAll("[a]+(\\d+)","$1" ));

		Matcher m = p1.matcher("ddddd_jjjj_llll");
		// m.r
	}
}
