/**
 * Project: ibator_koubei
 * 
 * File Created at 2009-10-13
 */
package com.koubei.abator;

import java.util.List;

import org.apache.ibatis.ibator.api.IntrospectedColumn;
import org.apache.ibatis.ibator.api.ProgressCallback;
import org.apache.ibatis.ibator.api.dom.xml.Attribute;
import org.apache.ibatis.ibator.api.dom.xml.TextElement;
import org.apache.ibatis.ibator.api.dom.xml.XmlElement;
import org.apache.ibatis.ibator.config.GeneratedKey;
import org.apache.ibatis.ibator.generator.AbstractJavaGenerator;
import org.apache.ibatis.ibator.generator.ibatis2.IntrospectedTableIbatis2Java2Impl;
import org.apache.ibatis.ibator.generator.ibatis2.model.BaseRecordGenerator;
import org.apache.ibatis.ibator.generator.ibatis2.model.ExampleGenerator;
import org.apache.ibatis.ibator.generator.ibatis2.model.PrimaryKeyGenerator;

public class KoubeiIntrospectedTableIbatis2Java2Impl extends IntrospectedTableIbatis2Java2Impl {

	@Override
	public final boolean isJava5Targeted() {
		return true;
	}

	// @Override
	// public void setTableConfiguration(TableConfiguration tableConfiguration)
	// {
	// // super.setTableConfiguration(tableConfiguration);
	// }

	@Override
	public String getDAOImplementationPackage() {
		return super.getDAOImplementationPackage() + ".impl";
	}

	@Override
	protected void calculateJavaModelGenerators(List<String> warnings, ProgressCallback progressCallback) {

		// if (getRules().generateExampleClass()) {
		AbstractJavaGenerator javaGenerator = new ExampleGenerator(isJava5Targeted());
		initializeAbstractGenerator(javaGenerator, warnings, progressCallback);
		javaModelGenerators.add(javaGenerator);
		// }

		if (getRules().generatePrimaryKeyClass()) {
			javaGenerator = new PrimaryKeyGenerator();
			initializeAbstractGenerator(javaGenerator, warnings, progressCallback);
			javaModelGenerators.add(javaGenerator);
		}

		if (getRules().generateBaseRecordClass()) {
			javaGenerator = new BaseRecordGenerator();
			initializeAbstractGenerator(javaGenerator, warnings, progressCallback);
			javaModelGenerators.add(javaGenerator);
		}

		// if (getRules().generateRecordWithBLOBsClass()) {
		// javaGenerator = new RecordWithBLOBsGenerator();
		// initializeAbstractGenerator(javaGenerator, warnings,
		// progressCallback);
		// javaModelGenerators.add(javaGenerator);
		// }
	}

	@Override
	public GeneratedKey getGeneratedKey() {

		for (IntrospectedColumn column : this.getAllColumns()) {
			if (column.isAutoIncreasement()) {
				// String column, String configuredSqlStatement, boolean
				// isIdentity, String type
				return new GeneratedKey(column.getActualColumnName(), "SELECT LAST_INSERT_ID();", false,
						column.getFullyQualifiedJavaType().getFullyQualifiedName()) {
					@Override
					public XmlElement toXmlElement() {

						XmlElement xmlElement = new XmlElement("selectKey"); //$NON-NLS-1$
						xmlElement.addAttribute(new Attribute("resultClass", getType())); //$NON-NLS-1$

						xmlElement.addElement(new TextElement(getRuntimeSqlStatement()));

						return xmlElement;
					}

				};
			}
		}

		// return super.getGeneratedKey();

		return null;
	}
}
