package com.koubei.abator;

import java.util.Arrays;
import java.util.List;

import org.apache.ibatis.ibator.api.GeneratedJavaFile;
import org.apache.ibatis.ibator.api.GeneratedXmlFile;
import org.apache.ibatis.ibator.api.IbatorPlugin;
import org.apache.ibatis.ibator.api.IbatorPluginAdapter;
import org.apache.ibatis.ibator.api.IntrospectedColumn;
import org.apache.ibatis.ibator.api.IntrospectedTable;
import org.apache.ibatis.ibator.api.dom.java.CompilationUnit;
import org.apache.ibatis.ibator.api.dom.java.Field;
import org.apache.ibatis.ibator.api.dom.java.FullyQualifiedJavaType;
import org.apache.ibatis.ibator.api.dom.java.Interface;
import org.apache.ibatis.ibator.api.dom.java.JavaElement;
import org.apache.ibatis.ibator.api.dom.java.JavaVisibility;
import org.apache.ibatis.ibator.api.dom.java.Method;
import org.apache.ibatis.ibator.api.dom.java.Parameter;
import org.apache.ibatis.ibator.api.dom.java.TopLevelClass;
import org.apache.ibatis.ibator.internal.util.StringUtility;

import com.koubei.abator.KoubeiIbatorRunner.PojoExtendsClass;
import com.koubei.abator.xml.SpringDocument;

/**
 * 2011-2-12
 */
public class KoubeiIbatorPlugin extends IbatorPluginAdapter {
    public static final String MAPNAME_SELECT_TARGET_COLS = "ibatorgenerated_selectTargetColsByExample";

    @Override
    public boolean validate(List<String> warnings) {
        return true;
    }

    @Override
    public List<GeneratedJavaFile> contextGenerateAdditionalJavaFiles(List<IntrospectedTable> introspectedTables) {

        // List<GeneratedJavaFile> x
        // Interface inface = new Interface(
        // new
        // FullyQualifiedJavaType(this.ibatorContext.getDaoGeneratorConfiguration().getTargetPackage()
        // + ".I"
        // + this.ibatorContext.getFacadeClassNamePrefix() + "DAOFacade"));

        Interface inface = new Interface(new FullyQualifiedJavaType(this.ibatorContext.getFacadeFullClassName()));

        inface.setVisibility(JavaVisibility.PUBLIC);
        TopLevelClass daoimpl = new TopLevelClass(this.ibatorContext.getDAOFacadeImpl());
        daoimpl.setVisibility(JavaVisibility.PUBLIC);
        daoimpl.addImportedType(inface.getType());

        Method method = null;
        Method daoimplConstruct = new Method();
        daoimplConstruct.setConstructor(true);

        daoimplConstruct.setVisibility(JavaVisibility.PUBLIC);
        daoimplConstruct.setName(daoimpl.getType().getShortName());

        daoimpl.addSuperInterface(inface.getType());

        for (IntrospectedTable tab : introspectedTables) {
            method = new Method();
            method.setName(tab.getDAOGetMethod());
            method.setReturnType(tab.getDAOInterfaceType());
            method.setVisibility(JavaVisibility.PUBLIC);
            // method.addBodyLine("return this." + tab.getDAOObjName() + ";");

            inface.addImportedType(tab.getDAOInterfaceType());
            inface.addMethod(method);

            method = new Method(method);
            method.addBodyLine("return this." + tab.getDAOObjName() + ";");
            daoimpl.addMethod(method);
            daoimpl.addImportedType(tab.getDAOInterfaceType());

            Field field = new Field();
            field.setName(tab.getDAOObjName());
            field.setFinal(true);
            field.setType(tab.getDAOInterfaceType());
            field.setVisibility(JavaVisibility.PRIVATE);
            daoimpl.addField(field);

            daoimplConstruct.addParameter(new Parameter(tab.getDAOInterfaceType(), tab.getDAOObjName()));

            daoimplConstruct.addBodyLine("this." + tab.getDAOObjName() + " = " + tab.getDAOObjName() + ";");
        }

        daoimpl.addMethod(daoimplConstruct);

        GeneratedJavaFile interfaceJavaFile = new GeneratedJavaFile(inface, this.ibatorContext.getOutputDir());

        GeneratedJavaFile daoimplJavaFile = new GeneratedJavaFile(daoimpl, this.ibatorContext.getOutputDir());

        return Arrays.asList(interfaceJavaFile, daoimplJavaFile);

    }

    // 当全部的xml配置文件生成之后，再生成spring配置文件
    @Override
    public List<GeneratedXmlFile> contextGenerateAdditionalXmlFiles(List<IntrospectedTable> introspectedTables) {

        SpringDocument document = new SpringDocument(this.ibatorContext);

        for (IntrospectedTable tab : introspectedTables) {
            document.addDaoConfig(tab);
        }

        // data source配置
        document.addDatasource();

        // basic dao 配置.
        document.addBasicDAO();

        // facad 配置类创建

        document.addFacadeImpl(introspectedTables);

        GeneratedXmlFile xmlFile = new GeneratedXmlFile(document, ibatorContext.getDatabaseName() + "-dao-context.xml",
                "conf", this.getIbatorContext().getOutputDir(), true);

        return Arrays.asList(xmlFile);
    }

    @Override
    public boolean modelExampleClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {

        FullyQualifiedJavaType superClazz = new FullyQualifiedJavaType(
                this.ibatorContext.getUserConfig().getDependencyPackageParentName() + ".BasicCriteria");
        topLevelClass.addImportedType(superClazz);
        topLevelClass.setSuperClass(superClazz);

        return true;
    }

    @Override
    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {

        // BaiSui add for customer extends super class
        IUserDefineProperties userProp = this.ibatorContext.getUserConfig();
        PojoExtendsClass extendsClass = null;
        if (userProp != null && (extendsClass = userProp.getPojoExtendsClass()) != null) {
            final FullyQualifiedJavaType extendClass = new FullyQualifiedJavaType(extendsClass.getFullClassName());
            topLevelClass.setSuperClass(extendClass);
            topLevelClass.addImportedType(extendClass);
        }

        // final FullyQualifiedJavaType serializableInterface = new
        // FullyQualifiedJavaType(
        // "java.io.Serializable");
        //
        // topLevelClass.addImportedType(serializableInterface);
        //
        // topLevelClass.addSuperInterface(serializableInterface);

        return true;
    }

    private void addTableColumnComment(JavaElement element, IntrospectedColumn introspectedColumn, String prefix) {
        if (StringUtility.stringHasValue(introspectedColumn.getDescription())) {
            // add base java data descript
            element.addJavaDocLine("/**");
            element.addJavaDocLine("* " + (StringUtility.stringHasValue(prefix) ? (prefix + ":") : "")
                    + introspectedColumn.getDescription());
            element.addJavaDocLine("*/");
        }
    }

    @Override
    public boolean modelGetterMethodGenerated(Method method, TopLevelClass topLevelClass,
                                              IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, ModelClassType modelClassType) {

        addTableColumnComment(method, introspectedColumn, "get");

        return true;
    }

    @Override
    public boolean modelSetterMethodGenerated(Method method, TopLevelClass topLevelClass,
                                              IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, ModelClassType modelClassType) {
        addTableColumnComment(method, introspectedColumn, "set");
        return true;
    }

    @Override
    public boolean modelFieldGenerated(Field field, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn,
                                       IntrospectedTable introspectedTable, IbatorPlugin.ModelClassType modelClassType) {

        addTableColumnComment(field, introspectedColumn, "prop");

        return true;
    }

    @Override
    public boolean daoImplementationGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {

        // topLevelClass.addImportedType(new FullyQualifiedJavaType(
        // "com.koubei.persistence.DataAccessException"));

        topLevelClass.setSuperClass(new FullyQualifiedJavaType(
                this.ibatorContext.getUserConfig().getBasicDaoClassFullName()  //
                        + "<" + introspectedTable.getBaseRecordType().getShortName() + "," //
                        + introspectedTable.getExampleType().getShortName() + ">"));

        return true;
    }

    @Override
    public boolean daoSelectByExampleWithoutBLOBsMethodGenerated(Method method, Interface interfaze,
                                                                 IntrospectedTable introspectedTable) {

        Method m = createSelectByExampleWithOutPager(method, introspectedTable, true);
        interfaze.addMethod(m);
        interfaze.addMethod(createSelectColsByExample(method, introspectedTable, interfaze, true));

        return super.daoSelectByExampleWithoutBLOBsMethodGenerated(method, interfaze, introspectedTable);
    }

    // public List<Map<String, Object>> selectColsByExample(TotalpayCriteria
    // example, int page, int pageSize);
    // @SuppressWarnings("all")
    // public List<Map<String, Object>> selectColsByExample(TotalpayCriteria
    // example, int page, int pageSize) {
    // example.setPage(page);
    // example.setPageSize(pageSize);
    //
    //
    // return (List<Map<String, Object>>) this.getSqlMapClientTemplate()
    // .queryForList("totalpay.ibatorgenerated_selectByExample2", example);
    //
    // }


    private Method createSelectColsByExample(Method method, IntrospectedTable introspectedTable,
                                             CompilationUnit compileUnit, boolean inInterface) {
        Method selectColsByExampleMethod = new Method();
        selectColsByExampleMethod.addAnnotation("@SuppressWarnings(\"all\")");
        selectColsByExampleMethod.setName("selectColsByExample");
        selectColsByExampleMethod.setFinal(true);
        selectColsByExampleMethod.setReturnType( //
                new FullyQualifiedJavaType("List<" + IUserDefineProperties.ROW_MAP_CLASS_NAME + ">"));
        selectColsByExampleMethod.setVisibility(JavaVisibility.PUBLIC);

        selectColsByExampleMethod.addParameter(0, new Parameter(introspectedTable.getExampleType(), "example"));
        selectColsByExampleMethod.addParameter(1, new Parameter(FullyQualifiedJavaType.getIntInstance(), "page"));
        selectColsByExampleMethod.addParameter(2, new Parameter(FullyQualifiedJavaType.getIntInstance(), "pageSize"));

        compileUnit.addImportedType(new FullyQualifiedJavaType(this.ibatorContext.getUserConfig().getRowMapClassFullName()));

        if (!inInterface) {

            selectColsByExampleMethod.addBodyLine("example.setPage(page);");
            selectColsByExampleMethod.addBodyLine("example.setPageSize(pageSize);");

            selectColsByExampleMethod.addBodyLine("if(example.isTargetColsEmpty()){");

            selectColsByExampleMethod.addBodyLine("  throw new IllegalStateException(\"criteria "
                    + introspectedTable.getExampleType().getFullyQualifiedName()
                    + " target Cols can not be empty \");");

            selectColsByExampleMethod.addBodyLine("}");

            selectColsByExampleMethod.addBodyLine(
                    "return (List<" + IUserDefineProperties.ROW_MAP_CLASS_NAME + ">) this.getSqlMapClientTemplate().queryForList(\""
                            + introspectedTable.getFullyQualifiedTable().getSqlMapNamespace() + "."
                            + MAPNAME_SELECT_TARGET_COLS + "\", example);");
        }
        return selectColsByExampleMethod;

    }

    private Method createSelectByExampleWithOutPager(Method method, IntrospectedTable introspectedTable,
                                                     boolean inInterface) {
        Method m = new Method();

        m.setName(method.getName());
        m.setVisibility(JavaVisibility.PUBLIC);
        m.setConstructor(false);
        m.setReturnType(new FullyQualifiedJavaType(
                "java.util.List<" + introspectedTable.getBaseRecordType().getShortName() + ">"));
        m.addParameter(new Parameter(introspectedTable.getExampleType(), "criteria"));
        if (!inInterface) {
            m.addBodyLine("return this." + method.getName() + "(criteria,1,100);");
        }
        return m;
    }

    @Override
    public boolean daoSelectByExampleWithoutBLOBsMethodGenerated(Method method, TopLevelClass topLevelClass,
                                                                 IntrospectedTable introspectedTable) {

        topLevelClass.addMethod(createSelectByExampleWithOutPager(method, introspectedTable, false));

        topLevelClass.addMethod(createSelectColsByExample(method, introspectedTable, topLevelClass, false));

        return super.daoSelectByExampleWithoutBLOBsMethodGenerated(method, topLevelClass, introspectedTable);
    }

    @Override
    public boolean daoDeleteByExampleMethodGenerated(Method method, Interface interfaze,
                                                     IntrospectedTable introspectedTable) {

        // 返回值设置成为int类型
        method.setReturnType(FullyQualifiedJavaType.getIntInstance());

        return true;
    }

    @Override
    public boolean daoDeleteByExampleMethodGenerated(Method method, TopLevelClass topLevelClass,
                                                     IntrospectedTable introspectedTable) {

        return true;
    }

    public static void main(String[] arg) {
        System.out.println("123".getClass().isPrimitive());
    }
}
