/**
 * Project: ibator_koubei
 * <p>
 * File Created at 2009-10-12
 */
package com.koubei.abator;

import java.text.MessageFormat;

import org.apache.ibatis.ibator.api.dom.java.FullyQualifiedJavaType;
import org.apache.ibatis.ibator.api.dom.java.JavaVisibility;
import org.apache.ibatis.ibator.api.dom.java.Method;
import org.apache.ibatis.ibator.config.IbatorContext;
import org.apache.ibatis.ibator.generator.ibatis2.dao.templates.AbstractDAOTemplate;

/**
 * @author 百岁 baisui@taobao.com
 * <p>
 * 2011-3-10
 */
public class KoubeiDaoGenerate extends AbstractDAOTemplate {

    private IbatorContext ibatorContext;

    public KoubeiDaoGenerate() {
        System.out.println("ddd");
    }

    public void setIbatorContext(IbatorContext ibatorContext) {
        this.ibatorContext = ibatorContext;
    }

    @Override
    protected void configureConstructorTemplate() {
        Method method = new Method();
        method.setConstructor(true);
        method.setVisibility(JavaVisibility.PUBLIC);
        method.addBodyLine("super();");
        setConstructorTemplate(method);
    }

    @Override
    protected void configureMethods() {
        Method implOperationLoggerMethod = new Method();
        implOperationLoggerMethod.setName("getEntityName");
        implOperationLoggerMethod.setFinal(true);
        implOperationLoggerMethod.setReturnType(FullyQualifiedJavaType.getStringInstance());
        implOperationLoggerMethod.addBodyLine(" return \"{0}\";\n");
        implOperationLoggerMethod.setVisibility(JavaVisibility.PUBLIC);

        this.addMethod(implOperationLoggerMethod);

        // public List<Map<String, Object>> selectColsByExample(TotalpayCriteria
        // example, int page, int pageSize);
        // @SuppressWarnings("all")
        // public List<Map<String, Object>> selectColsByExample(TotalpayCriteria
        // example, int page, int pageSize) {
        // example.setPage(page);
        // example.setPageSize(pageSize);
        //
        //
        // return (List<Map<String, Object>>) this.getSqlMapClientTemplate()
        // .queryForList("totalpay.ibatorgenerated_selectByExample2", example);
        //
        // }

        // Method selectColsByExampleMethod = new Method();
        // selectColsByExampleMethod.addAnnotation("@SuppressWarnings(\"all\")");
        // selectColsByExampleMethod.setName("selectColsByExample");
        // selectColsByExampleMethod.setFinal(true);
        // selectColsByExampleMethod.setReturnType(new
        // FullyQualifiedJavaType("List<Map<String, Object>>"));
        //
        // selectColsByExampleMethod.addParameter(0, new Parameter( ,"example"));
        // selectColsByExampleMethod.addParameter(1, new
        // Parameter(FullyQualifiedJavaType.getIntInstance(),"page") );
        // selectColsByExampleMethod.addParameter(2, new
        // Parameter(FullyQualifiedJavaType.getIntInstance(),"pageSize"));
        //
        // selectColsByExampleMethod.addBodyLine(" return \"{0}\";\n");
        // selectColsByExampleMethod.setVisibility(JavaVisibility.PUBLIC);
        //
        // this.addMethod(selectColsByExampleMethod);

    }

    @Override
    protected void configureDeleteMethodTemplate() {
        setDeleteMethodTemplate(" this.deleteRecords(\"{0}.{1}\", {2});\n");
    }

    @Override
    protected void configureInsertMethodTemplate() {
        setInsertMethodTemplate("this.insert(\"{0}.{1}\", {2});"); //$NON-NLS-1$
    }

    @Override
    protected void configureQueryForListMethodTemplate() {
        setQueryForListMethodTemplate("this.list(\"{0}.{1}\", {2});"); //$NON-NLS-1$
    }

    @Override
    protected void configureQueryForObjectMethodTemplate() {
        setQueryForObjectMethodTemplate("this.load(\"{0}.{1}\", {2});"); //$NON-NLS-1$
    }

    @Override
    protected void configureSuperClass() {

        if (this.ibatorContext == null) {
            throw new IllegalStateException("ibatorContext can not be null");
        }
        //	this.ibatorContext.getUserConfig().getBasicDaoClassFullName()

        setSuperClass(new FullyQualifiedJavaType( //
        		this.ibatorContext.getUserConfig().getBasicDaoClassFullName())); // $NON-NLS-1$

    }

    @Override
    protected void configureUpdateMethodTemplate() {
        setUpdateMethodTemplate("this.updateRecords(\"{0}.{1}\", {2});"); //$NON-NLS-1$
    }

    public static void main(String[] arg) {
        System.out.println(MessageFormat.format(
                "boolean success = this.delete(\"{0}.{1}\", {2}); if(!success)'{throw new DataAccessException(\"delete is falid\");'}",
                new Object[]{"aaa", "bbb", "ccc"}));
    }
}
