/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.util.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.extension.PluginFormProperties;
import com.qlangtech.tis.extension.impl.BaseSubFormProperties;
import com.qlangtech.tis.extension.impl.PropertyType;
import com.qlangtech.tis.extension.impl.RootFormProperties;
import com.qlangtech.tis.trigger.util.JsonUtil;
import com.qlangtech.tis.util.AttrValMap;
import com.qlangtech.tis.util.impl.PluginEqualResult;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;

public class AttrVals
implements AttrValMap.IAttrVals {
    protected final Map<String, JSON> attrValMap;

    public AttrVals(Map<String, JSON> attrValMap) {
        this.attrValMap = attrValMap;
    }

    public static AttrVals parseAttrValMap(Object vals) {
        HashMap attrValMap = Maps.newHashMap();
        if (vals == null) {
            return new AttrVals(attrValMap);
        }
        if (vals instanceof Map) {
            ((Map)vals).forEach((attrName, val) -> {
                try {
                    attrValMap.put(attrName, (JSON)val);
                }
                catch (Exception e) {
                    if (val instanceof String) {
                        JSONObject o = new JSONObject();
                        o.put("_primaryVal", val);
                        attrValMap.put(attrName, o);
                    }
                    throw new RuntimeException("attrName:" + attrName + ",valType:" + val.getClass().getSimpleName(), e);
                }
            });
        }
        return new AttrVals(attrValMap);
    }

    @Override
    public Map<String, JSONObject> asRootFormVals() {
        HashMap result = Maps.newHashMap();
        this.vistAttrValMap((key, val) -> {
            JSON j = val;
            if (!(j instanceof JSONObject)) {
                throw new IllegalStateException("type must be a object:\n" + JsonUtil.toString((Object)j));
            }
            result.put(key, (JSONObject)val);
        });
        return result;
    }

    public JSONObject getAttrVal(String fieldName) {
        JSON prop = this.attrValMap.get(fieldName);
        if (prop != null && !(prop instanceof JSONObject)) {
            throw new IllegalStateException("type must be a object:\n" + JsonUtil.toString((Object)prop));
        }
        return (JSONObject)prop;
    }

    public void setAttrVal(String fieldName, JSON prop) {
        this.attrValMap.put(fieldName, Objects.requireNonNull(prop, "fieldName:" + fieldName + " relevant prop can not be null"));
    }

    public Object getPrimaryVal(String fieldName) {
        JSONObject attrVal = this.getAttrVal(fieldName);
        if (attrVal == null) {
            return null;
        }
        Object val = attrVal.get((Object)"_primaryVal");
        if (val instanceof String) {
            return StringUtils.trimToNull((String)((String)val));
        }
        return val;
    }

    public void setPrimaryVal(String fieldName, Object val) {
        if (val == null) {
            throw new IllegalArgumentException("field:" + fieldName + " relevant val can not be null");
        }
        JSONObject attrVal = this.getAttrVal(fieldName);
        Objects.requireNonNull(attrVal, "field:" + fieldName + " relevatn attrVal can not be null").put("_primaryVal", val);
    }

    @Override
    public Map<String, JSONArray> asSubFormDetails() {
        HashMap result = Maps.newHashMap();
        this.vistAttrValMap((key, val) -> {
            JSON j = val;
            if (!(j instanceof JSONArray)) {
                throw new IllegalStateException("type must be a array:\n" + JsonUtil.toString((Object)j));
            }
            result.put(key, (JSONArray)val);
        });
        return result;
    }

    public void vistAttrValMap(BiConsumer<String, JSON> tabValConsumer) {
        this.attrValMap.entrySet().forEach(entry -> tabValConsumer.accept((String)entry.getKey(), (JSON)entry.getValue()));
    }

    @Override
    public int size() {
        return this.attrValMap.size();
    }

    public PluginEqualResult isPluginEqual(final Describable plugin) {
        Descriptor desc = Objects.requireNonNull(plugin, "plugin can not be null").getDescriptor();
        PluginFormProperties propertyTypes = desc.getPluginFormPropertyTypes();
        return (PluginEqualResult)Objects.requireNonNull(propertyTypes, "propertyTypes can not be null").accept(new PluginFormProperties.IVisitor(){

            public PluginEqualResult visit(RootFormProperties props) {
                try {
                    PropertyType pt = null;
                    String fieldName = null;
                    JSONObject describle = null;
                    for (Map.Entry<String, PropertyType> entry : props.getSortedUseableProperties()) {
                        pt = entry.getValue();
                        fieldName = entry.getKey();
                        Object exist = null;
                        if (pt.isIdentity()) continue;
                        exist = pt.getFrontendOutput(plugin);
                        if (pt.isDescribable()) {
                            describle = AttrVals.this.getAttrVal(fieldName);
                            if (describle == null) {
                                return PluginEqualResult.notEqual("fieldName:" + fieldName + " relevant describle is null");
                            }
                            Object vals = Objects.requireNonNull(describle.getJSONObject("descVal"), "key:descVal relevant json can not be null").get((Object)"vals");
                            if (vals == null) {
                                if (exist == null) continue;
                                return PluginEqualResult.notEqual("fieldName:" + fieldName + " vals is null but exist vals is not null");
                            }
                            if (exist == null) {
                                return PluginEqualResult.notEqual("fieldName:" + fieldName + " relevant exist vals is  null");
                            }
                            PluginEqualResult compareResult = null;
                            compareResult = AttrVals.parseAttrValMap(vals).isPluginEqual((Describable)exist);
                            if (compareResult.equal) continue;
                            return PluginEqualResult.notEqual("desc field:" + fieldName + "," + compareResult.unEqualLogger).setStack(compareResult.stack);
                        }
                        Object primaryVal = AttrVals.this.getPrimaryVal(fieldName);
                        if (primaryVal == null && exist == null) continue;
                        if (primaryVal == null ^ exist == null) {
                            return PluginEqualResult.notEqual("fieldName:" + fieldName + ",primaryVal(" + primaryVal + ") == null ^ exist(\"" + exist + "\") == null");
                        }
                        if (StringUtils.equals((CharSequence)String.valueOf(exist), (CharSequence)String.valueOf(primaryVal))) continue;
                        return PluginEqualResult.notEqual("fieldName:" + fieldName + ",exist(" + exist + ") != " + primaryVal);
                    }
                    return new PluginEqualResult(true, null);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public Void visit(BaseSubFormProperties props) {
                throw new UnsupportedOperationException();
            }
        });
    }
}

