/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.util;

import com.qlangtech.tis.TIS;
import com.qlangtech.tis.extension.PluginManager;
import com.qlangtech.tis.extension.PluginWrapper;
import com.qlangtech.tis.extension.impl.XmlFile;
import com.qlangtech.tis.plugin.IdentityName;
import com.qlangtech.tis.plugin.InnerPropOfIdentityName;
import com.qlangtech.tis.plugin.annotation.ITmpFileStore;
import com.qlangtech.tis.util.AtomicFileWriter;
import com.qlangtech.tis.util.RobustReflectionConverter;
import com.qlangtech.tis.util.RobustReflectionConverter2;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.AbstractReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.JVM;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.XppDriver;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.security.AnyTypePermission;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XStream2
extends XStream {
    private static final Logger logger = LoggerFactory.getLogger(XStream2.class);
    private final XppDriver xppDruver;

    public XStream2(XppDriver xppDruver) {
        super(null, null, (HierarchicalStreamDriver)xppDruver);
        this.xppDruver = xppDruver;
        this.addPermission(AnyTypePermission.ANY);
    }

    public Object unmarshal(HierarchicalStreamReader reader, Object root, DataHolder dataHolder) {
        TIS h = TIS.get();
        if (h != null && h.pluginManager != null && h.pluginManager.uberClassLoader != null) {
            this.setClassLoader(h.pluginManager.uberClassLoader);
        }
        Object o = super.unmarshal(reader, root, dataHolder);
        return o;
    }

    protected void setupConverters() {
        RobustReflectionConverter reflectionConverter = new RobustReflectionConverter(this.getMapper(), this.createReflectionProvider());
        this.registerConverter(reflectionConverter, -20);
        this.registerConverter((Converter)new TISCompositConvert(this.getMapper(), this.getReflectionProvider()), 10000);
        super.setupConverters();
    }

    public ReflectionProvider createReflectionProvider() {
        return JVM.newReflectionProvider();
    }

    public void registerConverter(Converter converter, int priority) {
        if (converter instanceof ReflectionConverter) {
            return;
        }
        super.registerConverter(converter, priority);
    }

    public HierarchicalStreamWriter createHierarchicalStreamWriter(AtomicFileWriter w) {
        return this.xppDruver.createWriter((Writer)w);
    }

    static interface ConverterValve
    extends Converter {
        default public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            throw new UnsupportedOperationException();
        }

        default public void beforeUnmarshal(Object result, HierarchicalStreamReader reader, UnmarshallingContext context) {
        }

        public void doUnmarshal(Object var1, HierarchicalStreamReader var2, UnmarshallingContext var3);
    }

    private static class TempFileConvert
    implements ConverterValve {
        private TempFileConvert() {
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            ITmpFileStore tmpFileStore = (ITmpFileStore)source;
            XmlFile xmlFile = (XmlFile)context.get(XmlFile.class);
            Objects.requireNonNull(xmlFile, "xmlFile can not be null");
            ITmpFileStore.TmpFile tmpfile = tmpFileStore.getTmpeFile();
            ITmpFileStore.TmpFile newTmpFile = null;
            if (tmpfile != null) {
                newTmpFile = tmpfile.saveToDir(xmlFile.getFile().getParentFile(), tmpFileStore.getStoreFileName());
            } else {
                newTmpFile = tmpFileStore.createTmpFile(() -> xmlFile, false);
                if (!newTmpFile.tmp.exists()) {
                    throw new IllegalStateException("file shall exist:" + newTmpFile.tmp.getAbsolutePath());
                }
            }
            tmpFileStore.setTmpeFile(newTmpFile);
        }

        @Override
        public void doUnmarshal(Object result, HierarchicalStreamReader reader, UnmarshallingContext context) {
            ITmpFileStore tmpFileStore = (ITmpFileStore)result;
            XmlFile xmlFile = (XmlFile)context.get(XmlFile.class);
            Objects.requireNonNull(xmlFile, "xmlFile can not be null");
            tmpFileStore.setTmpeFile(tmpFileStore.createTmpFile(() -> xmlFile, false));
        }

        public boolean canConvert(Class type) {
            return ITmpFileStore.class.isAssignableFrom(type);
        }
    }

    private static class TISCompositConvert
    extends AbstractReflectionConverter {
        private final List<ConverterValve> converters = new ArrayList<ConverterValve>();

        public TISCompositConvert(Mapper mapper, ReflectionProvider reflectionProvider) {
            super(mapper, reflectionProvider);
            this.converters.add(new IdentityNameConvert());
            this.converters.add(new InnerPropOfIdentityNameConvert());
            this.converters.add(new TempFileConvert());
            RobustReflectionConverter2 reflectionConverter = new RobustReflectionConverter2(mapper, reflectionProvider, new PluginClassOwnership());
            this.converters.add(reflectionConverter);
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            this.converters.forEach(converter -> {
                if (converter.canConvert(source.getClass())) {
                    converter.marshal(source, writer, context);
                }
            });
            super.marshal(source, writer, context);
        }

        public Object doUnmarshal(Object result, HierarchicalStreamReader reader, UnmarshallingContext context) {
            this.converters.forEach(converter -> {
                if (converter.canConvert(result.getClass())) {
                    converter.beforeUnmarshal(result, reader, context);
                }
            });
            Object fresult = super.doUnmarshal(result, reader, context);
            this.converters.forEach(converter -> {
                if (converter.canConvert(result.getClass())) {
                    converter.doUnmarshal(result, null, context);
                }
            });
            return fresult;
        }

        public boolean canConvert(Class type) {
            for (ConverterValve converter : this.converters) {
                if (!converter.canConvert(type)) continue;
                return true;
            }
            return false;
        }
    }

    public static class InnerPropOfIdentityNameConvert
    implements ConverterValve {
        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            InnerPropOfIdentityName innerProp = (InnerPropOfIdentityName)source;
            IdentityName id = (IdentityName)context.get(IdentityName.class);
            Objects.requireNonNull(id, "id can not be null");
            innerProp.setIdentity(id);
        }

        @Override
        public void doUnmarshal(Object result, HierarchicalStreamReader reader, UnmarshallingContext context) {
            IdentityName id = (IdentityName)context.get(IdentityName.class);
            Objects.requireNonNull(id, "id can not be null");
            InnerPropOfIdentityName innerProp = (InnerPropOfIdentityName)result;
            innerProp.setIdentity(id);
        }

        public boolean canConvert(Class type) {
            return InnerPropOfIdentityName.class.isAssignableFrom(type);
        }
    }

    public static class IdentityNameConvert
    implements ConverterValve {
        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            IdentityName identity = (IdentityName)source;
            context.put(IdentityName.class, (Object)identity);
        }

        @Override
        public void beforeUnmarshal(Object result, HierarchicalStreamReader reader, UnmarshallingContext context) {
            context.put(IdentityName.class, (Object)((IdentityName)result));
        }

        @Override
        public void doUnmarshal(Object result, HierarchicalStreamReader reader, UnmarshallingContext context) {
        }

        public boolean canConvert(Class type) {
            return IdentityName.class.isAssignableFrom(type);
        }
    }

    static class PluginClassOwnership
    implements ClassOwnership {
        private PluginManager pm;

        PluginClassOwnership() {
        }

        @Override
        public String ownerOf(Class<?> clazz) {
            TIS j;
            if (this.pm == null && (j = TIS.get()) != null) {
                this.pm = j.getPluginManager();
            }
            if (this.pm == null) {
                return null;
            }
            PluginWrapper p = this.pm.whichPlugin(clazz);
            return p != null ? p.getDesc().toString() : null;
        }
    }

    static interface ClassOwnership {
        public String ownerOf(Class<?> var1);
    }
}

