/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;

public class Util {
    public static Path fileToPath(File file) throws IOException {
        try {
            return file.toPath();
        }
        catch (InvalidPathException e) {
            throw new IOException(e);
        }
    }

    public static File changeExtension(File dst, String ext) {
        String p = dst.getPath();
        int pos = p.lastIndexOf(46);
        if (pos < 0) {
            return new File(p + ext);
        }
        return new File(p.substring(0, pos) + ext);
    }

    public static String fixEmptyAndTrim(String s) {
        if (s == null) {
            return null;
        }
        return Util.fixEmpty(s.trim());
    }

    public static String fixEmpty(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        return s;
    }

    public static String fixNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public static String intern(String s) {
        return s == null ? s : s.intern();
    }

    public static String join(Collection<?> strings, String separator) {
        return strings.stream().map(r -> r.toString()).collect(Collectors.joining(separator));
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> join(Collection<? extends T> ... items) {
        void var5_8;
        int size = 0;
        for (Collection<T> collection : items) {
            size += collection.size();
        }
        ArrayList<? extends T> r = new ArrayList<T>(size);
        Collection<? extends T>[] collectionArray = items;
        int n = collectionArray.length;
        boolean bl = false;
        while (var5_8 < n) {
            Collection<? extends T> item = collectionArray[var5_8];
            r.addAll(item);
            ++var5_8;
        }
        return r;
    }

    public static void deleteRecursive(File destDir) {
        try {
            FileUtils.forceDelete((File)destDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

