/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.util;

import com.google.common.collect.Lists;
import com.qlangtech.tis.IPluginEnum;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.async.message.client.consumer.impl.MQListenerFactory;
import com.qlangtech.tis.coredefine.module.action.ProcessModel;
import com.qlangtech.tis.datax.DataXName;
import com.qlangtech.tis.datax.StoreResourceType;
import com.qlangtech.tis.datax.impl.DataxReader;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.extension.SubFormFilter;
import com.qlangtech.tis.extension.impl.IncrSourceExtendSelected;
import com.qlangtech.tis.manage.common.AppAndRuntime;
import com.qlangtech.tis.plugin.IEndTypeGetter;
import com.qlangtech.tis.plugin.IPluginStore;
import com.qlangtech.tis.plugin.PluginStore;
import com.qlangtech.tis.plugin.datax.SelectedTab;
import com.qlangtech.tis.plugin.datax.SelectedTabExtend;
import com.qlangtech.tis.pubhook.common.RunEnvironment;
import com.qlangtech.tis.util.HeteroEnum;
import com.qlangtech.tis.util.HeteroList;
import com.qlangtech.tis.util.IPluginContext;
import com.qlangtech.tis.util.IUploadPluginMeta;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class UploadPluginMeta
implements IUploadPluginMeta {
    public static final String KEY_PLUGIN_META = UploadPluginMeta.class.getName();
    public static final String ATTR_KEY_VALUE_SPLIT = "_";
    private static final String KEY_JUST_GET_ITEM_RELEVANT = "justGetItemRelevant";
    private static final Pattern PATTERN_PLUGIN_ATTRIBUTE = Pattern.compile("[_\\-\\w\\.]+");
    public static final Pattern PATTERN_PLUGIN_ATTRIBUTE_KEY_VALUE_PAIR = Pattern.compile("([^_]+?)_(" + PATTERN_PLUGIN_ATTRIBUTE.pattern() + ")");
    private static final Pattern PATTERN_PLUGIN_META = Pattern.compile("(.+?)(:(,?(" + PATTERN_PLUGIN_ATTRIBUTE + "))+)?");
    public static final String KEY_SKIP_PLUGINS_SAVE = "skipPluginSave";
    public static final String KEY_REQUIRE = "require";
    public static final String KEY_UNCACHE = "uncache";
    public static final String KEY_APPEND = "append";
    public static final String KEY_TARGET_PLUGIN_DESC = "targetItemDesc";
    public static String PLUGIN_META_TARGET_DESCRIPTOR_NAME = "targetDescriptorName";
    public static String PLUGIN_META_TARGET_DESCRIPTOR_IMPLEMENTION = "targetDescriptorImpl";
    public static String PLUGIN_META_TARGET_PIPELINE_NAME_AWARE = "targetPipelineNameAware";
    public static final String KEY_DISABLE_BIZ_SET = "disableBizStore";
    private final String name;
    private final boolean useCache;
    private boolean required;
    private Map<String, String> extraParams = new HashMap<String, String>();
    private final IPluginContext context;

    public static UploadPluginMeta appnameMeta(IPluginContext pluginContext, String appname) {
        UploadPluginMeta extMeta = UploadPluginMeta.parse(pluginContext, "name:dataxName_" + appname, true);
        return extMeta;
    }

    public static UploadPluginMeta create(IPluginEnum pluginEnum) {
        return UploadPluginMeta.parse(pluginEnum.identityValue() + ":require");
    }

    private UploadPluginMeta(IPluginContext context, String name, boolean useCache) {
        this.name = name;
        this.context = context;
        this.useCache = useCache;
    }

    public boolean isUpdate() {
        return this.getBoolean("update");
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public UploadPluginMeta putExtraParams(String key, String val) {
        if (StringUtils.isEmpty((String)val)) {
            throw new IllegalArgumentException("key:" + key + " relevant val can not be null");
        }
        this.extraParams.put(key, val);
        return this;
    }

    public boolean isAppend() {
        return this.getBoolean(KEY_APPEND);
    }

    public boolean isDisableBizSet() {
        return this.getBoolean(KEY_DISABLE_BIZ_SET);
    }

    public ProcessModel getProcessModel() {
        return ProcessModel.parse(this.getExtraParam("processModel"));
    }

    public static void main(String[] args) throws Exception {
        Matcher matcher = PATTERN_PLUGIN_ATTRIBUTE_KEY_VALUE_PAIR.matcher("dsname_dsname_yuqing_zj2_bak");
        System.out.println(matcher.matches());
        System.out.println(matcher.group(1));
        System.out.println(matcher.group(2));
    }

    public static List<UploadPluginMeta> parse(String[] plugins) {
        return UploadPluginMeta.parse(null, plugins);
    }

    public static List<UploadPluginMeta> parse(IPluginContext context, String[] plugins) {
        return UploadPluginMeta.parse(context, plugins, true, true).stream().map(meta -> (UploadPluginMeta)meta).collect(Collectors.toList());
    }

    public static List<IUploadPluginMeta> parse(String[] plugins, boolean useCache) {
        return UploadPluginMeta.parse(null, plugins, useCache, true);
    }

    public static List<IUploadPluginMeta> parse(IPluginContext context, String[] plugins, boolean useCache) {
        return UploadPluginMeta.parse(context, plugins, useCache, true);
    }

    public static List<IUploadPluginMeta> parse(IPluginContext context, String[] plugins, boolean useCache, boolean validatePluginEmpty) {
        if (validatePluginEmpty && (plugins == null || plugins.length < 1)) {
            throw new IllegalArgumentException("plugin size:" + plugins.length + " length can not small than 1");
        }
        ArrayList metas = Lists.newArrayList();
        for (String plugin : plugins) {
            metas.add(UploadPluginMeta.parse(context, plugin, useCache));
        }
        if (plugins.length != metas.size()) {
            throw new IllegalStateException("param plugins length:" + plugins.length + " must equal with metaSize:" + metas.size());
        }
        return metas;
    }

    public IPluginContext getPluginContext() {
        return this.context;
    }

    public static UploadPluginMeta parse(String plugin, boolean useCache) {
        return UploadPluginMeta.parse(null, plugin, useCache);
    }

    public static UploadPluginMeta parse(String plugin) {
        return UploadPluginMeta.parse(null, plugin, true);
    }

    public static UploadPluginMeta parse(IPluginContext context, String plugin, boolean useCache) {
        if (StringUtils.endsWith((String)plugin, (String)",")) {
            throw new IllegalStateException("plugin:'" + plugin + "' can not endWith ','");
        }
        Matcher matcher = PATTERN_PLUGIN_META.matcher(plugin);
        if (matcher.matches()) {
            UploadPluginMeta pmeta = new UploadPluginMeta(context, matcher.group(1), useCache);
            if (matcher.group(2) != null) {
                Matcher attrMatcher = PATTERN_PLUGIN_ATTRIBUTE.matcher(matcher.group(2));
                block6: while (attrMatcher.find()) {
                    String attr;
                    switch (attr = attrMatcher.group()) {
                        case "require": {
                            pmeta.required = true;
                            continue block6;
                        }
                    }
                    Matcher attrKVMatcher = PATTERN_PLUGIN_ATTRIBUTE_KEY_VALUE_PAIR.matcher(attr);
                    if (!attrKVMatcher.matches()) {
                        throw new IllegalStateException("attr:" + attr + " is not match:" + PATTERN_PLUGIN_ATTRIBUTE_KEY_VALUE_PAIR.pattern());
                    }
                    pmeta.putExtraParams(attrKVMatcher.group(1), attrKVMatcher.group(2));
                }
            }
            DataXName pipe = pmeta.getDataXName(false);
            AppAndRuntime appAndRuntime = AppAndRuntime.getAppAndRuntime();
            if (pipe != null && (appAndRuntime == null || appAndRuntime.getAppName() == null)) {
                appAndRuntime = new AppAndRuntime();
                appAndRuntime.setRuntime(RunEnvironment.getSysRuntime());
                appAndRuntime.setAppName(pipe);
                AppAndRuntime.setAppAndRuntime((AppAndRuntime)appAndRuntime);
            }
            return pmeta;
        }
        throw new IllegalStateException("plugin:'" + plugin + "' is not match the pattern:" + PATTERN_PLUGIN_META);
    }

    public Pair<List<DataxReader>, IPluginStore<DataxReader>> getDataxReaders(IPluginContext pluginContext) {
        IPluginStore<?> store = HeteroEnum.getDataXReaderAndWriterRelevantPluginStore(pluginContext, true, this);
        return Pair.of(store.getPlugins(), store);
    }

    public IPluginEnum getHeteroEnum() {
        Optional<SubFormFilter> subFormFilter = null;
        subFormFilter = this.getSubFormFilter();
        if (subFormFilter.isPresent()) {
            final SubFormFilter subFilter = subFormFilter.get();
            final boolean[] incrExtend = new boolean[1];
            incrExtend[0] = subFilter.isIncrProcessExtend();
            if (incrExtend[0] || subFilter.isBatchSourceProcessExtend()) {
                final SelectedTabExtend.IncrTabExtendSuit incrTabExtendSuit = SelectedTabExtend.getIncrTabExtendSuit(incrExtend[0], this);
                HeteroEnum<MQListenerFactory> mq = HeteroEnum.MQ;
                return new HeteroEnum(mq.extensionPoint, mq.identity, mq.caption, mq.selectable, mq.isAppNameAware()){

                    @Override
                    public List getPlugins(IPluginContext pluginContext, UploadPluginMeta pluginMeta) {
                        if (subFilter.subformDetailView) {
                            String subformDetailId;
                            SelectedTab ext = null;
                            Map<String, SelectedTab> tabsExtend = SelectedTabExtend.getTabExtend(pluginMeta, new PluginStore.PluginsUpdateListener[0]);
                            ext = tabsExtend.get(subformDetailId = subFilter.subformDetailId);
                            if (ext == null) {
                                return Collections.emptyList();
                            }
                            return incrExtend[0] ? ext.getIncrExtProp() : Collections.singletonList(ext.getSourceProps());
                        }
                        return (List)pluginMeta.getDataxReaders(pluginContext).getKey();
                    }

                    @Override
                    public IPluginStore getPluginStore(IPluginContext pluginContext, UploadPluginMeta pluginMeta) {
                        return (incrExtend[0] ? SelectedTabExtend.INCR_SELECTED_TAB_EXTEND : SelectedTabExtend.BATCH_SOURCE_SELECTED_TAB_EXTEND).getPluginStore(pluginContext, pluginMeta);
                    }

                    @Override
                    public List<Descriptor> descriptors() {
                        Descriptor selectedTabClassDesc = TIS.get().getDescriptor(IncrSourceExtendSelected.selectedTabClass);
                        return subFilter.subformDetailView ? incrTabExtendSuit.getDescriptors() : incrTabExtendSuit.getDescriptorsWithAppendDesc(selectedTabClassDesc);
                    }
                };
            }
        }
        return HeteroEnum.of(this.getName());
    }

    public String getName() {
        return this.name;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public Optional<SubFormFilter> getSubFormFilter() {
        TargetDesc targetDesc = this.getTargetDesc();
        String subFormField = this.getExtraParam(SubFormFilter.PLUGIN_META_SUB_FORM_FIELD);
        if (StringUtils.isNotEmpty((String)targetDesc.descDisplayName) && StringUtils.isNotEmpty((String)subFormField)) {
            return Optional.of(new SubFormFilter(this, targetDesc, subFormField));
        }
        return Optional.empty();
    }

    public TargetDesc getTargetDesc() {
        return TargetDesc.create(this);
    }

    public String getExtraParam(String key) {
        return this.extraParams.get(key);
    }

    public boolean getBoolean(String key) {
        return Boolean.parseBoolean(this.getExtraParam(key));
    }

    public DataXName getDataXName(boolean validateNull) {
        String dataxName = this.getExtraParam("dataxName");
        if (StringUtils.isNotEmpty((String)dataxName)) {
            return new DataXName(dataxName, this.getProcessModel().resType);
        }
        String dbName = this.getExtraParam("dataxDB");
        if (StringUtils.isNotEmpty((String)dbName)) {
            return new DataXName(dbName, StoreResourceType.DataBase);
        }
        if (validateNull) {
            throw new IllegalArgumentException("plugin extra param 'DataxUtils.DATAX_NAME'dataxName can not be null");
        }
        return null;
    }

    public boolean isTest() {
        return Boolean.parseBoolean(this.getExtraParam("test"));
    }

    public DataXName getDataXName() {
        StoreResourceType resType = this.getProcessModel().resType;
        DataXName dataXName = this.getDataXName(true);
        if (dataXName.getType() != StoreResourceType.DataBase && dataXName.getType() != resType) {
            throw new IllegalStateException("dataXName.getType():" + dataXName.getType() + " must be equal with resType:" + resType);
        }
        return dataXName;
    }

    public String toString() {
        return "UploadPluginMeta{name='" + this.name + "', required=" + this.required + "," + this.extraParams.entrySet().stream().map(e -> (String)e.getKey() + ":" + (String)e.getValue()).collect(Collectors.joining(",")) + "}";
    }

    public <T extends Describable<T>> HeteroList<T> createEmptyItemAndDescriptorsHetero() {
        IPluginEnum hEnum = this.getHeteroEnum();
        HeteroList hList = new HeteroList(this);
        hList.setCaption(hEnum.getCaption());
        hList.setIdentityId(hEnum.getIdentity());
        hList.setExtensionPoint(hEnum.getExtensionPoint());
        hList.setSelectable(hEnum.getSelectable());
        return hList;
    }

    public <T extends Describable<T>> HeteroList<T> getHeteroList(IPluginContext pluginContext) {
        IPluginEnum hEnum = this.getHeteroEnum();
        HeteroList hList = this.createEmptyItemAndDescriptorsHetero();
        List items = hEnum.getPlugins(pluginContext, this);
        hList.setItems(items);
        TargetDesc targetDesc = this.getTargetDesc();
        boolean justGetItemRelevant = this.getBoolean(KEY_JUST_GET_ITEM_RELEVANT);
        List descriptors = hEnum.descriptors(targetDesc, items, justGetItemRelevant);
        hList.setDescriptors(targetDesc.endType.map(end -> descriptors.stream().filter(desc -> {
            if (desc instanceof IEndTypeGetter) {
                return ((IEndTypeGetter)((Object)desc)).getEndType() == end;
            }
            return false;
        }).collect(Collectors.toList())).orElse(descriptors));
        return hList;
    }

    public static class TargetDesc {
        public final String descDisplayName;
        public final String impl;
        public final String matchTargetPluginDescName;
        private final boolean pipelineNameAware;
        private final Optional<IEndTypeGetter.EndType> endType;

        public static final TargetDesc create(UploadPluginMeta meta) {
            return new TargetDesc(meta.getExtraParam(UploadPluginMeta.KEY_TARGET_PLUGIN_DESC), meta.getExtraParam(PLUGIN_META_TARGET_DESCRIPTOR_NAME), meta.getExtraParam(PLUGIN_META_TARGET_DESCRIPTOR_IMPLEMENTION), meta.getBoolean(PLUGIN_META_TARGET_PIPELINE_NAME_AWARE), Optional.ofNullable(IEndTypeGetter.EndType.parse(meta.getExtraParam(IEndTypeGetter.EndType.KEY_END_TYPE), true, false)));
        }

        public String pluginStoreGroupPath(UploadPluginMeta meta) {
            StringBuffer result = new StringBuffer(this.matchTargetPluginDescName);
            if (this.pipelineNameAware) {
                result.append(File.separator).append(Objects.requireNonNull(meta, "meta can not be null").getPluginContext().getCollectionName());
            }
            return result.toString();
        }

        public Descriptor getTargetDescriptor() {
            Descriptor parentDesc = Objects.requireNonNull(TIS.get().getDescriptor(this.impl), this + "->" + this.impl + " relevant desc can not be null");
            return parentDesc;
        }

        private TargetDesc(String matchTargetPluginDescName, String name, String impl, boolean pipelineNameAware, Optional<IEndTypeGetter.EndType> endType) {
            this.matchTargetPluginDescName = matchTargetPluginDescName;
            this.descDisplayName = name;
            this.impl = impl;
            this.pipelineNameAware = pipelineNameAware;
            this.endType = endType;
        }

        public boolean shallMatchTargetDesc() {
            return StringUtils.isNotEmpty((String)this.matchTargetPluginDescName);
        }

        public boolean isNameMatch(String displayName) {
            return "incr_process_extend".equals(this.matchTargetPluginDescName) || StringUtils.equals((String)displayName, (String)this.matchTargetPluginDescName);
        }

        public String toString() {
            return "TargetDesc{descDisplayName='" + this.descDisplayName + "', impl='" + this.impl + "', matchTargetPluginDescName='" + this.matchTargetPluginDescName + "'}";
        }
    }
}

