/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.util;

import com.google.common.collect.Lists;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.plugin.IPluginMetasInfo;
import com.qlangtech.tis.plugin.IRepositoryResource;
import com.qlangtech.tis.util.PluginMeta;
import com.qlangtech.tis.util.XStream2;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.SerializationMethodInvoker;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RobustReflectionConverter2
implements XStream2.ConverterValve {
    public static final String KEY_ATT_PLUGIN = "plugin";
    public static ThreadLocal<PluginMetas> usedPluginInfo = new ThreadLocal<PluginMetas>(){

        @Override
        protected PluginMetas initialValue() {
            return new PluginMetas();
        }

        @Override
        public void remove() {
            super.remove();
        }
    };
    protected final ReflectionProvider reflectionProvider;
    protected final Mapper mapper;
    protected transient SerializationMethodInvoker serializationMethodInvoker;
    private transient ReflectionProvider pureJavaReflectionProvider;
    private final XStream2.ClassOwnership classOwnership;
    private final ReadWriteLock criticalFieldsLock = new ReentrantReadWriteLock();
    private final Map<String, Set<String>> criticalFields = new HashMap<String, Set<String>>();
    private static final Logger LOGGER = LoggerFactory.getLogger(RobustReflectionConverter2.class);

    public static PluginMetas getUnCacheableThreadMetas() {
        usedPluginInfo.remove();
        PluginMetas metas = usedPluginInfo.get();
        return metas.unCacheableFromPluginStore();
    }

    public RobustReflectionConverter2(Mapper mapper, ReflectionProvider reflectionProvider) {
        this(mapper, reflectionProvider, new XStream2.PluginClassOwnership());
    }

    RobustReflectionConverter2(Mapper mapper, ReflectionProvider reflectionProvider, XStream2.ClassOwnership classOwnership) {
        this.mapper = mapper;
        this.reflectionProvider = reflectionProvider;
        assert (classOwnership != null);
        this.classOwnership = classOwnership;
        this.serializationMethodInvoker = new SerializationMethodInvoker();
    }

    void addCriticalField(Class<?> clazz, String field) {
        this.criticalFieldsLock.writeLock().lock();
        try {
            if (!this.criticalFields.containsKey(field)) {
                this.criticalFields.put(field, new HashSet());
            }
            this.criticalFields.get(field).add(clazz.getName());
        }
        finally {
            this.criticalFieldsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasCriticalField(Class<?> clazz, String field) {
        this.criticalFieldsLock.readLock().lock();
        try {
            Set<String> classesWithField = this.criticalFields.get(field);
            if (classesWithField == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = classesWithField.contains(clazz.getName());
            return bl;
        }
        finally {
            this.criticalFieldsLock.readLock().unlock();
        }
    }

    public boolean canConvert(Class type) {
        return Describable.class.isAssignableFrom(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Object original, HierarchicalStreamWriter writer, MarshallingContext context) {
        Object source = this.serializationMethodInvoker.callWriteReplace(original);
        if (source.getClass() != original.getClass()) {
            writer.addAttribute(this.mapper.aliasForAttribute("resolves-to"), this.mapper.serializedClass(source.getClass()));
        }
        OwnerContext oc = OwnerContext.find(context);
        Set pluginMeta = (Set)context.get(PluginMeta.class);
        ArrayList owners = Lists.newArrayList();
        owners.add(this.classOwnership.ownerOf(original.getClass()));
        if (pluginMeta != null && pluginMeta.size() > 0) {
            try {
                for (PluginMeta pmeta : pluginMeta) {
                    owners.add(pmeta.toString());
                }
            }
            finally {
                pluginMeta.clear();
            }
        }
        oc.startVisiting(writer, owners);
        oc.stopVisiting();
    }

    @Override
    public void beforeUnmarshal(Object result, HierarchicalStreamReader reader, UnmarshallingContext context) {
        Iterator it = reader.getAttributeNames();
        while (it.hasNext()) {
            String attrAlias = (String)it.next();
            String attrName = this.mapper.attributeForAlias(attrAlias);
            boolean fieldExistsInClass = this.fieldDefinedInClass(result, attrName);
            if (!KEY_ATT_PLUGIN.equals(attrAlias) || fieldExistsInClass) continue;
            List<PluginMeta> metas = PluginMeta.parse(reader.getAttribute(attrAlias));
            Set metasCollector = (Set)context.get(PluginMeta.class);
            if (metasCollector == null) continue;
            metasCollector.addAll(metas);
        }
    }

    @Override
    public void doUnmarshal(Object result, HierarchicalStreamReader reader, UnmarshallingContext context) {
        if (context.get((Object)"ReadError") != null && context.get((Object)"Saveable") == result) {
            context.put((Object)"ReadError", null);
        }
    }

    public static void addErrorInContext(UnmarshallingContext context, Throwable e) {
        ArrayList<Throwable> list = (ArrayList<Throwable>)context.get((Object)"ReadError");
        if (list == null) {
            list = new ArrayList<Throwable>();
            context.put((Object)"ReadError", list);
        }
        list.add(e);
    }

    private boolean fieldDefinedInClass(Object result, String attrName) {
        return this.reflectionProvider.getFieldOrNull(result.getClass(), attrName) != null;
    }

    protected Object unmarshalField(UnmarshallingContext context, Object result, Class type, Field field) {
        Converter converter = this.mapper.getLocalConverter(field.getDeclaringClass(), field.getName());
        return context.convertAnother(result, type, converter);
    }

    private Map writeValueToImplicitCollection(UnmarshallingContext context, Object value, Map implicitCollections, Object result, String itemFieldName) {
        String fieldName = this.mapper.getFieldNameForItemTypeAndName(context.getRequiredType(), value.getClass(), itemFieldName);
        if (fieldName != null) {
            Collection collection;
            if (implicitCollections == null) {
                implicitCollections = new HashMap<String, Collection>();
            }
            if ((collection = (Collection)implicitCollections.get(fieldName)) == null) {
                Class fieldType = this.mapper.defaultImplementationOf(this.reflectionProvider.getFieldType(result, fieldName, null));
                if (!Collection.class.isAssignableFrom(fieldType)) {
                    throw new ObjectAccessException("Field " + fieldName + " of " + result.getClass().getName() + " is configured for an implicit Collection, but field is of type " + fieldType.getName());
                }
                if (this.pureJavaReflectionProvider == null) {
                    this.pureJavaReflectionProvider = new PureJavaReflectionProvider();
                }
                collection = (Collection)this.pureJavaReflectionProvider.newInstance(fieldType);
                this.reflectionProvider.writeField(result, fieldName, (Object)collection, null);
                implicitCollections.put(fieldName, collection);
            }
            collection.add(value);
        }
        return implicitCollections;
    }

    protected Object instantiateNewInstance(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String readResolveValue = reader.getAttribute(this.mapper.aliasForAttribute("resolves-to"));
        Class type = readResolveValue != null ? this.mapper.realClass(readResolveValue) : context.getRequiredType();
        Object currentObject = context.currentObject();
        if (currentObject != null && type.isInstance(currentObject)) {
            return currentObject;
        }
        return this.reflectionProvider.newInstance(type);
    }

    private Class determineType(HierarchicalStreamReader reader, boolean validField, Object result, String fieldName, Class definedInCls) {
        Class specifiedType;
        String classAttribute = reader.getAttribute(this.mapper.aliasForAttribute("class"));
        Class fieldType = this.reflectionProvider.getFieldType(result, fieldName, definedInCls);
        if (classAttribute != null && fieldType.isAssignableFrom(specifiedType = this.mapper.realClass(classAttribute))) {
            return specifiedType;
        }
        if (!validField) {
            Class itemType = this.mapper.getItemTypeForItemFieldName(result.getClass(), fieldName);
            if (itemType != null) {
                return itemType;
            }
            return this.mapper.realClass(reader.getNodeName());
        }
        return this.mapper.defaultImplementationOf(fieldType);
    }

    private Object readResolve() {
        this.serializationMethodInvoker = new SerializationMethodInvoker();
        return this;
    }

    public static class DuplicateFieldException
    extends ConversionException {
        public DuplicateFieldException(String msg) {
            super(msg);
            this.add("duplicate-field", msg);
        }
    }

    private static class SeenFields {
        private Set seen = new HashSet();

        private SeenFields() {
        }

        public void add(Class definedInCls, String fieldName) {
            Object uniqueKey = fieldName;
            if (definedInCls != null) {
                uniqueKey = (String)uniqueKey + " [" + definedInCls.getName() + "]";
            }
            if (this.seen.contains(uniqueKey)) {
                throw new DuplicateFieldException((String)uniqueKey);
            }
            this.seen.add(uniqueKey);
        }
    }

    private static class OwnerContext
    extends LinkedList<String> {
        private OwnerContext() {
        }

        static OwnerContext find(MarshallingContext context) {
            OwnerContext c = (OwnerContext)context.get(OwnerContext.class);
            if (c == null) {
                c = new OwnerContext();
                context.put(OwnerContext.class, (Object)c);
            }
            return c;
        }

        private void startVisiting(HierarchicalStreamWriter writer, List<String> owners) {
            if (owners != null) {
                ArrayList addOwner = Lists.newArrayList();
                for (String owner : owners) {
                    String parentOwner;
                    if (StringUtils.isEmpty((String)owner)) continue;
                    boolean redundant = false;
                    Iterator iterator = this.iterator();
                    while (iterator.hasNext() && ((parentOwner = (String)iterator.next()) == null || !(redundant = parentOwner.equals(owner)))) {
                    }
                    if (redundant) continue;
                    addOwner.add(owner);
                }
                if (!addOwner.isEmpty()) {
                    writer.addAttribute(RobustReflectionConverter2.KEY_ATT_PLUGIN, addOwner.stream().collect(Collectors.joining(",")));
                }
                for (String o : owners) {
                    this.addFirst(o);
                }
            }
        }

        private void stopVisiting() {
            this.removeFirst();
        }
    }

    public static class PluginMetas
    implements IPluginMetasInfo {
        private final Set<PluginMeta> metas = new HashSet<PluginMeta>();
        private final Set<IRepositoryResource> repoRes = new HashSet<IRepositoryResource>();
        private boolean cacheable = true;

        public static PluginMetas collectMetas(Consumer<Set<PluginMeta>> supplier) {
            PluginMetas pluginMetas = null;
            try {
                pluginMetas = RobustReflectionConverter2.getUnCacheableThreadMetas();
                supplier.accept(pluginMetas.getMetas());
                PluginMetas pluginMetas2 = pluginMetas;
                return pluginMetas2;
            }
            finally {
                usedPluginInfo.remove();
            }
        }

        @Override
        public Set<PluginMeta> getMetas() {
            return this.metas;
        }

        @Override
        public Set<IRepositoryResource> getRepoResources() {
            return this.repoRes;
        }

        public void addAll(Collection<PluginMeta> metas, IRepositoryResource res) {
            if (CollectionUtils.isNotEmpty(metas)) {
                this.metas.addAll(metas);
            }
            this.repoRes.add(Objects.requireNonNull(res, "res can not be null"));
        }

        public void fillWithDependencies() {
            ArrayList deps = Lists.newArrayList();
            for (PluginMeta meta : this.metas) {
                meta.getMetaDependencies();
            }
        }

        private PluginMetas unCacheableFromPluginStore() {
            this.cacheable = false;
            return this;
        }

        public boolean isCacheable() {
            return this.cacheable;
        }

        public boolean isDryRun() {
            return !this.isCacheable();
        }
    }
}

