/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.extension.ITPIArtifact;
import com.qlangtech.tis.extension.ITPIArtifactMatch;
import com.qlangtech.tis.extension.PluginWrapper;
import com.qlangtech.tis.extension.impl.ClassicPluginStrategy;
import com.qlangtech.tis.extension.impl.PluginManifest;
import com.qlangtech.tis.extension.model.IPluginCoord;
import com.qlangtech.tis.extension.model.UpdateSite;
import com.qlangtech.tis.extension.util.VersionNumber;
import com.qlangtech.tis.manage.common.CenterResource;
import com.qlangtech.tis.maven.plugins.tpi.PluginClassifier;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class PluginMeta {
    public static final String NAME_VER_SPLIT = "@";
    public static final String ClASSIFIER_SPLIT = "!";
    private static final Pattern PATTERN_META = Pattern.compile("([^@]+?)@([^@]+?)(@([^@]+?))?(!(\\S+))?");
    private final String name;
    public final VersionNumber ver;
    protected Long lastModifyTimeStamp;
    public Optional<PluginClassifier> classifier;

    public String getPluginPackageName() {
        if (this.classifier.isPresent()) {
            return this.classifier.get().getTPIPluginName(this.name, ".tpi");
        }
        return this.name + ".tpi";
    }

    public void setClassifier(PluginClassifier classifier) {
        this.classifier = Optional.of(Objects.requireNonNull(classifier, "classifier can not be null"));
    }

    public File getPluginPackageFile() {
        return new File(TIS.pluginDirRoot, this.getPluginPackageName());
    }

    public PluginMeta(String name, String ver, Optional<PluginClassifier> classifier) {
        this(name, ver, classifier, null);
    }

    public PluginMeta(String name, String ver, Optional<PluginClassifier> classifier, Long lastModifyTimeStamp) {
        this.name = name;
        this.ver = new VersionNumber(ver);
        this.lastModifyTimeStamp = lastModifyTimeStamp;
        this.classifier = classifier;
    }

    public boolean equals(Object o) {
        return this.hashCode() == o.hashCode();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.getKey());
        this.getLastModifyTimeStamp();
        if (this.lastModifyTimeStamp != null) {
            buffer.append(NAME_VER_SPLIT).append(this.lastModifyTimeStamp);
        }
        if (this.classifier.isPresent()) {
            buffer.append(ClASSIFIER_SPLIT).append(this.classifier.get().getClassifier());
        }
        return buffer.toString();
    }

    public ITPIArtifactMatch createPluginMatcher() {
        ITPIArtifactMatch match = ITPIArtifact.create(this.getPluginName(), this.classifier);
        return match;
    }

    public String getKey() {
        return new StringBuffer(this.name + NAME_VER_SPLIT + this.ver).toString();
    }

    public String getPluginName() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.ver);
    }

    public static List<PluginMeta> parse(String attribute) {
        String[] metaArray = StringUtils.split((String)attribute, (String)",");
        return PluginMeta.parse(metaArray, true);
    }

    public static List<PluginMeta> parse(String[] metaArray) {
        return PluginMeta.parse(metaArray, false);
    }

    private static List<PluginMeta> parse(String[] metaArray, final boolean resolveDependencyFromPluginCenter) {
        if (metaArray == null) {
            throw new IllegalArgumentException("param metaArray can not be null");
        }
        final HashMap result = Maps.newHashMap();
        Optional<Object> classifier = null;
        Matcher match = null;
        PluginWrapper pw = null;
        for (String meta : metaArray) {
            Long lastModify;
            String ver;
            String pluginName;
            match = PATTERN_META.matcher(meta);
            if (match.matches()) {
                String c;
                pluginName = match.group(1);
                ver = match.group(2);
                classifier = Optional.empty();
                String l = null;
                lastModify = null;
                if (match.groupCount() < 6) {
                    throw new IllegalStateException("groupCount must be 6:" + match + " but now is " + match.groupCount());
                }
                l = match.group(4);
                if (StringUtils.isNotEmpty((String)l)) {
                    lastModify = Long.parseLong(l);
                }
                if (StringUtils.isNotEmpty((String)(c = match.group(6)))) {
                    classifier = Optional.of(PluginClassifier.create((String)c));
                } else {
                    TIS tis = TIS.get();
                    Map<Object, Object> plugins = tis != null ? tis.getPluginManager().getActivePluginsMap() : Collections.emptyMap();
                    pw = (PluginWrapper)plugins.get(pluginName);
                    if (pw != null) {
                        classifier = pw.getClassifier();
                    }
                }
            } else {
                throw new IllegalArgumentException("attri is invalid:" + Arrays.stream(metaArray).collect(Collectors.joining(",")));
            }
            result.put(pluginName, new PluginMeta(pluginName, ver, classifier, lastModify){

                @Override
                public List<PluginMeta> getMetaDependencies() {
                    if (resolveDependencyFromPluginCenter) {
                        return super.getMetaDependencies();
                    }
                    return this.processJarManifest(mfst -> {
                        if (mfst == null) {
                            return Collections.emptyList();
                        }
                        ClassicPluginStrategy.DependencyMeta dpts = mfst.getDependencyMeta();
                        return dpts.dependencies.stream().map(d -> {
                            PluginMeta mt = (PluginMeta)result.get(d.shortName);
                            if (mt == null) {
                                throw new IllegalStateException("pluginName:" + d.shortName + " relevant pluginMeta shall not be empty, all:" + result.keySet().stream().collect(Collectors.joining(",")));
                            }
                            return mt;
                        }).collect(Collectors.toList());
                    });
                }
            });
        }
        return Lists.newArrayList(result.values());
    }

    public long getLastModifyTimeStamp() {
        if (this.lastModifyTimeStamp != null) {
            return this.lastModifyTimeStamp;
        }
        this.lastModifyTimeStamp = this.processJarManifest(mfst -> mfst == null ? -1L : mfst.getLastModfiyTime());
        return this.lastModifyTimeStamp;
    }

    public boolean isLastModifyTimeStampNull() {
        return this.lastModifyTimeStamp == null;
    }

    public List<PluginMeta> getMetaDependencies() {
        return this.processJarManifest(mfst -> {
            if (mfst == null) {
                return Collections.emptyList();
            }
            String pluginName = this.getPluginName();
            ITPIArtifactMatch from = ITPIArtifact.matchh(pluginName, this.classifier);
            ClassicPluginStrategy.DependencyMeta dpts = mfst.getDependencyMeta();
            return dpts.dependencies.stream().map(d -> {
                Optional dc = Optional.empty();
                if (this.classifier.isPresent() && !PluginClassifier.MATCH_ALL_CLASSIFIER.getClassifier().equals(this.classifier.get().getClassifier())) {
                    from.setIdentityName(d.shortName);
                    UpdateSite.Plugin depPlugin = TIS.get().getUpdateCenter().getPlugin(d.shortName);
                    Objects.requireNonNull(depPlugin, "plugin:" + d.shortName + " from " + pluginName + ",classifier:" + this.classifier.get().getClassifier() + " relevant plugin meta can not be null");
                    if (depPlugin.isMultiClassifier()) {
                        boolean found = false;
                        for (IPluginCoord coord : depPlugin.getArts()) {
                            if (!ITPIArtifact.isEquals(coord, from)) continue;
                            dc = coord.getClassifier();
                            found = true;
                            break;
                        }
                        if (!found) {
                            throw new IllegalStateException(from.toString() + " can not find relevant classifer in " + depPlugin.getDisplayName());
                        }
                    }
                }
                return new PluginMeta(d.shortName, d.version, dc);
            }).collect(Collectors.toList());
        });
    }

    protected <R> R processJarManifest(Function<PluginManifest, R> manProcess) {
        File f = this.getPluginPackageFile();
        PluginManifest manifest = PluginManifest.create(f);
        if (manifest == null) {
            return manProcess.apply(null);
        }
        return manProcess.apply(manifest);
    }

    public static void main(String[] args) throws Exception {
        File f = new File("/Users/mozhenghua/j2ee_solution/project/plugins/tis-datax/tis-datax-hudi-plugin/target/tis-datax-hudi-plugin.tpi");
        try (JarFile tpiFIle = new JarFile(f, false);){
            tpiFIle.stream().forEach(e -> System.out.println(e.getName()));
        }
    }

    public boolean copyFromRemote() {
        return this.copyFromRemote(Lists.newArrayList());
    }

    public boolean copyFromRemote(List<File> pluginFileCollector) {
        return this.copyFromRemote(pluginFileCollector, false, false);
    }

    public boolean copyFromRemote(List<File> pluginFileCollector, boolean ignoreDependencies, boolean directDownload) {
        URL url = CenterResource.getPathURL((String)("libs/plugins/" + this.getPluginPackageName()));
        File local = this.getPluginPackageFile();
        Boolean updated = CenterResource.copyFromRemote2Local((URL)url, (File)local, (boolean)directDownload);
        if (!ignoreDependencies && updated.booleanValue()) {
            for (PluginMeta d : this.getMetaDependencies()) {
                d.copyFromRemote(pluginFileCollector);
            }
            pluginFileCollector.add(local);
        }
        return updated;
    }
}

