/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.util;

import com.qlangtech.tis.util.Util;
import java.util.HashMap;
import java.util.Map;

public class MemoryReductionUtil {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static int preallocatedHashmapCapacity(int elementsToHold) {
        if (elementsToHold <= 0) {
            return 0;
        }
        if (elementsToHold < 3) {
            return elementsToHold + 1;
        }
        return elementsToHold + elementsToHold / 3;
    }

    public static Map getPresizedMutableMap(int elementCount) {
        return new HashMap(MemoryReductionUtil.preallocatedHashmapCapacity(elementCount));
    }

    public static String[] internInPlace(String[] input) {
        if (input == null) {
            return null;
        }
        if (input.length == 0) {
            return EMPTY_STRING_ARRAY;
        }
        for (int i = 0; i < input.length; ++i) {
            input[i] = Util.intern(input[i]);
        }
        return input;
    }
}

