/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.util;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public abstract class Memoizer<K, V> {
    private final WeakHashMap<K, V> store = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        V v = this.store.get(key);
        if (v != null) {
            return v;
        }
        Memoizer memoizer = this;
        synchronized (memoizer) {
            v = this.store.get(key);
            if (v != null) {
                return v;
            }
            v = this.compute(key);
            this.store.put(key, v);
            return v;
        }
    }

    public abstract V compute(K var1);

    public void clear() {
        this.store.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(K key) {
        Memoizer memoizer = this;
        synchronized (memoizer) {
            this.store.remove(key);
        }
    }

    public Iterable<V> values() {
        return this.store.values();
    }

    public Set<Map.Entry<K, V>> getEntries() {
        return this.store.entrySet();
    }

    public Map<K, V> snapshot() {
        return Collections.unmodifiableMap(this.store);
    }
}

