/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.util;

import com.alibaba.citrus.turbine.Context;
import com.qlangtech.tis.datax.DataXName;
import com.qlangtech.tis.datax.IDataXNameAware;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.manage.common.ILoginUser;
import com.qlangtech.tis.plugin.ds.DataSourceFactory;
import com.qlangtech.tis.runtime.module.misc.IFieldErrorHandler;
import com.qlangtech.tis.runtime.module.misc.IMessageHandler;
import com.qlangtech.tis.runtime.module.misc.IPostContent;
import com.qlangtech.tis.util.PartialSettedPluginContext;
import java.util.Objects;
import java.util.Optional;

public interface IPluginContext
extends IMessageHandler,
IDataXNameAware,
IPostContent {
    public static final ThreadLocal<IPluginContext> pluginContextThreadLocal = new ThreadLocal();

    public static void setPluginContext(IPluginContext pluginContext) {
        pluginContextThreadLocal.set(pluginContext);
    }

    public static IPluginContext getThreadLocalInstance() {
        return Objects.requireNonNull(pluginContextThreadLocal.get(), "instance of " + IPluginContext.class.getSimpleName() + " can not be null");
    }

    public static PartialSettedPluginContext namedContext(DataXName collectionName) {
        return IPluginContext.namedContext(collectionName, Optional.empty());
    }

    public static PartialSettedPluginContext namedContext(String collectionName) {
        return IPluginContext.namedContext(DataXName.createDataXPipeline((String)collectionName), Optional.empty());
    }

    public static PartialSettedPluginContext namedContext(String collectionName, Optional<String> execId) {
        return IPluginContext.namedContext(collectionName, execId);
    }

    public static PartialSettedPluginContext namedContext(DataXName collectionName, Optional<String> execId) {
        if (collectionName == null) {
            throw new IllegalArgumentException("param collectionName can not be empty");
        }
        PartialSettedPluginContext context = new PartialSettedPluginContext();
        return context.setCollectionName(collectionName).setExecId(execId);
    }

    public ILoginUser getLoginUser();

    public String getExecId();

    public void executeBizLogic(IFieldErrorHandler.BizLogic var1, Context var2, Object var3) throws Exception;

    public boolean isDataSourceAware();

    public void addDb(Descriptor.ParseDescribable<DataSourceFactory> var1, String var2, Context var3, boolean var4);
}

