/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.extension.SubFormFilter;
import com.qlangtech.tis.extension.util.GroovyShellUtil;
import com.qlangtech.tis.manage.common.TisUTF8;
import com.qlangtech.tis.plugin.CompanionPluginFactory;
import com.qlangtech.tis.util.DescribableJSON;
import com.qlangtech.tis.util.DescriptorsJSON;
import com.qlangtech.tis.util.Selectable;
import com.qlangtech.tis.util.UploadPluginMeta;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;

public class HeteroList<T extends Describable<T>> {
    public static final String KEY_ITEMS = "items";
    private List<Descriptor<T>> descriptors;
    private List<T> items = new ArrayList<T>();
    private String caption;
    private String identityId;
    private Class<?> extensionPoint;
    private Selectable selectable;
    private final UploadPluginMeta pluginMeta;

    public HeteroList(UploadPluginMeta pluginMeta) {
        this.pluginMeta = pluginMeta;
    }

    public Selectable getSelectable() {
        return this.selectable;
    }

    public void setSelectable(Selectable selectable) {
        this.selectable = selectable;
    }

    public List<Descriptor<T>> getDescriptors() {
        return this.descriptors;
    }

    public Class<?> getExtensionPoint() {
        return this.extensionPoint;
    }

    public void setExtensionPoint(Class<?> extensionPoint) {
        this.extensionPoint = extensionPoint;
    }

    public void setIdentityId(String identity) {
        this.identityId = identity;
    }

    public void setDescriptors(List<Descriptor<T>> descriptors) {
        this.descriptors = descriptors;
    }

    public List<T> getItems() {
        return this.items == null ? Collections.emptyList() : this.items;
    }

    public void setItems(List<T> items) {
        this.items = items;
    }

    public void addItem(T item) {
        this.items.add(item);
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public JSONObject toJSON() throws Exception {
        Optional<SubFormFilter> subFormFilter = this.pluginMeta.getSubFormFilter();
        return this.toJSON(HeteroList.createItemsJSONArray(this.pluginMeta, this.getItems(), subFormFilter));
    }

    public JSONObject toJSON(JSONArray items) throws Exception {
        Iterator<T> iterator;
        JSONObject o = new JSONObject();
        o.put("caption", (Object)this.getCaption());
        o.put("identityId", (Object)this.identityId);
        o.put("cardinality", (Object)this.getSelectable().identity);
        o.put("extensionPoint", (Object)this.extensionPoint.getName());
        o.put("extensionPointUrl", (Object)("http://tis.pub/docs/plugin/plugins/#" + URLEncoder.encode(StringUtils.lowerCase((String)StringUtils.remove((String)this.extensionPoint.getName(), (String)".")), TisUTF8.getName())));
        Optional<SubFormFilter> subFormFilter = this.pluginMeta.getSubFormFilter();
        DescriptorsJSON<T> desc2Json = new DescriptorsJSON<T>(this.descriptors, true);
        if (this.getItems().size() == 1 && (iterator = this.getItems().iterator()).hasNext()) {
            Describable plugin = (Describable)iterator.next();
            Map<Class<? extends Descriptor>, Describable> pluginThreadLocal = GroovyShellUtil.pluginThreadLocal.get();
            pluginThreadLocal.put(plugin.getDescriptor().getClass(), plugin);
        }
        o.put("descriptors", (Object)desc2Json.getDescriptorsJSON(subFormFilter));
        o.put(KEY_ITEMS, (Object)items);
        return o;
    }

    private static <TT extends Describable<TT>> JSONArray createItemsJSONArray(UploadPluginMeta pluginMeta, List<TT> items, Optional<SubFormFilter> subFormFilter) throws Exception {
        JSONArray result = new JSONArray();
        JSONObject item = null;
        for (Describable i : items) {
            DescribableJSON<Describable> pluginJson = new DescribableJSON<Describable>(i);
            item = pluginJson.getItemJson(subFormFilter);
            result.add((Object)item);
            subFormFilter.ifPresent(formFilter -> {
                if (!formFilter.subformDetailView) {
                    return;
                }
                try {
                    Object companionPlugin;
                    if (pluginJson.descriptor instanceof CompanionPluginFactory && (companionPlugin = ((CompanionPluginFactory)((Object)pluginJson.descriptor)).getCompanionPlugin(pluginMeta)) != null) {
                        result.add((Object)new DescribableJSON(companionPlugin).getItemJson());
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return result;
    }
}

