/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.extension.PluginFormProperties;
import com.qlangtech.tis.extension.SubFormFilter;
import com.qlangtech.tis.extension.TISExtensible;
import com.qlangtech.tis.extension.impl.BaseSubFormProperties;
import com.qlangtech.tis.extension.impl.PropertyType;
import com.qlangtech.tis.extension.impl.RootFormProperties;
import com.qlangtech.tis.plugin.CompanionPluginFactory;
import com.qlangtech.tis.plugin.IdentityName;
import com.qlangtech.tis.plugin.annotation.FormFieldType;
import com.qlangtech.tis.util.DescriptorsJSONResult;
import com.qlangtech.tis.util.ISelectOptionsGetter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class DescriptorsJSON<T extends Describable<T>> {
    public static final String KEY_DISPLAY_NAME = "displayName";
    public static final String KEY_EXTEND_POINT = "extendPoint";
    public static final String KEY_IMPL = "impl";
    public static final String KEY_IMPL_URL = "implUrl";
    public static final String KEY_ADVANCE = "advance";
    private final Collection<Descriptor<T>> descriptors;
    private final boolean rootDesc;

    public static DescriptorsJSONResult desc(String requestDescId) {
        return new DescriptorsJSON(TIS.get().getDescriptor(requestDescId)).getDescriptorsJSON();
    }

    public static DescriptorsJSONResult desc(Descriptor desc) {
        return new DescriptorsJSON(desc).getDescriptorsJSON();
    }

    public DescriptorsJSON(Collection<Descriptor<T>> descriptors) {
        this(descriptors, true);
    }

    public DescriptorsJSON(Descriptor<T> descriptor) {
        this(descriptor, true);
    }

    public DescriptorsJSON(Collection<Descriptor<T>> descriptors, boolean rootDesc) {
        this.descriptors = descriptors;
        this.rootDesc = rootDesc;
    }

    public DescriptorsJSON(Descriptor<T> descriptor, boolean rootDesc) {
        this(Collections.singletonList(descriptor), rootDesc);
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public DescriptorsJSONResult getDescriptorsJSON() {
        return this.getDescriptorsJSON(Optional.empty());
    }

    public static Pair<JSONObject, Descriptor> createPluginFormPropertyTypes(final Descriptor<?> descriptor, Optional<SubFormFilter> subFormFilter, boolean forAIPromote) {
        PluginFormProperties pluginFormPropertyTypes = descriptor.getPluginFormPropertyTypes(subFormFilter);
        final JSONObject desJson = new JSONObject();
        Descriptor desc = (Descriptor)pluginFormPropertyTypes.accept(new SubFormFieldVisitor(subFormFilter){

            public Descriptor visit(RootFormProperties props) {
                return descriptor;
            }

            public Descriptor visit(BaseSubFormProperties props) {
                JSONObject subForm = new JSONObject();
                subForm.put("fieldName", (Object)props.getSubFormFieldName());
                if (this.subFormFilter.isPresent()) {
                    SubFormFilter filter = (SubFormFilter)this.subFormFilter.get();
                    if (!filter.subformDetailView) {
                        desJson.put("subForm", (Object)true);
                        subForm.put("idList", props.getSubFormIdListGetter(filter).build(filter));
                    }
                }
                desJson.put("subFormMeta", (Object)subForm);
                return props.subFormFieldsDescriptor;
            }
        });
        desJson.put(KEY_EXTEND_POINT, (Object)desc.getT().getName());
        DescriptorsJSON.setDescInfo(desc, forAIPromote, (Map<String, Object>)desJson);
        if (IdentityName.class.isAssignableFrom(desc.clazz)) {
            desJson.put("pkField", (Object)desc.getIdentityField().displayName);
        }
        if (!forAIPromote) {
            desJson.put("veriflable", (Object)desc.overWriteValidateMethod);
            Map<String, Object> extractProps = desc.getExtractProps();
            desJson.put("extractProps", extractProps);
        }
        return Pair.of((Object)desJson, (Object)desc);
    }

    public DescriptorsJSONResult getDescriptorsJSON(Optional<SubFormFilter> subFormFilter) {
        JSONObject extraProps = null;
        DescriptorsJSONResult descriptors = new DescriptorsJSONResult(this.rootDesc);
        List<Descriptor<?>> acceptDescs = this.getAcceptDescs(subFormFilter);
        for (Descriptor<?> dd : acceptDescs) {
            PluginFormProperties pluginFormPropertyTypes = dd.getPluginFormPropertyTypes(subFormFilter);
            Pair<JSONObject, Descriptor> pair = this.createFormPropertyTypes(subFormFilter, dd);
            JSONObject desJson = (JSONObject)pair.getKey();
            Descriptor desc = (Descriptor)pair.getValue();
            JSONArray attrs = new JSONArray();
            List<Map.Entry<String, PropertyType>> entries = pluginFormPropertyTypes.getSortedUseableProperties();
            boolean containAdvanceField = false;
            for (Map.Entry<String, PropertyType> pp : entries) {
                String key = pp.getKey();
                PropertyType val = pp.getValue();
                extraProps = this.getFieldExtraProps(val);
                if (extraProps != null && extraProps.getBooleanValue("disable")) continue;
                if (val.advance()) {
                    containAdvanceField = true;
                }
                JSONObject attrVal = this.createAttrVal(key, val);
                if (extraProps != null) {
                    JSONObject ep = this.processExtraProps(val, extraProps);
                    JSONObject n = val.multiSelectablePropProcess(vt -> {
                        JSONObject clone = (JSONObject)ep.clone();
                        clone.put("viewtype", (Object)vt.getViewTypeToken());
                        return clone;
                    });
                    val.appendExternalProp(ep);
                    attrVal.put("eprops", (Object)(n != null ? n : ep));
                }
                if (val.typeIdentity() == FormFieldType.SELECTABLE.getIdentity()) {
                    attrVal.put("options", DescriptorsJSON.getSelectOptions(desc, val, key));
                }
                if (val.isDescribable()) {
                    DescriptorsJSON des2Json = this.createInnerDescrible(val);
                    attrVal.put("descriptors", (Object)des2Json.getDescriptorsJSON());
                    TISExtensible extensible = val.fieldClazz.getAnnotation(TISExtensible.class);
                    attrVal.put("extensible", (Object)(extensible != null ? 1 : 0));
                    attrVal.put(KEY_EXTEND_POINT, (Object)val.fieldClazz.getName());
                }
                attrs.add((Object)attrVal);
            }
            desJson.put("attrs", (Object)attrs);
            this.setContainAdvanceField(desJson, containAdvanceField);
            descriptors.addDesc(desc.getId(), desJson, dd);
        }
        return descriptors;
    }

    protected void setContainAdvanceField(JSONObject desJson, boolean containAdvanceField) {
        desJson.put("containAdvance", (Object)containAdvanceField);
    }

    protected JSONObject createAttrVal(String key, PropertyType val) {
        JSONObject attrVal = new JSONObject();
        attrVal.put("key", (Object)key);
        attrVal.put("pk", (Object)val.isIdentity());
        attrVal.put("describable", (Object)val.isDescribable());
        attrVal.put("type", (Object)val.typeIdentity());
        attrVal.put("required", (Object)val.isInputRequired());
        attrVal.put("ord", (Object)val.ordinal());
        if (val.advance()) {
            attrVal.put(KEY_ADVANCE, (Object)true);
        }
        return attrVal;
    }

    protected JSONObject processExtraProps(PropertyType propertyType, JSONObject extraProps) {
        return extraProps;
    }

    protected JSONObject getFieldExtraProps(PropertyType val) {
        return val.getExtraProps();
    }

    protected Pair<JSONObject, Descriptor> createFormPropertyTypes(Optional<SubFormFilter> subFormFilter, Descriptor<?> dd) {
        Pair<JSONObject, Descriptor> pair = DescriptorsJSON.createPluginFormPropertyTypes(dd, subFormFilter, false);
        return pair;
    }

    protected DescriptorsJSON createInnerDescrible(PropertyType val) {
        return new DescriptorsJSON<T>(val.getApplicableDescriptors(), false);
    }

    private List<Descriptor<?>> getAcceptDescs(Optional<SubFormFilter> subFormFilter) {
        PluginFormProperties pluginFormPropertyTypes = null;
        final ArrayList acceptDescs = Lists.newArrayList(this.descriptors);
        for (final Descriptor<T> dd : this.descriptors) {
            pluginFormPropertyTypes = dd.getPluginFormPropertyTypes(subFormFilter);
            pluginFormPropertyTypes.accept(new PluginFormProperties.IVisitor(){

                public Void visit(BaseSubFormProperties props) {
                    if (dd instanceof CompanionPluginFactory) {
                        acceptDescs.add(((CompanionPluginFactory)((Object)dd)).getCompanionDescriptor());
                    }
                    return null;
                }
            });
        }
        return acceptDescs;
    }

    public static void setDescInfo(Descriptor d, boolean forAIPromote, Map<String, Object> des) {
        des.put(KEY_DISPLAY_NAME, d.getDisplayName());
        des.put(KEY_IMPL, d.getId());
        if (!forAIPromote) {
            des.put(KEY_IMPL_URL, "http://tis.pub/docs/plugin/plugins/#" + StringUtils.remove((String)StringUtils.lowerCase((String)d.clazz.getName()), (String)"."));
        }
    }

    public static List<Descriptor.SelectOption> getSelectOptions(Descriptor descriptor, PropertyType propType, String fieldKey) {
        Descriptor optionsCreator = null;
        if (propType.typeIdentity() != FormFieldType.SELECTABLE.getIdentity()) {
            throw new IllegalStateException("propType must be:" + FormFieldType.SELECTABLE + " but now is:" + propType.typeIdentity());
        }
        if (!(descriptor instanceof ISelectOptionsGetter)) {
            throw new IllegalStateException("descriptor:" + descriptor.getClass() + " has a selectable field:" + fieldKey + " descriptor must be an instance of 'ISelectOptionsGetter'");
        }
        optionsCreator = descriptor;
        List<Descriptor.SelectOption> selectOptions = optionsCreator.getSelectOptions(fieldKey);
        return selectOptions;
    }

    public static interface IPropGetter {
        public Object build(SubFormFilter var1);
    }

    public static abstract class SubFormFieldVisitor
    implements PluginFormProperties.IVisitor {
        final Optional<SubFormFilter> subFormFilter;

        public SubFormFieldVisitor(Optional<SubFormFilter> subFormFilter) {
            this.subFormFilter = subFormFilter;
        }
    }
}

