/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONType;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.extension.PluginFormProperties;
import com.qlangtech.tis.extension.SubFormFilter;
import com.qlangtech.tis.extension.impl.BaseSubFormProperties;
import com.qlangtech.tis.extension.impl.RootFormProperties;
import com.qlangtech.tis.plugin.IdentityName;
import com.qlangtech.tis.util.AttrValMap;
import com.qlangtech.tis.util.DescribableJSONSerializer;
import com.qlangtech.tis.util.DescriptorsJSON;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JSONType(serializer=DescribableJSONSerializer.class)
public class DescribableJSON<T extends Describable<T>> {
    public final T instance;
    public final Descriptor<T> descriptor;

    public DescribableJSON(T instance, Descriptor<T> descriptor) {
        this.instance = (Describable)Objects.requireNonNull(instance, "param instance can not be null");
        this.descriptor = Objects.requireNonNull(descriptor, "param descriptor can not be null,plugin type:" + instance.getClass());
    }

    public DescribableJSON(T instance) {
        this((Describable)Objects.requireNonNull(instance, "param instance can not be null"), instance.getDescriptor());
    }

    public JSONObject getItemJson() throws Exception {
        return this.getItemJson(Optional.empty());
    }

    public JSONObject getItemJson(Optional<SubFormFilter> subFormFilter) throws Exception {
        PluginFormProperties pluginFormPropertyTypes = this.descriptor.getPluginFormPropertyTypes(subFormFilter);
        return this.getItemJson(pluginFormPropertyTypes);
    }

    public JSONObject getItemJson(PluginFormProperties pluginFormPropertyTypes) throws Exception {
        JSONObject item = new JSONObject();
        DescriptorsJSON.setDescInfo((Descriptor)pluginFormPropertyTypes.accept(new PluginFormProperties.IVisitor(){

            public Descriptor visit(RootFormProperties props) {
                return DescribableJSON.this.descriptor;
            }

            public Descriptor visit(BaseSubFormProperties props) {
                return props.subFormFieldsDescriptor;
            }
        }), false, (Map<String, Object>)item);
        JSON vals = pluginFormPropertyTypes.getInstancePropsJson(this.instance);
        item.put("vals", (Object)vals);
        if (this.instance instanceof IdentityName) {
            item.put("identityName", (Object)((IdentityName)this.instance).identityValue());
        }
        return item;
    }

    public JSONObject buildPostJsonBody() {
        try {
            return this.getPostAttribute().getPostJsonBody();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public AttrValMap getPostAttribute() {
        return AttrValMap.parseDescribableMap(Optional.empty(), this.getPostAttributeJson());
    }

    public JSONObject getPostAttributeJson() {
        PluginFormProperties pluginFormPropertyTypes = this.descriptor.getPluginFormPropertyTypes(Optional.empty());
        JSON vals = pluginFormPropertyTypes.getInstancePropsJson(this.instance);
        JSONObject postJson = new JSONObject();
        postJson.put("impl", (Object)this.descriptor.getId());
        JSONObject wrappedVals = this.convertToAttrVals(vals);
        postJson.put("vals", (Object)wrappedVals);
        return postJson;
    }

    private JSONObject convertToAttrVals(JSON vals) {
        if (!(vals instanceof JSONObject)) {
            throw new IllegalStateException("type of vals must be " + JSONObject.class.getSimpleName());
        }
        JSONObject valsObj = (JSONObject)vals;
        JSONObject wrappedVals = new JSONObject();
        for (Map.Entry entry : valsObj.entrySet()) {
            String field = (String)entry.getKey();
            Object value = entry.getValue();
            JSONObject fieldVal = new JSONObject();
            if (value instanceof JSONObject) {
                JSONObject nestedObj = (JSONObject)value;
                if (nestedObj.containsKey((Object)"impl")) {
                    JSONObject nestedVals = nestedObj.getJSONObject("vals");
                    if (nestedVals != null) {
                        JSONObject convertedNestedVals = this.convertToAttrVals((JSON)nestedVals);
                        JSONObject newNestedObj = new JSONObject();
                        newNestedObj.put("impl", (Object)nestedObj.getString("impl"));
                        newNestedObj.put("vals", (Object)convertedNestedVals);
                        JSONObject descVal = new JSONObject();
                        descVal.put("descVal", (Object)newNestedObj);
                        fieldVal = descVal;
                    } else {
                        JSONObject descVal = new JSONObject();
                        descVal.put("descVal", (Object)nestedObj);
                        fieldVal = descVal;
                    }
                } else {
                    fieldVal.put("_primaryVal", value);
                }
            } else {
                fieldVal.put("_primaryVal", value);
            }
            wrappedVals.put(field, (Object)fieldVal);
        }
        return wrappedVals;
    }
}

