/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.util;

import com.alibaba.citrus.turbine.Context;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.extension.PluginFormProperties;
import com.qlangtech.tis.extension.SubFormFilter;
import com.qlangtech.tis.extension.impl.PropValRewrite;
import com.qlangtech.tis.extension.impl.PropertyType;
import com.qlangtech.tis.lang.TisException;
import com.qlangtech.tis.runtime.module.misc.FormVaildateType;
import com.qlangtech.tis.runtime.module.misc.IControlMsgHandler;
import com.qlangtech.tis.util.DescriptorsJSON;
import com.qlangtech.tis.util.PartialSettedPluginContext;
import com.qlangtech.tis.util.impl.AttrVals;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class AttrValMap {
    public static final String PLUGIN_EXTENSION_IMPL = "impl";
    public static final String PLUGIN_EXTENSION_VALS = "vals";
    private static final ThreadLocal<Descriptor> currentRootPluginValidator = new ThreadLocal();
    private final AttrVals attrValMap;
    public final Descriptor descriptor;
    private final Optional<SubFormFilter> subFormFilter;
    private final PropValRewrite propValRewrite;

    public static void setCurrentRootPluginValidator(Descriptor descriptor) {
        currentRootPluginValidator.set(Objects.requireNonNull(descriptor, "descriptor can not be null"));
    }

    public static Descriptor getCurrentRootPluginValidator() {
        return Objects.requireNonNull(currentRootPluginValidator.get(), "currentRootPluginValidator must be present");
    }

    public static void removeCurrentRootPluginValidator() {
        currentRootPluginValidator.remove();
    }

    public static List<AttrValMap> describableAttrValMapList(JSONArray itemsArray, Optional<SubFormFilter> subFormFilter) {
        return AttrValMap.describableAttrValMapList(itemsArray, subFormFilter, PropValRewrite.dftRewrite());
    }

    public static List<AttrValMap> describableAttrValMapList(JSONArray itemsArray, Optional<SubFormFilter> subFormFilter, PropValRewrite propValRewrite) {
        ArrayList describableAttrValMapList = Lists.newArrayList();
        AttrValMap describableAttrValMap = null;
        JSONObject itemObj = null;
        for (int i = 0; i < itemsArray.size(); ++i) {
            itemObj = itemsArray.getJSONObject(i);
            describableAttrValMap = AttrValMap.parseDescribableMap(subFormFilter, itemObj, propValRewrite);
            describableAttrValMapList.add(describableAttrValMap);
        }
        return describableAttrValMapList;
    }

    public static AttrValMap parseDescribableMap(Optional<SubFormFilter> subFormFilter, JSONObject jsonObject) {
        return AttrValMap.parseDescribableMap(subFormFilter, jsonObject, (propType, val) -> val);
    }

    public static AttrValMap parseDescribableMap(Optional<SubFormFilter> subFormFilter, JSONObject jsonObject, PropValRewrite propValRewrite) {
        String impl = Objects.requireNonNull(jsonObject, "jsonObject can not be null").getString(PLUGIN_EXTENSION_IMPL);
        Descriptor descriptor = TIS.get().getDescriptor(impl);
        if (descriptor == null) {
            throw new IllegalStateException("impl:" + impl + " can not find relevant ");
        }
        Object vals = jsonObject.get((Object)PLUGIN_EXTENSION_VALS);
        AttrVals attrValMap = AttrVals.parseAttrValMap(vals);
        return new AttrValMap(attrValMap, subFormFilter, descriptor, propValRewrite);
    }

    private AttrValMap(AttrVals attrValMap, Optional<SubFormFilter> subFormFilter, Descriptor descriptor, PropValRewrite propValRewrite) {
        this.attrValMap = attrValMap;
        this.descriptor = descriptor;
        this.subFormFilter = subFormFilter;
        this.propValRewrite = propValRewrite;
    }

    public boolean strictValidate(PartialSettedPluginContext msgHandler, Context ctx) {
        FormVaildateType verify = FormVaildateType.create((boolean)true);
        FormVaildateType validate = FormVaildateType.create((boolean)false);
        boolean validateFaild = false;
        try {
            if (!this.validate(msgHandler, ctx, verify, Optional.empty()).isValid() || !this.validate(msgHandler, ctx, validate, Optional.empty()).isValid()) {
                validateFaild = true;
            }
        }
        catch (Exception e) {
            validateFaild = true;
            TisException expt = null;
            expt = (TisException)ExceptionUtils.throwableOfType((Throwable)e, TisException.class);
            if (expt != null) {
                msgHandler.addErrorMessage(ctx, expt.getMessage());
            }
            throw new RuntimeException(e);
        }
        return validateFaild;
    }

    public final String getPrimaryFieldVal() {
        return String.valueOf(this.getPKVal());
    }

    public final boolean isPrimaryFieldEmpty() {
        Object val = this.getPKVal();
        return val == null || StringUtils.isEmpty((CharSequence)String.valueOf(val));
    }

    private Object getPKVal() {
        PropertyType idField = Objects.requireNonNull(this.descriptor, "descriptor can not be null").getIdentityField(false);
        if (idField == null) {
            return null;
        }
        return this.getAttrVals().getPrimaryVal(idField.propertyName());
    }

    public JSONObject getPostJsonBody() {
        JSONObject body = new JSONObject();
        DescriptorsJSON.setDescInfo(this.descriptor, false, (Map<String, Object>)body);
        JSONObject vals = new JSONObject();
        this.attrValMap.vistAttrValMap((field, val) -> this.convertFieldVal(vals, (String)field, (JSON)val));
        body.put(PLUGIN_EXTENSION_VALS, (Object)vals);
        return body;
    }

    private void convertFieldVal(JSONObject vals, String field, JSON val) {
        if (val instanceof JSONObject) {
            JSONObject propVal = (JSONObject)val;
            if (propVal.containsKey((Object)"descVal")) {
                JSONObject pluginBody = propVal.getJSONObject("descVal");
                JSONObject pluginVals = new JSONObject();
                JSONObject rawVals = pluginBody.getJSONObject(PLUGIN_EXTENSION_VALS);
                if (rawVals != null) {
                    for (Map.Entry entry : rawVals.entrySet()) {
                        this.convertFieldVal(pluginVals, (String)entry.getKey(), (JSON)entry.getValue());
                    }
                }
                pluginBody.put(PLUGIN_EXTENSION_VALS, (Object)pluginVals);
                vals.put(field, (Object)pluginBody);
            } else {
                vals.put(field, propVal.get((Object)"_primaryVal"));
            }
        } else {
            throw new IllegalStateException("illegal val type:" + val.getClass().getName());
        }
    }

    public Descriptor.PluginValidateResult validate(IControlMsgHandler msgHandler, Context context, FormVaildateType verify, Optional<Descriptor.PostFormVals> parentFormVals) {
        return this.validate(msgHandler, context, Optional.empty(), verify, parentFormVals);
    }

    public Descriptor.PluginValidateResult validate(IControlMsgHandler msgHandler, Context context, Optional<PluginFormProperties> propertyTypes, FormVaildateType verify, Optional<Descriptor.PostFormVals> parentFormVals) {
        return this.descriptor.verify(msgHandler, context, verify, this.attrValMap, propertyTypes, this.subFormFilter, this.propValRewrite, parentFormVals);
    }

    public Descriptor.ParseDescribable createDescribable(IControlMsgHandler pluginContext, Context context) {
        return this.createDescribable(pluginContext, context, Optional.empty());
    }

    public Descriptor.ParseDescribable createDescribable(IControlMsgHandler pluginContext, Context context, Optional<PluginFormProperties> formProperties) {
        return this.descriptor.parseDescribable(pluginContext, context, this.attrValMap, formProperties, this.subFormFilter, this.propValRewrite);
    }

    public int size() {
        return this.attrValMap.size();
    }

    public AttrVals getAttrVals() {
        return this.attrValMap;
    }

    public static interface IAttrVals {
        public static IAttrVals rootForm(final Map<String, JSONObject> sform) {
            return new IAttrVals(){

                @Override
                public Map<String, JSONObject> asRootFormVals() {
                    return sform;
                }

                @Override
                public int size() {
                    return sform.size();
                }
            };
        }

        default public Map<String, JSONObject> asRootFormVals() {
            throw new UnsupportedOperationException();
        }

        default public Map<String, JSONArray> asSubFormDetails() {
            throw new UnsupportedOperationException();
        }

        public int size();
    }
}

