/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.trigger.jst;

import com.qlangtech.tis.cloud.ITISCoordinator;
import com.qlangtech.tis.fs.ITISFileSystem;
import com.qlangtech.tis.fullbuild.indexbuild.IIndexBuildParam;
import com.qlangtech.tis.fullbuild.indexbuild.IndexBuildSourcePathCreator;
import com.qlangtech.tis.fullbuild.indexbuild.LuceneVersion;
import java.io.Serializable;
import java.util.Objects;

public class ImportDataProcessInfo
implements Serializable,
Cloneable,
IIndexBuildParam {
    public static final String KEY_DELIMITER = "split_char";
    public static final String DELIMITER_001 = "char001";
    public static final String DELIMITER_TAB = "tab";
    private static final long serialVersionUID = 1L;
    private final Integer taskId;
    private String indexName;
    private String indexBuilder;
    private LuceneVersion luceneVersion;
    private String timepoint;
    private String buildTableTitleItems;
    private String hdfsdelimiter;
    private IndexBuildSourcePathCreator buildSourcePathCreator;
    private final ITISFileSystem fileSystem;
    private final ITISCoordinator coordinator;

    public IndexBuildSourcePathCreator getIndexBuildSourcePathCreator() {
        Objects.requireNonNull(this.buildSourcePathCreator, "buildSourcePathCreator can not be null ");
        return this.buildSourcePathCreator;
    }

    public void setBuildSourcePathCreator(IndexBuildSourcePathCreator buildSourcePathCreator) {
        this.buildSourcePathCreator = buildSourcePathCreator;
    }

    public ImportDataProcessInfo(Integer taskId, ITISFileSystem fsFactory, ITISCoordinator coordinator) {
        this.taskId = taskId;
        this.fileSystem = fsFactory;
        this.coordinator = coordinator;
    }

    public ITISCoordinator getCoordinator() {
        return this.coordinator;
    }

    public static String createIndexDir(ITISFileSystem fsFactory, String timePoint, String groupNum, String serviceName, boolean isSourceDir) {
        return fsFactory.getRootDir() + "/" + serviceName + "/all/" + groupNum + (!isSourceDir ? "/output" : "") + "/" + timePoint;
    }

    public String getIndexBuilder() {
        return this.indexBuilder;
    }

    public void setIndexBuilder(String indexBuilder) {
        this.indexBuilder = indexBuilder;
    }

    public LuceneVersion getLuceneVersion() {
        return this.luceneVersion;
    }

    public void setLuceneVersion(LuceneVersion luceneVersion) {
        this.luceneVersion = luceneVersion;
    }

    public String getIndexBuildOutputPath(int groupIndex) {
        return ImportDataProcessInfo.createIndexDir(this.fileSystem, this.timepoint, String.valueOf(groupIndex), this.getIndexName(), false);
    }

    public String getHdfsdelimiter() {
        return this.hdfsdelimiter;
    }

    public void setHdfsdelimiter(String hdfsdelimiter) {
        this.hdfsdelimiter = hdfsdelimiter;
    }

    public String getBuildTableTitleItems() {
        return this.buildTableTitleItems;
    }

    public void setBuildTableTitleItems(String buildTableTitleItems) {
        this.buildTableTitleItems = buildTableTitleItems;
    }

    public String getTimepoint() {
        return this.timepoint;
    }

    public void setTimepoint(String timepoint) {
        this.timepoint = timepoint;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getCoreName(int groupNum) {
        return this.getIndexName() + "-" + groupNum;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public Integer getTaskId() {
        return this.taskId;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ImportDataProcessInfo)) {
            return false;
        }
        ImportDataProcessInfo other = (ImportDataProcessInfo)obj;
        return other.getTaskId() == other.getTaskId() + 0;
    }

    public static void main(String[] args) throws Exception {
    }
}

