/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.utils;

import com.alibaba.citrus.turbine.Context;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.extension.PluginManager;
import com.qlangtech.tis.extension.TISExtension;
import com.qlangtech.tis.extension.impl.PluginManifest;
import com.qlangtech.tis.lang.TisException;
import com.qlangtech.tis.order.center.IParamContext;
import com.qlangtech.tis.plugin.IPluginStore;
import com.qlangtech.tis.plugin.annotation.FormField;
import com.qlangtech.tis.plugin.annotation.FormFieldType;
import com.qlangtech.tis.plugin.annotation.ITmpFileStore;
import com.qlangtech.tis.plugin.annotation.Validator;
import com.qlangtech.tis.runtime.module.misc.IControlMsgHandler;
import com.qlangtech.tis.util.IPluginContext;
import com.qlangtech.tis.util.PluginMeta;
import java.io.File;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadCustomizedTPI
implements Describable<UploadCustomizedTPI>,
ITmpFileStore,
IPluginStore.ManipuldateProcessor {
    private static final Logger logger = LoggerFactory.getLogger(UploadCustomizedTPI.class);
    private static final String KEY_FILE = "file";
    @FormField(ordinal=1, type=FormFieldType.FILE, validate={Validator.require})
    public String file;
    @FormField(ordinal=2, type=FormFieldType.ENUM, validate={Validator.require})
    public Boolean forceReplace;
    private transient ITmpFileStore.TmpFile tmp;

    @Override
    public void setTmpeFile(ITmpFileStore.TmpFile tmp) {
        this.tmp = tmp;
    }

    @Override
    public ITmpFileStore.TmpFile getTmpeFile() {
        return this.tmp;
    }

    @Override
    public String getStoreFileName() {
        return this.file;
    }

    private PluginMeta getPluginMeta() {
        ITmpFileStore.TmpFile tmpFile = this.getTmpeFile();
        PluginManifest manifest = PluginManifest.create(tmpFile.tmp);
        PluginMeta pluginMeta = manifest.getPluginMeta();
        return pluginMeta;
    }

    @Override
    public void manipuldateProcess(IPluginContext pluginContext, Optional<Context> context) {
        PluginManager pm = TIS.get().getPluginManager();
        ITmpFileStore.TmpFile tmpFile = this.getTmpeFile();
        PluginMeta pluginMeta = this.getPluginMeta();
        if (StringUtils.isEmpty((String)pluginMeta.getPluginName())) {
            throw new IllegalStateException(this.getStoreFileName() + " is not valid plugin");
        }
        try {
            File targetTpi = new File(TIS.pluginDirRoot, this.getStoreFileName());
            if (targetTpi.exists()) {
                if (!this.forceReplace.booleanValue()) {
                    throw TisException.create((String)("\u63d2\u4ef6\u5305\uff1a\u2018" + targetTpi.getAbsolutePath() + "\u2019\uff0c\u5df2\u7ecf\u5b58\u5728\uff0c\u5982\u9700\u5f3a\u5236\u66ff\u6362\u63d2\u4ef6\u5305\uff0c\u8bf7\u8bbe\u7f6e\u2018\u5f3a\u5236\u66ff\u6362\u2019\u4e3a\u2018\u662f\u2019"));
                }
                FileUtils.moveFile((File)targetTpi, (File)new File(TIS.pluginDirRoot, this.getStoreFileName() + "." + IParamContext.getCurrentMillisecTimeStamp()));
                FileUtils.moveFile((File)tmpFile.tmp, (File)targetTpi);
                pluginContext.addActionMessage(context.get(), "\u66ff\u6362\u5df2\u6709\u63d2\u4ef6\u5305" + this.getStoreFileName() + "\uff0c\u8bf7\u91cd\u542fTIS\u751f\u6548");
            } else {
                pm.dynamicLoad(tmpFile.tmp, false, null);
                pluginContext.addActionMessage(context.get(), "\u5df2\u6210\u529f\u52a0\u8f7d" + this.getStoreFileName() + "\uff0c\u5df2\u751f\u6548");
            }
        }
        catch (Throwable e) {
            throw TisException.create((String)e.getMessage(), (Throwable)e);
        }
    }

    @TISExtension
    public static class DefaultDescriptor
    extends Descriptor<UploadCustomizedTPI> {
        @Override
        protected boolean validateAll(IControlMsgHandler msgHandler, Context context, Descriptor.PostFormVals postFormVals) {
            UploadCustomizedTPI customizedTPI = (UploadCustomizedTPI)postFormVals.newInstance();
            String errMsg = customizedTPI.getStoreFileName() + " \u4e0d\u662f\u7b26\u5408\u89c4\u8303\u7684tpi\u6587\u4ef6";
            try {
                PluginMeta pluginMeta = customizedTPI.getPluginMeta();
                if (StringUtils.isEmpty((String)pluginMeta.getPluginName())) {
                    msgHandler.addFieldError(context, UploadCustomizedTPI.KEY_FILE, errMsg, new Object[0]);
                    return false;
                }
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
                msgHandler.addFieldError(context, UploadCustomizedTPI.KEY_FILE, errMsg, new Object[0]);
                return false;
            }
            return true;
        }
    }
}

