/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.trigger;

import com.alibaba.citrus.turbine.Context;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.manage.common.HttpUtils;
import com.qlangtech.tis.order.center.IParamContext;
import com.qlangtech.tis.plugin.IdentityName;
import com.qlangtech.tis.workflow.pojo.WorkFlowBuildHistory;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class JobTrigger
implements Describable<JobTrigger> {
    public static Optional<JobTrigger> getPartialTriggerFromContext(Context context) {
        Optional<JobTrigger> partialTrigger = Optional.ofNullable((JobTrigger)context.get(JobTrigger.class.getName()));
        return partialTrigger;
    }

    protected void setPartialTrigger2Context(Optional<Context> context, JobTrigger trigger) {
        if (!context.isPresent()) {
            throw new IllegalStateException("context must be present");
        }
        context.get().put(JobTrigger.class.getName(), (Object)trigger);
    }

    public abstract List<IdentityName> selectedTabs();

    public static Optional<JobTrigger> getTriggerFromHttpParam(IParamContext params) {
        String partialTabs = Objects.requireNonNull(params, "param params can not be null").getString("partialTabs");
        if (StringUtils.isBlank((CharSequence)partialTabs)) {
            return Optional.empty();
        }
        final List targetTabs = Arrays.stream(StringUtils.split((String)partialTabs, (String)",")).map(id -> IdentityName.create((String)id)).collect(Collectors.toList());
        JobTrigger trigger = new JobTrigger(){

            @Override
            public List<IdentityName> selectedTabs() {
                return targetTabs;
            }
        };
        return Optional.of(trigger);
    }

    public HttpUtils.PostParam getHttpPostSelectedTabsAsParam() {
        if (CollectionUtils.isEmpty(this.selectedTabs())) {
            throw new IllegalStateException("selected tabs can not be empty");
        }
        return new HttpUtils.PostParam("partialTabs", (Object)this.selectedTabs().stream().map(tab -> tab.identityValue()).collect(Collectors.joining(",")));
    }

    public static void addLatestWorkflowHistoryAsParam(List<HttpUtils.PostParam> params, Optional<WorkFlowBuildHistory> latestWorkflowHistory) {
        latestWorkflowHistory.ifPresent(wfHistory -> params.add(new HttpUtils.PostParam("latest_workflow_history_id", (Object)wfHistory.getId())));
    }
}

