/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.timezone;

import com.alibaba.citrus.turbine.Context;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.extension.TISExtension;
import com.qlangtech.tis.plugin.annotation.FormField;
import com.qlangtech.tis.plugin.annotation.FormFieldType;
import com.qlangtech.tis.plugin.annotation.Validator;
import com.qlangtech.tis.plugin.timezone.TISTimeZone;
import com.qlangtech.tis.runtime.module.misc.IFieldErrorHandler;
import java.time.ZoneId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomizeTISTimeZone
extends TISTimeZone {
    private static final Logger logger = LoggerFactory.getLogger(CustomizeTISTimeZone.class);
    @FormField(ordinal=1, type=FormFieldType.INPUTTEXT, validate={Validator.require})
    public String timeZone;

    @Override
    public ZoneId getTimeZone() {
        return ZoneId.of(this.timeZone);
    }

    @TISExtension
    public static class Desc
    extends Descriptor<TISTimeZone> {
        public boolean validateTimeZone(IFieldErrorHandler msgHandler, Context context, String fieldName, String value) {
            try {
                ZoneId.of(value);
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
                msgHandler.addFieldError(context, fieldName, e.getMessage(), new Object[0]);
                return false;
            }
            return true;
        }

        @Override
        public String getDisplayName() {
            return "customize";
        }
    }
}

