/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.tdfs;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public interface ITDFSSession
extends AutoCloseable {
    public String getRootPath();

    public boolean isDirExist(String var1);

    public void mkDirRecursive(String var1);

    public Set<String> getAllFilesInDir(String var1, String var2);

    public void deleteFiles(Set<String> var1);

    public HashSet<Res> getAllFiles(List<String> var1, int var2, int var3);

    public HashSet<Res> getListFiles(String var1, int var2, int var3);

    default public OutputStream getOutputStream(String filePath) {
        return this.getOutputStream(filePath, false);
    }

    public OutputStream getOutputStream(String var1, boolean var2);

    public InputStream getInputStream(String var1);

    public static class Res {
        public final String fullPath;
        public final String relevantPath;

        public static List<String> appendElement(List<String> relevantPaths, String fileName) {
            relevantPaths = Lists.newArrayList(relevantPaths);
            relevantPaths.add(StringUtils.remove((String)fileName, (String)File.separator));
            return relevantPaths;
        }

        public static String buildRelevantPath(List<String> relevantPaths, String fileName) {
            return Res.appendElement(relevantPaths, fileName).stream().collect(Collectors.joining(File.separator));
        }

        public Res(String fullPath, String relevantPath) {
            this.fullPath = fullPath;
            this.relevantPath = relevantPath;
        }
    }
}

