/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.tdfs;

import com.google.common.collect.Sets;
import com.qlangtech.tis.datax.IDataxProcessor;
import com.qlangtech.tis.datax.IGroupChildTaskIterator;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.plugin.annotation.FormField;
import com.qlangtech.tis.plugin.annotation.FormFieldType;
import com.qlangtech.tis.plugin.annotation.Validator;
import com.qlangtech.tis.plugin.ds.CMeta;
import com.qlangtech.tis.plugin.ds.ColumnMetaData;
import com.qlangtech.tis.plugin.ds.ISelectedTab;
import com.qlangtech.tis.plugin.ds.TableNotFoundException;
import com.qlangtech.tis.plugin.tdfs.IDFSReader;
import com.qlangtech.tis.plugin.tdfs.ITDFSSession;
import com.qlangtech.tis.sql.parser.tuple.creator.EntityName;
import com.qlangtech.tis.util.IPluginContext;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

public abstract class DFSResMatcher
implements Describable<DFSResMatcher> {
    @FormField(ordinal=14, type=FormFieldType.INT_NUMBER, validate={Validator.require})
    public Integer maxTraversalLevel;

    public abstract boolean isRDBMSSupport();

    public abstract SourceColsMeta getSourceColsMeta(ITDFSSession var1, Optional<String> var2, String var3, IDataxProcessor var4);

    public abstract List<ISelectedTab> getSelectedTabs(IDFSReader var1);

    public abstract List<ColumnMetaData> getTableMetadata(IDFSReader var1, IDataxProcessor.TableMap var2) throws TableNotFoundException;

    public abstract List<ColumnMetaData> getTableMetadata(IPluginContext var1, String var2, IDFSReader var3, EntityName var4) throws TableNotFoundException;

    public abstract boolean hasMulitTable(IDFSReader var1);

    public abstract IGroupChildTaskIterator getSubTasks(Predicate<ISelectedTab> var1, IDFSReader var2);

    public final Set<ITDFSSession.Res> findAllRes(ITDFSSession dfsSession) {
        return this.findAllRes(dfsSession, Collections.singletonList(dfsSession.getRootPath()));
    }

    public final Set<ITDFSSession.Res> findAllRes(ITDFSSession dfsSession, List<String> targetPath) {
        HashSet<ITDFSSession.Res> candidate = dfsSession.getAllFiles(targetPath, 0, this.maxTraversalLevel);
        HashSet result = Sets.newHashSet();
        for (ITDFSSession.Res path : candidate) {
            if (!this.isMatch(path)) continue;
            result.add(path);
        }
        return result;
    }

    public abstract boolean isMatch(ITDFSSession.Res var1);

    public static class SourceColsMeta {
        private final List<CMeta> colsMeta;
        private final Predicate<String> colSelectedPredicate;

        public SourceColsMeta(List<CMeta> colsMeta) {
            this(colsMeta, col -> true);
        }

        public SourceColsMeta(List<CMeta> colsMeta, Predicate<String> colSelectedPredicate) {
            this.colsMeta = colsMeta;
            this.colSelectedPredicate = colSelectedPredicate;
        }

        public boolean colSelected(String col) {
            return this.colSelectedPredicate.test(col);
        }

        public List<CMeta> getColsMeta() {
            return this.colsMeta;
        }
    }
}

