/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.rate;

import com.alibaba.citrus.turbine.Context;
import com.qlangtech.tis.config.ParamsConfig;
import com.qlangtech.tis.datax.DataXName;
import com.qlangtech.tis.extension.TISExtension;
import com.qlangtech.tis.plugin.annotation.FormField;
import com.qlangtech.tis.plugin.annotation.FormFieldType;
import com.qlangtech.tis.plugin.annotation.Validator;
import com.qlangtech.tis.runtime.module.misc.IFieldErrorHandler;
import com.qlangtech.tis.util.UploadPluginMeta;
import java.io.File;
import java.time.Duration;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class IndexCollectionConfig
extends ParamsConfig {
    private static final String INDEX_COLLECTION_CONFIG = IndexCollectionConfig.class.getSimpleName();
    @FormField(ordinal=0, identity=true, type=FormFieldType.INPUTTEXT, validate={Validator.require, Validator.identity})
    public String name;
    @FormField(ordinal=1, type=FormFieldType.DURATION_OF_SECOND, validate={Validator.require})
    public Duration duration;

    public static int defaultDuration() {
        return 5;
    }

    @Override
    public boolean test(UploadPluginMeta uploadPluginMeta) {
        return StringUtils.equals((CharSequence)this.identityValue(), (CharSequence)uploadPluginMeta.getPluginContext().getCollectionName().getPipelineName());
    }

    @Override
    public String getStoreGroup() {
        return super.getStoreGroup() + File.separator + this.identityValue();
    }

    public static IndexCollectionConfig getIndexCollectionConfig(DataXName dataXName) {
        return (IndexCollectionConfig)ParamsConfig.getItem(dataXName.getPipelineName(), INDEX_COLLECTION_CONFIG, Optional.empty(), false);
    }

    public IndexCollectionConfig createConfigInstance() {
        return this;
    }

    public String identityValue() {
        return this.name;
    }

    @TISExtension
    public static class DefaultDesc
    extends ParamsConfig.BasicParamsConfigDescriptor {
        static int minIntervalSec = 1;
        static int maxIntervalSec = 10;

        public DefaultDesc() {
            super(INDEX_COLLECTION_CONFIG);
        }

        @Override
        public String helpPath() {
            return "docs/guide/rate-controller";
        }

        public boolean validateDuration(IFieldErrorHandler msgHandler, Context context, String fieldName, String value) {
            int val = Integer.parseInt(value);
            if (val < minIntervalSec) {
                msgHandler.addFieldError(context, fieldName, "\u4e0d\u80fd\u5c0f\u4e8e" + minIntervalSec + "\u79d2", new Object[0]);
                return false;
            }
            if (val > maxIntervalSec) {
                msgHandler.addFieldError(context, fieldName, "\u4e0d\u80fd\u5927\u4e8e" + maxIntervalSec + "\u79d2", new Object[0]);
                return false;
            }
            return true;
        }
    }
}

