/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.rate;

import com.alibaba.citrus.turbine.Context;
import com.qlangtech.tis.config.ParamsConfig;
import com.qlangtech.tis.datax.DataXName;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.extension.TISExtension;
import com.qlangtech.tis.manage.common.AppAndRuntime;
import com.qlangtech.tis.plugin.IEndTypeGetter;
import com.qlangtech.tis.plugin.IPluginStore;
import com.qlangtech.tis.plugin.annotation.FormField;
import com.qlangtech.tis.plugin.annotation.FormFieldType;
import com.qlangtech.tis.plugin.annotation.Validator;
import com.qlangtech.tis.plugin.incr.IncrStreamFactory;
import com.qlangtech.tis.plugin.rate.IncrRateParam;
import com.qlangtech.tis.realtime.yarn.rpc.IncrRateControllerCfgDTO;
import com.qlangtech.tis.runtime.module.misc.IControlMsgHandler;
import com.qlangtech.tis.util.IPluginContext;
import com.qlangtech.tis.util.UploadPluginMeta;
import java.io.File;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class IncrRateController
extends ParamsConfig
implements IPluginStore.AfterPluginSaved,
IPluginStore.BeforePluginSaved {
    private static final String INCR_RATE_CONTROLLER = IncrRateController.class.getSimpleName();
    @FormField(ordinal=0, identity=true, type=FormFieldType.INPUTTEXT, validate={Validator.require, Validator.identity})
    public String name;
    public Long lastModified;
    @FormField(ordinal=1, type=FormFieldType.ENUM, validate={Validator.require})
    public Boolean pause;
    @FormField(ordinal=2, validate={Validator.require})
    public IncrRateParam rateCfg;

    public static final String dftProcessName() {
        AppAndRuntime appAndRuntime = Objects.requireNonNull(AppAndRuntime.getAppAndRuntime(), "appAndRuntime can not be null");
        return String.valueOf(appAndRuntime.getAppName());
    }

    public static IncrRateController getRateController(DataXName dataXName) {
        String pipelineName = dataXName.getPipelineName();
        return (IncrRateController)ParamsConfig.getItem(dataXName.getPipelineName(), INCR_RATE_CONTROLLER + File.separator + pipelineName, Optional.empty(), false);
    }

    @Override
    public boolean test(UploadPluginMeta uploadPluginMeta) {
        return StringUtils.equals((CharSequence)this.name, (CharSequence)uploadPluginMeta.getPluginContext().getCollectionName().getPipelineName());
    }

    @Override
    public String getStoreGroup() {
        return super.getStoreGroup() + File.separatorChar + this.identityValue();
    }

    @Override
    public void beforeSaved(IPluginContext pluginContext, Optional<Context> context) {
        this.lastModified = System.currentTimeMillis();
    }

    public IncrRateController createConfigInstance() {
        return this;
    }

    @Override
    public void afterSaved(IPluginContext pluginContext, Optional<Context> context) {
    }

    public String identityValue() {
        return this.name;
    }

    public IncrRateControllerCfgDTO createIncrRateControllerCfgDTO() {
        IncrRateControllerCfgDTO cfgDTO = new IncrRateControllerCfgDTO();
        cfgDTO.setPayloadParams(Objects.requireNonNull(this.rateCfg).getPayloadParams());
        cfgDTO.setControllerType(this.rateCfg.getControllerType());
        if (this.pause.booleanValue()) {
            cfgDTO.setControllerType(IncrRateControllerCfgDTO.RateControllerType.Paused);
        }
        cfgDTO.setLastModified(this.lastModified);
        return cfgDTO;
    }

    @TISExtension
    public static class DftDesc
    extends ParamsConfig.BasicParamsConfigDescriptor
    implements IEndTypeGetter {
        public DftDesc() {
            super(INCR_RATE_CONTROLLER);
        }

        @Override
        public String helpPath() {
            return "docs/guide/rate-controller";
        }

        @Override
        public IEndTypeGetter.EndType getEndType() {
            return IEndTypeGetter.EndType.RateController;
        }

        @Override
        protected boolean validateAll(IControlMsgHandler msgHandler, Context context, Descriptor.PostFormVals postFormVals) {
            String nameVal = postFormVals.getField("name");
            IncrStreamFactory streamFactory = IncrStreamFactory.getFactory(nameVal);
            if (!Objects.requireNonNull(streamFactory, "streamFactory can not be null").supportRateLimiter()) {
                msgHandler.addErrorMessage(context, "\u7531\u4e8e\u5728\u589e\u91cf\u5b9e\u4f8b\u914d\u7f6e\u4e2d\u6ca1\u6709\u5f00\u542f\u5f00\u542f\u6d41\u63a7\u5f00\u5173\uff0c\u56e0\u6b64\u4e0d\u80fd\u5728\u8fd0\u884c\u65f6\u52a8\u6001\u8c03\u6574\u6d41\u63a7\uff0c\u8be6\u7ec6\u8bf7\u54a8\u8be2\u9879\u76ee\u7ba1\u7406\u5458");
                return false;
            }
            return true;
        }

        @Override
        protected boolean verify(IControlMsgHandler msgHandler, Context context, Descriptor.PostFormVals postFormVals) {
            return this.validateAll(msgHandler, context, postFormVals);
        }
    }
}

