/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.proxy;

import com.alibaba.citrus.turbine.Context;
import com.qlangtech.tis.config.ParamsConfig;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.extension.TISExtension;
import com.qlangtech.tis.manage.common.IURLConnectionSender;
import com.qlangtech.tis.plugin.IEndTypeGetter;
import com.qlangtech.tis.plugin.IPluginStore;
import com.qlangtech.tis.plugin.annotation.FormField;
import com.qlangtech.tis.plugin.annotation.FormFieldType;
import com.qlangtech.tis.plugin.annotation.Validator;
import com.qlangtech.tis.plugin.proxy.HttpRequestProxyAuth;
import com.qlangtech.tis.realtime.utils.NetUtils;
import com.qlangtech.tis.runtime.module.misc.IControlMsgHandler;
import com.qlangtech.tis.runtime.module.misc.IFieldErrorHandler;
import com.qlangtech.tis.util.IPluginContext;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Optional;

public class HttpRequestProxy
extends ParamsConfig
implements IURLConnectionSender,
IPluginStore.AfterPluginSaved,
IPluginStore.AfterPluginDeleted {
    public static final String ConfigType = "Http-Proxy";
    public static final String FIELD_PROXY_PORT = "proxyPort";
    @FormField(identity=true, type=FormFieldType.INPUTTEXT, ordinal=0, validate={Validator.require, Validator.identity})
    public String name;
    @FormField(type=FormFieldType.ENUM, ordinal=1, validate={Validator.require})
    public Boolean enable;
    @FormField(type=FormFieldType.INPUTTEXT, ordinal=2, validate={Validator.require, Validator.hostWithoutPort})
    public String proxyHost;
    @FormField(type=FormFieldType.INPUTTEXT, ordinal=3, validate={Validator.require, Validator.integer})
    public Integer proxyPort;
    @FormField(ordinal=4, validate={Validator.require, Validator.integer})
    public HttpRequestProxyAuth auth;
    private transient ProxySelector _proxy;

    private ProxySelector getProxy() {
        if (this._proxy == null) {
            this._proxy = ProxySelector.of(new InetSocketAddress(this.proxyHost, (int)this.proxyPort));
        }
        return this._proxy;
    }

    public HttpRequestProxy createConfigInstance() {
        return this;
    }

    public String identityValue() {
        return this.name;
    }

    @Override
    public void afterSaved(IPluginContext pluginContext, Optional<Context> context) {
        IURLConnectionSender.sender[0] = this.enable != false ? this : HttpRequestProxy.disableHttpProxy();
        this._proxy = null;
    }

    public HttpClient.Builder setHttpClientBuilder(HttpClient.Builder clientBuilder, boolean skipProxy) {
        if (skipProxy) {
            return clientBuilder;
        }
        clientBuilder.proxy(this.getProxy());
        this.auth.setHttpClientBuilder(clientBuilder);
        return clientBuilder;
    }

    @Override
    public void afterDeleted(IPluginContext pluginContext, Optional<Context> context) {
        HttpRequestProxy.disableHttpProxy();
    }

    private static IURLConnectionSender disableHttpProxy() {
        IURLConnectionSender.sender[0] = new IURLConnectionSender(){

            public HttpClient.Builder setHttpClientBuilder(HttpClient.Builder clientBuilder, boolean skipProxy) {
                return clientBuilder;
            }
        };
        return IURLConnectionSender.sender[0];
    }

    @TISExtension
    public static class DefaultHttpRequestProxyDescriptor
    extends ParamsConfig.BasicParamsConfigDescriptor
    implements IEndTypeGetter {
        public DefaultHttpRequestProxyDescriptor() {
            super(HttpRequestProxy.ConfigType);
        }

        @Override
        public IEndTypeGetter.EndType getEndType() {
            return IEndTypeGetter.EndType.HttpProxy;
        }

        public boolean validateProxyHost(IFieldErrorHandler msgHandler, Context context, String fieldName, String value) {
            if (!NetUtils.isReachable((String)value)) {
                msgHandler.addFieldError(context, fieldName, "\u65e0\u6cd5\u8fde\u63a5", new Object[0]);
                return false;
            }
            return true;
        }

        @Override
        protected boolean validateAll(IControlMsgHandler msgHandler, Context context, Descriptor.PostFormVals postFormVals) {
            return this.verify(msgHandler, context, postFormVals);
        }

        @Override
        protected boolean verify(IControlMsgHandler msgHandler, Context context, Descriptor.PostFormVals postFormVals) {
            HttpRequestProxy proxy = (HttpRequestProxy)postFormVals.newInstance();
            if (!NetUtils.isPortAvailable((String)proxy.proxyHost, (int)proxy.proxyPort)) {
                msgHandler.addFieldError(context, HttpRequestProxy.FIELD_PROXY_PORT, "\u7aef\u53e3\u4e0d\u53ef\u7528", new Object[0]);
                return false;
            }
            String testUrl = "http://www.baidu.com";
            try {
                HttpClient.Builder clientBuilder = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L));
                proxy.setHttpClientBuilder(clientBuilder, false);
                HttpClient client = clientBuilder.build();
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create("http://www.baidu.com")).timeout(Duration.ofSeconds(10L)).GET().build();
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() < 200 || response.statusCode() >= 300) {
                    msgHandler.addErrorMessage(context, "Proxy connection test failed with HTTP status code: " + response.statusCode());
                    return false;
                }
                return true;
            }
            catch (ConnectException e) {
                msgHandler.addErrorMessage(context, "Failed to connect to proxy server at " + proxy.proxyHost + ":" + proxy.proxyPort + ". Please check if the proxy server is running and the host/port are correct");
                return false;
            }
            catch (SocketTimeoutException e) {
                msgHandler.addErrorMessage(context, "Connection to proxy server timed out. Please check if the proxy server is accessible");
                return false;
            }
            catch (UnknownHostException e) {
                msgHandler.addErrorMessage(context, "Unknown proxy host: " + proxy.proxyHost + ". Please verify the proxy hostname");
                return false;
            }
            catch (IOException e) {
                msgHandler.addErrorMessage(context, "Proxy connection test failed: " + e.getMessage());
                return false;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                msgHandler.addErrorMessage(context, "Proxy connection test was interrupted");
                return false;
            }
            catch (Exception e) {
                msgHandler.addErrorMessage(context, "Unexpected error during proxy verification: " + e.getMessage());
                return false;
            }
        }
    }
}

