/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.llm.log;

import com.alibaba.fastjson.JSONObject;
import com.qlangtech.tis.aiagent.core.IAgentContext;
import com.qlangtech.tis.aiagent.llm.UserPrompt;
import com.qlangtech.tis.manage.common.HttpUtils;
import com.qlangtech.tis.plugin.llm.log.BasicExecuteLog;
import com.qlangtech.tis.plugin.llm.log.ExecuteLog;
import com.qlangtech.tis.trigger.util.JsonUtil;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;

public class DefaultExecuteLog
extends BasicExecuteLog
implements ExecuteLog {
    private List<HttpUtils.PostParam> postParams;
    private JSONObject responseJson;
    private JSONObject errBody;
    private final Logger logger;

    DefaultExecuteLog(UserPrompt prompt, IAgentContext context, Logger logger) {
        super(prompt, context);
        this.logger = Objects.requireNonNull(logger, "logger can not be null");
    }

    @Override
    public void setPostParams(List<HttpUtils.PostParam> postParams) {
        super.setPostParams(postParams);
        this.postParams = postParams;
    }

    @Override
    public void setError(JSONObject errBody) {
        super.setError(errBody);
        this.errBody = errBody;
    }

    @Override
    public void setResponse(JSONObject responseJson) {
        this.responseJson = responseJson;
    }

    @Override
    public void summary() {
        super.summary();
        StringBuilder summary = new StringBuilder();
        summary.append("\nparams---------------------------------------------------------------\n");
        summary.append(JsonUtil.toString(this.postParams, (boolean)true));
        summary.append("\nuser prompt----------------------------------------------------------\n");
        summary.append(this.prompt.getPrompt());
        summary.append("\nresponse--------------------------------------------------------------\n");
        if (this.responseJson != null) {
            summary.append(JsonUtil.toString((Object)this.responseJson, (boolean)true));
        } else {
            summary.append("none");
        }
        if (this.errBody != null) {
            summary.append("\nerror--------------------------------------------------------------\n");
            summary.append(JsonUtil.toString((Object)this.errBody, (boolean)true));
        }
        this.logger.info(summary.toString());
    }
}

