/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.llm.log;

import com.alibaba.fastjson.JSONObject;
import com.qlangtech.tis.aiagent.core.IAgentContext;
import com.qlangtech.tis.aiagent.llm.LLMProvider;
import com.qlangtech.tis.aiagent.llm.UserPrompt;
import com.qlangtech.tis.manage.common.HttpUtils;
import com.qlangtech.tis.plugin.llm.log.ExecuteLog;
import java.util.List;
import java.util.Objects;

public abstract class BasicExecuteLog
implements ExecuteLog {
    protected final UserPrompt prompt;
    protected final IAgentContext context;

    public BasicExecuteLog(UserPrompt prompt, IAgentContext context) {
        this.prompt = Objects.requireNonNull(prompt, "prompt can not be null");
        this.context = Objects.requireNonNull(context, "context can not be null");
    }

    @Override
    public void setPostParams(List<HttpUtils.PostParam> postParams) {
        this.context.sendLLMStatus(LLMProvider.LLMChatPhase.Start, this.prompt.getAbstractInfo());
    }

    @Override
    public void setError(JSONObject errBody) {
        JSONObject errDetail = errBody.getJSONObject("error");
        String errMessage = errDetail.getString("message");
        this.context.sendLLMStatus(LLMProvider.LLMChatPhase.ERROR, errMessage);
    }

    @Override
    public void summary() {
        this.context.sendLLMStatus(LLMProvider.LLMChatPhase.Complete, null);
    }
}

