/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.llm;

import com.alibaba.citrus.turbine.Context;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.qlangtech.tis.aiagent.core.IAgentContext;
import com.qlangtech.tis.aiagent.llm.LLMProvider;
import com.qlangtech.tis.aiagent.llm.UserPrompt;
import com.qlangtech.tis.config.ParamsConfig;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.extension.TISExtension;
import com.qlangtech.tis.lang.TisException;
import com.qlangtech.tis.manage.common.ConfigFileContext;
import com.qlangtech.tis.manage.common.HttpUtils;
import com.qlangtech.tis.manage.common.PostFormStreamProcess;
import com.qlangtech.tis.manage.common.TisUTF8;
import com.qlangtech.tis.plugin.IEndTypeGetter;
import com.qlangtech.tis.plugin.annotation.FormField;
import com.qlangtech.tis.plugin.annotation.FormFieldType;
import com.qlangtech.tis.plugin.annotation.Validator;
import com.qlangtech.tis.plugin.llm.log.ExecuteLog;
import com.qlangtech.tis.runtime.module.misc.IControlMsgHandler;
import com.qlangtech.tis.runtime.module.misc.IFieldErrorHandler;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TISExtension
public class QWenLLMProvider
extends LLMProvider {
    private static final Logger logger = LoggerFactory.getLogger(QWenLLMProvider.class);
    private static final String URL_PATH = "/compatible-mode/v1/chat/completions";
    public static final String DEFAULT_MODEL = "qwen-plus";
    public static final String DEFAULT_BASE_URL = "https://dashscope.aliyuncs.com";
    @FormField(identity=true, type=FormFieldType.INPUTTEXT, ordinal=0, validate={Validator.require, Validator.identity})
    public String name;
    @FormField(type=FormFieldType.INPUTTEXT, ordinal=1, validate={Validator.require, Validator.url})
    public String baseUrl;
    @FormField(type=FormFieldType.PASSWORD, ordinal=2, validate={Validator.require})
    public String apiKey;
    @FormField(type=FormFieldType.INT_NUMBER, ordinal=3, validate={Validator.require, Validator.integer})
    public Integer maxTokens;
    @FormField(type=FormFieldType.ENUM, ordinal=4, validate={Validator.require})
    public String model;
    @FormField(type=FormFieldType.DECIMAL_NUMBER, advance=true, ordinal=5, validate={Validator.require})
    public Float temperature;
    @FormField(type=FormFieldType.DECIMAL_NUMBER, advance=true, ordinal=6, validate={})
    public Float topP;
    public final Boolean stream = false;
    @FormField(type=FormFieldType.ENUM, advance=true, ordinal=9, validate={Validator.require})
    public Boolean printLog;

    @Override
    public LLMProvider.LLMResponse chat(IAgentContext context, UserPrompt prompt, List<String> systemPrompt) {
        return this.chat(context, prompt, systemPrompt, true);
    }

    public LLMProvider.LLMResponse chat(final IAgentContext context, UserPrompt prompt, List<String> systemPrompt, boolean logSummary) {
        final ExecuteLog executeLog = ExecuteLog.create(this.printLog, prompt, context, logger);
        try {
            ArrayList<HttpUtils.PostParam> postParams = new ArrayList<HttpUtils.PostParam>();
            postParams.add(new HttpUtils.PostParam("model", (Object)this.getModel()));
            JSONArray messages = new JSONArray();
            if (CollectionUtils.isNotEmpty(systemPrompt)) {
                for (String sysP : systemPrompt) {
                    JSONObject systemMessage = new JSONObject();
                    systemMessage.put("role", (Object)"system");
                    systemMessage.put("content", (Object)sysP);
                    messages.add((Object)systemMessage);
                }
            }
            JSONObject userMessage = new JSONObject();
            userMessage.put("role", (Object)"user");
            userMessage.put("content", (Object)prompt.getPrompt());
            messages.add((Object)userMessage);
            postParams.add(new HttpUtils.PostParam("messages", (Object)messages));
            postParams.add(new HttpUtils.PostParam("temperature", (Object)this.temperature));
            postParams.add(new HttpUtils.PostParam("max_tokens", (Object)this.getMaxTokens()));
            if (this.topP != null) {
                postParams.add(new HttpUtils.PostParam("top_p", (Object)this.topP));
            }
            if (this.stream != null) {
                postParams.add(new HttpUtils.PostParam("stream", (Object)this.stream));
            }
            executeLog.setPostParams(postParams);
            LLMProvider.LLMResponse lLMResponse = (LLMProvider.LLMResponse)HttpUtils.post((URL)new URL(this.getApiUrl()), postParams, (PostFormStreamProcess)new PostFormStreamProcess<LLMProvider.LLMResponse>((List)Lists.newArrayList((Object[])new ConfigFileContext.Header[]{new ConfigFileContext.Header("Authorization", "Bearer " + this.getApiKey()), new ConfigFileContext.Header("Content-Type", "application/json")})){

                public PostFormStreamProcess.ContentType getContentType() {
                    return PostFormStreamProcess.ContentType.JSON;
                }

                public int getMaxRetry() {
                    return Objects.requireNonNull(QWenLLMProvider.this.maxRetry, "maxRetry can not be null");
                }

                public Duration getSocketReadTimeout() {
                    return QWenLLMProvider.this.readTimeout;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void error(int status, InputStream errstream, IOException e) {
                    if (errstream == null) throw new RuntimeException(e);
                    try {
                        String errContent = IOUtils.toString((InputStream)errstream, (Charset)TisUTF8.get());
                        JSONObject errBody = null;
                        try {
                            errBody = JSONObject.parseObject((String)errContent);
                            executeLog.setError(errBody);
                        }
                        catch (Exception ex) {
                            throw TisException.create((String)("API Error: " + errContent));
                        }
                        if (errBody.containsKey((Object)"error")) {
                            JSONObject errDetail = errBody.getJSONObject("error");
                            String errMessage = errDetail.getString("message");
                            String errCode = errDetail.getString("code");
                            if (!StringUtils.isNotEmpty((String)errMessage)) return;
                            throw TisException.create((String)String.format("QWen API Error [%s]: %s", errCode, errMessage));
                        } else {
                            if (!errBody.containsKey((Object)"message")) return;
                            String errMessage = errBody.getString("message");
                            throw TisException.create((String)("QWen API Error: " + errMessage));
                        }
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(e);
                    }
                }

                public LLMProvider.LLMResponse p(int status, InputStream stream, Map headerFields) throws IOException {
                    JSONArray choices;
                    LLMProvider.LLMResponse response = new LLMProvider.LLMResponse(executeLog);
                    String responseStr = IOUtils.toString((InputStream)stream, (Charset)TisUTF8.get());
                    JSONObject responseJson = JSON.parseObject((String)responseStr);
                    executeLog.setResponse(responseJson);
                    if (responseJson.containsKey((Object)"choices") && !(choices = responseJson.getJSONArray("choices")).isEmpty()) {
                        JSONObject choice = choices.getJSONObject(0);
                        JSONObject message = choice.getJSONObject("message");
                        response.setContent(message.getString("content"));
                        response.setSuccess(true);
                        String finishReason = choice.getString("finish_reason");
                        if ("length".equals(finishReason)) {
                            logger.warn("Response was truncated due to max_tokens limit");
                        }
                    }
                    if (responseJson.containsKey((Object)"usage")) {
                        JSONObject usage = responseJson.getJSONObject("usage");
                        response.setPromptTokens(usage.getLongValue("prompt_tokens"));
                        response.setCompletionTokens(usage.getLongValue("completion_tokens"));
                        context.updateTokenUsage(usage.getLongValue("total_tokens"));
                    }
                    response.setModel(responseJson.getString("model"));
                    return response;
                }
            });
            return lLMResponse;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Invalid URL: " + this.getApiUrl(), e);
        }
        finally {
            if (logSummary) {
                executeLog.summary();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LLMProvider.LLMResponse chatJson(IAgentContext context, UserPrompt prompt, List<String> systemPrompt, String jsonSchema) {
        Object enhancedPrompt = prompt.getPrompt();
        if (StringUtils.isNotEmpty((String)jsonSchema)) {
            enhancedPrompt = (String)enhancedPrompt + "\n\n\u8bf7\u4e25\u683c\u6309\u7167\u4ee5\u4e0aJSON Schema\u683c\u5f0f\u8fd4\u56de\u7ed3\u679c\uff0c\u53ea\u8fd4\u56deJSON\uff0c\u4e0d\u8981\u5305\u542b\u5176\u4ed6\u8bf4\u660e\u6587\u5b57\uff1a\n" + jsonSchema;
            enhancedPrompt = (String)enhancedPrompt + "\n\n\u91cd\u8981\uff1a\u8bf7\u786e\u4fdd\u8fd4\u56de\u7684\u662f\u6709\u6548\u7684JSON\u683c\u5f0f\uff0c\u4e0d\u8981\u5305\u542bmarkdown\u6807\u8bb0\u6216\u5176\u4ed6\u6587\u672c\u3002";
        }
        LLMProvider.LLMResponse response = this.chat(context, prompt.setNewPrompt((String)enhancedPrompt), systemPrompt, false);
        try {
            if (response.isSuccess() && response.getContent() != null) {
                String content = response.getContent();
                content = content.replaceAll("```json\\s*", "").replaceAll("```\\s*$", "");
                content = content.trim();
                int start = content.indexOf("{");
                int end = content.lastIndexOf("}") + 1;
                if (start >= 0 && end > start) {
                    String jsonStr = content.substring(start, end);
                    try {
                        JSONObject jsonContent = JSON.parseObject((String)jsonStr);
                        response.setJsonContent(jsonContent);
                        response.executeLog.setResponse(jsonContent);
                    }
                    catch (Exception e) {
                        logger.error("Failed to parse JSON response: " + jsonStr, (Throwable)e);
                        response.setSuccess(false);
                    }
                } else {
                    try {
                        JSONObject jsonContent = JSON.parseObject((String)content);
                        response.setJsonContent(jsonContent);
                        response.executeLog.setResponse(jsonContent);
                    }
                    catch (Exception e) {
                        logger.error("Failed to parse JSON response: " + content, (Throwable)e);
                        response.setSuccess(false);
                    }
                }
            }
        }
        finally {
            response.executeLog.summary();
        }
        return response;
    }

    @Override
    public String getProviderName() {
        return "QWen";
    }

    @Override
    public boolean isAvailable() {
        return this.getApiKey() != null && !this.getApiKey().isEmpty();
    }

    public LLMProvider createConfigInstance() {
        return this;
    }

    public String identityValue() {
        return this.name;
    }

    private int getMaxTokens() {
        return this.maxTokens != null ? this.maxTokens : 2048;
    }

    private String getModel() {
        return StringUtils.isNotEmpty((String)this.model) ? this.model : DEFAULT_MODEL;
    }

    private String getApiKey() {
        return this.apiKey;
    }

    private String getApiUrl() {
        String url = StringUtils.isNotEmpty((String)this.baseUrl) ? this.baseUrl : DEFAULT_BASE_URL;
        return url + URL_PATH;
    }

    @TISExtension
    public static final class DftDescriptor
    extends ParamsConfig.BasicParamsConfigDescriptor
    implements IEndTypeGetter {
        public DftDescriptor() {
            super("LLM");
        }

        @Override
        public String getDisplayName() {
            return "QWen";
        }

        @Override
        protected boolean validateAll(IControlMsgHandler msgHandler, Context context, Descriptor.PostFormVals postFormVals) {
            return this.verify(msgHandler, context, postFormVals);
        }

        @Override
        protected boolean verify(IControlMsgHandler msgHandler, Context context, Descriptor.PostFormVals postFormVals) {
            QWenLLMProvider llmProvider = (QWenLLMProvider)postFormVals.newInstance();
            try {
                llmProvider.chat(IAgentContext.createNull(), new UserPrompt("test", "hello"), null);
            }
            catch (Exception e) {
                msgHandler.addErrorMessage(context, e.getMessage());
                return false;
            }
            return super.verify(msgHandler, context, postFormVals);
        }

        public boolean validateMaxRetry(IFieldErrorHandler msgHandler, Context context, String fieldName, String value) {
            int retryCount = Integer.parseInt(value);
            if (retryCount < 1) {
                msgHandler.addFieldError(context, fieldName, "\u4e0d\u80fd\u5c0f\u4e8e1", new Object[0]);
                return false;
            }
            if (retryCount > 3) {
                msgHandler.addFieldError(context, fieldName, "\u4e0d\u80fd\u5927\u4e8e3", new Object[0]);
                return false;
            }
            return true;
        }

        @Override
        public IEndTypeGetter.EndType getEndType() {
            return IEndTypeGetter.EndType.QWen;
        }
    }
}

