/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.license;

import com.alibaba.citrus.turbine.Context;
import com.qlangtech.tis.config.ParamsConfig;
import com.qlangtech.tis.datax.TimeFormat;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.extension.TISExtension;
import com.qlangtech.tis.extension.impl.IOUtils;
import com.qlangtech.tis.lang.ErrorValue;
import com.qlangtech.tis.lang.TisException;
import com.qlangtech.tis.manage.common.TisUTF8;
import com.qlangtech.tis.plugin.IEndTypeGetter;
import com.qlangtech.tis.plugin.IPluginStore;
import com.qlangtech.tis.plugin.IdentityDesc;
import com.qlangtech.tis.plugin.annotation.FormField;
import com.qlangtech.tis.plugin.annotation.FormFieldType;
import com.qlangtech.tis.plugin.annotation.Validator;
import com.qlangtech.tis.runtime.module.misc.IControlMsgHandler;
import com.qlangtech.tis.trigger.util.JsonUtil;
import com.qlangtech.tis.util.IPluginContext;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.time.LocalDate;
import java.util.Base64;
import java.util.HashMap;
import java.util.Optional;
import javax.crypto.Cipher;
import org.apache.commons.lang3.tuple.Pair;

public class TISLicense
extends ParamsConfig
implements IPluginStore.BeforePluginSaved,
IPluginStore.AfterPluginSaved,
IdentityDesc<HasExpire> {
    public static final String key_tis_license = "tis_license";
    private transient Pair<PublicKey, String> publicKey;
    private transient HasExpire hasExpire;
    public static final String KEY_EXPIRE_DATE = "expireDatetime";
    public static final String KEY_EMAIL = "email";
    public static final String KEY_MOBILE = "mobile";
    public static final String KEY_IDENTITY = "licenseId";
    public static final String KEY_TIS_IDENTITY = "tis-license-id";
    public static final String KEY_FIELD_ACTIVATION_CODE = "activationCode";
    public static final String KEY_DISPLAY_NAME = "License";
    @FormField(identity=true, type=FormFieldType.INPUTTEXT, ordinal=0, validate={})
    public String expireDate;
    @FormField(type=FormFieldType.TEXTAREA, ordinal=4, validate={Validator.require})
    public String activationCode;
    @FormField(type=FormFieldType.INPUTTEXT, advance=true, ordinal=1, validate={})
    public String licenseId;
    @FormField(type=FormFieldType.INPUTTEXT, advance=true, ordinal=2, validate={})
    public String email;
    @FormField(type=FormFieldType.INPUTTEXT, advance=true, ordinal=3, validate={})
    public String mobile;

    public static TISLicense load() {
        return TISLicense.load(true);
    }

    public static TISLicense load(boolean validateNull) {
        return (TISLicense)ParamsConfig.getItem(key_tis_license, KEY_DISPLAY_NAME, Optional.empty(), validateNull);
    }

    @Override
    public void beforeSaved(IPluginContext pluginContext, Optional<Context> context) {
        HasExpire hasExpire = null;
        try {
            hasExpire = this.hasExpire();
            this.expireDate = hasExpire.expireDate;
            this.email = hasExpire.getEmail();
            this.mobile = hasExpire.getMobile();
            this.licenseId = hasExpire.getLicenseId();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (hasExpire != null && !hasExpire.hasNotExpire) {
            throw TisException.create((ErrorValue)ErrorValue.create((TisException.ErrorCode)TisException.ErrorCode.LICENSE_INVALID, new HashMap()), (String)("License period of validity till:" + hasExpire.expireDate));
        }
    }

    @Override
    public void afterSaved(IPluginContext pluginContext, Optional<Context> context) {
        this.publicKey = null;
        this.hasExpire = null;
    }

    public final Pair<PublicKey, String> loadPublicKey() {
        try {
            if (this.publicKey == null) {
                String publicKey = IOUtils.loadResourceFromClasspath(TISLicense.class, (String)"public.key");
                byte[] decodedPublicKey = Base64.getDecoder().decode(publicKey);
                X509EncodedKeySpec keySpec = new X509EncodedKeySpec(decodedPublicKey);
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                this.publicKey = Pair.of((Object)keyFactory.generatePublic(keySpec), (Object)publicKey);
            }
            return this.publicKey;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public HasExpire describePlugin() {
        try {
            return this.hasExpire();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public HasExpire hasExpire() throws Exception {
        if (this.hasExpire == null) {
            byte[] content = TISLicense.decryptData(Base64.getDecoder().decode(this.activationCode), (PublicKey)this.loadPublicKey().getKey());
            HashMap deserialize = JsonUtil.deserialize((String)new String(content, TisUTF8.get()), new HashMap());
            long epochMilli = Long.parseLong((String)deserialize.get(KEY_EXPIRE_DATE));
            TimeFormat format = TimeFormat.yyyy_MM_dd;
            this.hasExpire = new HasExpire(LocalDate.now().isBefore(format.ofInstant(epochMilli).toLocalDate()), format.format(epochMilli));
            this.hasExpire.setEmail((String)deserialize.get(KEY_EMAIL));
            this.hasExpire.setMobile((String)deserialize.get(KEY_MOBILE));
            this.hasExpire.setLicenseId((String)deserialize.get(KEY_IDENTITY));
        }
        return this.hasExpire;
    }

    private static byte[] decryptData(byte[] encryptedData, PublicKey publicKey) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, publicKey);
        return cipher.doFinal(encryptedData);
    }

    public TISLicense createConfigInstance() {
        return this;
    }

    public String identityValue() {
        return key_tis_license;
    }

    @TISExtension
    public static final class DftDescriptor
    extends ParamsConfig.BasicParamsConfigDescriptor
    implements IEndTypeGetter {
        public DftDescriptor() {
            super(TISLicense.KEY_DISPLAY_NAME);
        }

        @Override
        public IEndTypeGetter.EndType getEndType() {
            return IEndTypeGetter.EndType.License;
        }

        @Override
        public String getDisplayName() {
            return this.paramsConfigType();
        }

        @Override
        public String helpPath() {
            return "community-collaboration";
        }

        @Override
        protected boolean validateAll(IControlMsgHandler msgHandler, Context context, Descriptor.PostFormVals postFormVals) {
            TISLicense license = (TISLicense)postFormVals.newInstance();
            try {
                HasExpire hasExpire = license.hasExpire();
                if (!hasExpire.hasNotExpire) {
                    msgHandler.addFieldError(context, TISLicense.KEY_FIELD_ACTIVATION_CODE, "\u8bc1\u4e66\u5df2\u5931\u6548\uff0c\u6709\u6548\u671f\u5230\uff1a" + hasExpire.expireDate, new Object[0]);
                    return false;
                }
                msgHandler.addActionMessage(context, "\u8bc1\u4e66\u6709\u6548\uff0c\u6709\u6548\u671f\u5230\uff1a" + hasExpire.expireDate);
            }
            catch (Exception e) {
                throw TisException.create((String)("\u8bf7\u68c0\u67e5\u662f\u5426\u662f\u5408\u6cd5\u8bc1\u4e66\uff0c" + e.getMessage()), (Throwable)e);
            }
            return true;
        }

        @Override
        protected boolean verify(IControlMsgHandler msgHandler, Context context, Descriptor.PostFormVals postFormVals) {
            return this.validateAll(msgHandler, context, postFormVals);
        }
    }

    public static class HasExpire {
        public final boolean hasNotExpire;
        public final String expireDate;
        private String licenseId;
        private String mobile;
        private String email;

        public HasExpire(boolean hasNotExpire, String expireDate) {
            this.hasNotExpire = hasNotExpire;
            this.expireDate = expireDate;
        }

        public void setLicenseId(String licenseId) {
            this.licenseId = licenseId;
        }

        public String getMobile() {
            return this.mobile;
        }

        public void setMobile(String mobile) {
            this.mobile = mobile;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public boolean isHasNotExpire() {
            return this.hasNotExpire;
        }

        public String getExpireDate() {
            return this.expireDate;
        }

        public String getLicenseId() {
            return this.licenseId;
        }
    }
}

