/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.k8s;

import com.qlangtech.tis.TIS;
import com.qlangtech.tis.annotation.Public;
import com.qlangtech.tis.config.ParamsConfig;
import com.qlangtech.tis.config.k8s.IK8sContext;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.plugin.IPluginStore;
import com.qlangtech.tis.plugin.IdentityName;
import com.qlangtech.tis.plugin.k8s.HostAlias;
import com.qlangtech.tis.util.HeteroEnum;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.lang.StringUtils;

@Public
public abstract class K8sImage
implements Describable<K8sImage>,
IdentityName {
    protected abstract String getK8SName();

    public abstract String getNamespace();

    public abstract String getImagePath();

    public abstract List<HostAlias> getHostAliases();

    public abstract boolean internalClusterAvailable();

    public <T> T createApiClient() {
        ParamsConfig cfg = (ParamsConfig)((Object)this.getK8SCfg());
        return (T)cfg.createConfigInstance();
    }

    public IK8sContext getK8SCfg() {
        return (IK8sContext)ParamsConfig.getItem(this.getK8SName(), "k8s");
    }

    @Override
    public final Descriptor<K8sImage> getDescriptor() {
        Descriptor desc = TIS.get().getDescriptor(this.getClass());
        if (!(desc instanceof BasicDesc)) {
            throw new IllegalStateException("desc:" + desc.getClass().getName() + " must be subtype type of " + BasicDesc.class.getName());
        }
        return desc;
    }

    protected static abstract class BasicDesc
    extends Descriptor<K8sImage> {
        @Override
        public final String getDisplayName() {
            return this.getImageCategory().token;
        }

        protected abstract ImageCategory getImageCategory();
    }

    public static enum ImageCategory {
        DEFAULT_DESC_NAME("dft-image", () -> HeteroEnum.K8S_DEFAULT_IMAGES.getPluginStore(null, null)),
        DEFAULT_POWERJOB_DESC_NAME("powerjob-image", () -> HeteroEnum.K8S_POWERJOB_IMAGES.getPluginStore(null, null)),
        DEFAULT_FLINK_DESC_NAME("flink-image", () -> HeteroEnum.K8S_FLINK_IMAGES.getPluginStore(null, null));

        public final String token;
        private final Supplier<IPluginStore<K8sImage>> pluginStoreGetter;

        private ImageCategory(String token, Supplier<IPluginStore<K8sImage>> pluginStoreGetter) {
            this.token = token;
            this.pluginStoreGetter = pluginStoreGetter;
        }

        public IPluginStore<K8sImage> getPluginStore() {
            return this.pluginStoreGetter.get();
        }

        public static ImageCategory parse(String token) {
            for (ImageCategory c : ImageCategory.values()) {
                if (!StringUtils.equals((String)c.token, (String)token)) continue;
                return c;
            }
            throw new IllegalStateException("illegal token:" + token);
        }
    }
}

