/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.incr;

import com.qlangtech.tis.TIS;
import com.qlangtech.tis.annotation.Public;
import com.qlangtech.tis.async.message.client.consumer.IFlinkColCreator;
import com.qlangtech.tis.compiler.incr.ICompileAndPackage;
import com.qlangtech.tis.datax.DataXName;
import com.qlangtech.tis.datax.IDataXNameAware;
import com.qlangtech.tis.datax.IDataxProcessor;
import com.qlangtech.tis.datax.TableAlias;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.extension.TISExtension;
import com.qlangtech.tis.manage.common.TisUTF8;
import com.qlangtech.tis.plugin.IEndTypeGetter;
import com.qlangtech.tis.plugin.KeyedPluginStore;
import com.qlangtech.tis.plugin.datax.SelectedTabExtend;
import com.qlangtech.tis.plugin.incr.ISelectedTabExtendFactory;
import com.qlangtech.tis.util.HeteroEnum;
import com.qlangtech.tis.util.IPluginContext;
import com.qlangtech.tis.util.PartialSettedPluginContext;
import com.qlangtech.tis.util.Selectable;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Public
public abstract class TISSinkFactory
implements Describable<TISSinkFactory>,
KeyedPluginStore.IPluginKeyAware,
IDataXNameAware {
    public static final String KEY_PLUGIN_TPI_CHILD_PATH = "flink/";
    private static final Logger logger = LoggerFactory.getLogger(TISSinkFactory.class);
    @TISExtension
    public static final HeteroEnum<TISSinkFactory> sinkFactory = new HeteroEnum<TISSinkFactory>(TISSinkFactory.class, "sinkFactory", "Incr Sink Factory", Selectable.Single, true);
    public static Function<IPluginContext, TISSinkFactory> stubGetter;
    public transient String dataXName;

    public static Optional<Descriptor<SelectedTabExtend>> getIncrSinkSelectedTabExtendDescriptor(String dataXName) {
        PartialSettedPluginContext pluginContext = IPluginContext.namedContext(dataXName);
        List<TISSinkFactory> sinkFactories = sinkFactory.getPlugins(pluginContext, null);
        TISSinkFactory sinkFactory = null;
        Iterator<TISSinkFactory> iterator = sinkFactories.iterator();
        if (iterator.hasNext()) {
            TISSinkFactory factory;
            sinkFactory = factory = iterator.next();
        }
        Objects.requireNonNull(sinkFactory, "sinkFactory can not be null, dataXName:" + dataXName + " sinkFactories size:" + sinkFactories.size());
        Descriptor<TISSinkFactory> descriptor = sinkFactory.getDescriptor();
        if (!(descriptor instanceof ISelectedTabExtendFactory)) {
            return Optional.empty();
        }
        Descriptor<SelectedTabExtend> selectedTableExtendDesc = ((ISelectedTabExtendFactory)((Object)descriptor)).getSelectedTableExtendDescriptor();
        return Optional.ofNullable(selectedTableExtendDesc);
    }

    public static void main(String[] args) throws Exception {
        URL url = new URL("jar:file:/opt/data/tis/libs/plugins/flink/hudi/WEB-INF/lib/../../WEB-INF/lib/hudi-incr.jar!/META-INF/annotations/com.qlangtech.tis.extension.TISExtension");
        System.out.println(IOUtils.toString((URL)url, (Charset)TisUTF8.get()));
    }

    public static TISSinkFactory getIncrSinKFactory(DataXName dataXName) {
        PartialSettedPluginContext pluginContext = IPluginContext.namedContext(dataXName);
        return TISSinkFactory.getIncrSinKFactory(pluginContext);
    }

    public static TISSinkFactory getIncrSinKFactory(IPluginContext pluginContext) {
        if (stubGetter != null) {
            return stubGetter.apply(pluginContext);
        }
        List<TISSinkFactory> sinkFactories = sinkFactory.getPlugins(pluginContext, null);
        TISSinkFactory sinkFactory = null;
        logger.info("sinkFactories size:" + sinkFactories.size());
        Iterator<TISSinkFactory> iterator = sinkFactories.iterator();
        if (iterator.hasNext()) {
            TISSinkFactory factory;
            sinkFactory = factory = iterator.next();
        }
        Objects.requireNonNull(sinkFactory, "sinkFactories.size():" + sinkFactories.size());
        return sinkFactory;
    }

    public boolean flinkCDCPipelineEnable() {
        return false;
    }

    public final DataXName getCollectionName() {
        if (StringUtils.isEmpty((String)this.dataXName)) {
            throw new IllegalStateException("param dataXName can not be empty");
        }
        return DataXName.createDataXPipeline((String)this.dataXName);
    }

    public abstract ICompileAndPackage getCompileAndPackageManager();

    @Override
    public void setKey(KeyedPluginStore.Key key) {
        this.dataXName = key.keyVal.getVal();
    }

    public abstract <SinkFunc> Map<TableAlias, SinkFunc> createSinkFunction(IDataxProcessor var1, IFlinkColCreator<?> var2);

    @Override
    public final Descriptor<TISSinkFactory> getDescriptor() {
        Descriptor descriptor = TIS.get().getDescriptor(this.getClass());
        Class expectClazz = this.getExpectDescClass();
        if (!expectClazz.isAssignableFrom(descriptor.getClass())) {
            throw new IllegalStateException(descriptor.getClass() + " must implement the Descriptor of " + expectClazz.getName());
        }
        return descriptor;
    }

    protected <TT extends BaseSinkFunctionDescriptor> Class<TT> getExpectDescClass() {
        return BaseSinkFunctionDescriptor.class;
    }

    public static abstract class BaseSinkFunctionDescriptor
    extends Descriptor<TISSinkFactory>
    implements IEndTypeGetter {
        @Override
        public Map<String, Object> getExtractProps() {
            Map<String, Object> vals = super.getExtractProps();
            IEndTypeGetter.EndType targetType = this.getTargetType();
            vals.put("targetType", targetType.getVal());
            vals.put("extendSelectedTabProp", this instanceof ISelectedTabExtendFactory && ((ISelectedTabExtendFactory)((Object)this)).getSelectedTableExtendDescriptor() != null);
            return vals;
        }

        @Override
        public final IEndTypeGetter.EndType getEndType() {
            return Objects.requireNonNull(this.getTargetType(), "targetType can not be null");
        }

        protected abstract IEndTypeGetter.EndType getTargetType();
    }
}

