/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.incr;

import com.qlangtech.tis.TIS;
import com.qlangtech.tis.annotation.Public;
import com.qlangtech.tis.coredefine.module.action.IFlinkIncrJobStatus;
import com.qlangtech.tis.coredefine.module.action.IRCController;
import com.qlangtech.tis.coredefine.module.action.TargetResName;
import com.qlangtech.tis.datax.job.ServerLaunchToken;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.order.center.IParamContext;
import com.qlangtech.tis.plugin.IPluginStore;
import com.qlangtech.tis.plugin.incr.IConsumerRateLimiter;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;

@Public
public abstract class IncrStreamFactory
implements Describable<IncrStreamFactory>,
IRCController,
IConsumerRateLimiter {
    public static Function<String, IncrStreamFactory> stubStreamFactory;

    public static IncrStreamFactory getFactory(String indexName) {
        if (StringUtils.isEmpty((String)indexName)) {
            throw new IllegalArgumentException("indexName:" + indexName + " can not be empty");
        }
        if (stubStreamFactory != null) {
            return stubStreamFactory.apply(indexName);
        }
        IPluginStore<IncrStreamFactory> store = TIS.getPluginStore(indexName, IncrStreamFactory.class);
        IncrStreamFactory k8sConfig = store.getPlugin();
        if (k8sConfig == null) {
            throw new IllegalStateException("key:" + indexName + " have not set k8s plugin");
        }
        return k8sConfig;
    }

    public abstract Integer getParallelism();

    public abstract ServerLaunchToken getLaunchToken(TargetResName var1);

    public boolean hasCreated(TargetResName collection) {
        return this.getLaunchToken(collection).isLaunchTokenExist();
    }

    public abstract ServerLaunchToken.FlinkClusterType getClusterType();

    public abstract Optional<ISavePointSupport> restorable();

    public abstract IFlinkIncrJobStatus getIncrJobStatus(TargetResName var1);

    public abstract <StreamExecutionEnvironment> StreamExecutionEnvironment createStreamExecutionEnvironment();

    @Override
    public final Descriptor<IncrStreamFactory> getDescriptor() {
        return TIS.get().getDescriptor(this.getClass());
    }

    public static interface ISavePointSupport {
        public boolean supportSavePoint();

        public String getSavePointRootPath();

        default public String createSavePointPath() {
            return this.getSavePointRootPath() + "/savepoint_" + IParamContext.getCurrentMillisecTimeStamp();
        }
    }
}

