/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.ds;

import com.google.common.collect.Lists;
import com.qlangtech.tis.datax.DataXJobInfo;
import com.qlangtech.tis.datax.DataXJobSubmit;
import com.qlangtech.tis.plugin.ds.DBIdentity;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public abstract class TableInDB {
    protected final DBIdentity dbSourceId;

    public TableInDB(DBIdentity dbSourceId) {
        this.dbSourceId = Objects.requireNonNull(dbSourceId, "param id can not be null");
    }

    public final boolean isMatch(DBIdentity queryDBSourceId) {
        return this.dbSourceId.isEquals(queryDBSourceId);
    }

    public static TableInDB create(DBIdentity id) {
        return new DftTableInDB(id);
    }

    public abstract void add(String var1, String var2);

    public abstract Function<String, String> getPhysicsTabName2LogicNameConvertor();

    public abstract List<String> getTabs();

    public abstract boolean contains(String var1);

    public abstract boolean isEmpty();

    public abstract DataXJobInfo createDataXJobInfo(DataXJobSubmit.TableDataXEntity var1, boolean var2);

    private static class DftTableInDB
    extends TableInDB {
        private List<String> tabs = Lists.newArrayList();

        public DftTableInDB(DBIdentity id) {
            super(id);
        }

        @Override
        public void add(String jdbcUrl, String tab) {
            this.tabs.add(tab);
        }

        @Override
        public DataXJobInfo createDataXJobInfo(DataXJobSubmit.TableDataXEntity tabEntity, boolean shallRewrite2RegexPattern) {
            return DataXJobInfo.create((String)tabEntity.getFileName(), (DBIdentity)tabEntity, this.tabs.contains(tabEntity.getSourceTableName()) ? Collections.singletonList(tabEntity.getSourceTableName()) : Collections.emptyList());
        }

        @Override
        public Function<String, String> getPhysicsTabName2LogicNameConvertor() {
            return new DefaultTableNameConvert();
        }

        @Override
        public List<String> getTabs() {
            return this.tabs;
        }

        @Override
        public boolean contains(String tableName) {
            return this.tabs.contains(tableName);
        }

        @Override
        public boolean isEmpty() {
            return this.tabs.isEmpty();
        }
    }

    public static class DefaultTableNameConvert
    implements Function<String, String>,
    Serializable {
        @Override
        public String apply(String physicsTabName) {
            return physicsTabName;
        }
    }
}

