/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.ds;

import com.google.common.collect.Lists;
import com.qlangtech.tis.plugin.ds.ColumnMetaData;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class TISTable {
    private String tableName;
    private int partitionNum;
    private Integer dbId;
    private Integer tabId;
    private String dbName;
    private int partitionInterval;
    private String selectSql;
    private List<ColumnMetaData> reflectCols = Lists.newArrayList();

    public TISTable() {
    }

    public void addColumnMeta(ColumnMetaData colMeta) {
        this.reflectCols.add(colMeta);
    }

    public List<ColumnMetaData> getReflectCols() {
        return this.reflectCols;
    }

    public void setReflectCols(List<ColumnMetaData> reflectCols) {
        this.reflectCols = reflectCols;
    }

    public TISTable(String tableName, int partitionNum, Integer dbId, int partitionInterval, String selectSql) {
        this.tableName = tableName;
        this.partitionNum = partitionNum;
        this.dbId = dbId;
        this.partitionInterval = partitionInterval;
        this.selectSql = selectSql;
    }

    public Integer getTabId() {
        return this.tabId;
    }

    public void setTabId(Integer tabId) {
        this.tabId = tabId;
    }

    public String getDbName() {
        if (StringUtils.isEmpty((String)this.dbName)) {
            throw new IllegalStateException("param db name can not be null");
        }
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public int getPartitionNum() {
        return this.partitionNum;
    }

    public void setPartitionNum(int partitionNum) {
        this.partitionNum = partitionNum;
    }

    public Integer getDbId() {
        return this.dbId;
    }

    public void setDbId(Integer dbId) {
        this.dbId = dbId;
    }

    public int getPartitionInterval() {
        return this.partitionInterval;
    }

    public void setPartitionInterval(int partitionInterval) {
        this.partitionInterval = partitionInterval;
    }

    public String getSelectSql() {
        return this.selectSql;
    }

    public void setSelectSql(String selectSql) {
        this.selectSql = selectSql;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TISTable tisTable = (TISTable)o;
        return Objects.equals(this.tableName, tisTable.tableName) && Objects.equals(this.tabId, tisTable.tabId) && Objects.equals(this.dbName, tisTable.dbName);
    }

    public int hashCode() {
        return Objects.hash(this.tableName, this.tabId, this.dbName);
    }

    public String toString() {
        return "TISTable{tableName='" + this.tableName + "', tabId=" + this.tabId + ", dbName='" + this.dbName + "'}";
    }
}

