/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.ds;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.qlangtech.tis.datax.DataXJobInfo;
import com.qlangtech.tis.datax.DataXJobSubmit;
import com.qlangtech.tis.plugin.ds.DBIdentity;
import com.qlangtech.tis.plugin.ds.SplitTableStrategy;
import com.qlangtech.tis.plugin.ds.TableInDB;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitableTableInDB
extends TableInDB {
    private static final Logger logger = LoggerFactory.getLogger(SplitableTableInDB.class);
    public static final Pattern firstLogicTabNamePattern = Pattern.compile("\\(\\S+?\\)");
    public Map<String, SplitableDB> tabs = new HashMap<String, SplitableDB>();
    private final Pattern splitTabPattern;
    private final boolean prefixWildcardStyle;

    public SplitableTableInDB(DBIdentity id, Pattern splitTabPattern, boolean prefixWildcardStyle) {
        super(id);
        this.splitTabPattern = Objects.requireNonNull(splitTabPattern, "splitTabPattern can not be null");
        this.prefixWildcardStyle = prefixWildcardStyle;
    }

    @Override
    public Function<String, String> getPhysicsTabName2LogicNameConvertor() {
        return new SplitTableStrategy.SplitTablePhysics2LogicNameConverter(this);
    }

    @Override
    public void add(String jdbcUrl, String tab) {
        Matcher matcher = this.splitTabPattern.matcher(tab);
        if (matcher.matches()) {
            String logicTabName = matcher.group(1);
            this.addPhysicsTab(jdbcUrl, logicTabName, tab);
        } else {
            this.addPhysicsTab(jdbcUrl, tab, tab);
        }
    }

    private void addPhysicsTab(String jdbcUrl, String logicTabName, String tab) {
        SplitableDB physicsTabs = this.tabs.get(logicTabName);
        if (physicsTabs == null) {
            physicsTabs = new SplitableDB(logicTabName, this);
            this.tabs.put(logicTabName, physicsTabs);
        }
        physicsTabs.add(jdbcUrl, tab);
    }

    @Override
    public DataXJobInfo createDataXJobInfo(DataXJobSubmit.TableDataXEntity tabEntity, boolean shallRewrite2RegexPattern) {
        SplitableDB splitableDB = this.tabs.get(tabEntity.getSourceTableName());
        Objects.requireNonNull(splitableDB, "SourceTableName:" + tabEntity.getSourceTableName() + " relevant splitableDB can not be null,exist tabs:" + String.join((CharSequence)",", this.tabs.keySet()));
        List<String> matchedTabs = splitableDB.getTabsInDB(tabEntity.getDbIdenetity(), shallRewrite2RegexPattern);
        if (CollectionUtils.isEmpty(matchedTabs)) {
            throw new IllegalStateException("jdbcUrl:" + tabEntity.getDbIdenetity() + " relevant matchedTabs can not be empty");
        }
        return DataXJobInfo.create((String)tabEntity.getFileName(), (DBIdentity)tabEntity, matchedTabs);
    }

    @Override
    public List<String> getTabs() {
        return Lists.newArrayList(this.tabs.keySet());
    }

    @Override
    public boolean contains(String tableName) {
        return this.tabs.containsKey(tableName);
    }

    @Override
    public boolean isEmpty() {
        return this.tabs.isEmpty();
    }

    public Pair<Boolean, List<String>> rewritePhysicsTabs(String logicTabName, List<String> physicsTabs) {
        if (this.prefixWildcardStyle) {
            Matcher matcher = firstLogicTabNamePattern.matcher(this.splitTabPattern.pattern());
            if (matcher.find()) {
                String newPatternForMatchFlinkBinlog = matcher.replaceFirst(logicTabName);
                logger.info("logicTabName:{},newPatternForMatchFlinkBinlog:{} with splitTabPattern:{}", new Object[]{logicTabName, newPatternForMatchFlinkBinlog, this.splitTabPattern.pattern()});
                return Pair.of((Object)true, Collections.singletonList(newPatternForMatchFlinkBinlog));
            }
            throw new IllegalStateException("firstLogicTabNamePattern:" + firstLogicTabNamePattern + " can not find matched part in pattern:" + this.splitTabPattern.pattern());
        }
        return Pair.of((Object)false, physicsTabs);
    }

    public static class SplitableDB {
        private final String logicTabName;
        private final SplitableTableInDB splitableTableInDB;
        public Map<String, List<String>> physicsTabInSplitableDB = Maps.newHashMap();

        public SplitableDB(String logicTabName, SplitableTableInDB splitableTableInDB) {
            this.logicTabName = Objects.requireNonNull(logicTabName, "logicTabName can not be null");
            this.splitableTableInDB = Objects.requireNonNull(splitableTableInDB, "splitableTableInDB can not be null");
        }

        public String getLogicTabName() {
            return this.logicTabName;
        }

        public SplitableDB add(String jdbcUrl, String tab) {
            ArrayList tabs = this.physicsTabInSplitableDB.get(jdbcUrl);
            if (tabs == null) {
                tabs = Lists.newArrayList();
                this.physicsTabInSplitableDB.put(jdbcUrl, tabs);
            }
            tabs.add(tab);
            return this;
        }

        public List<String> getTabsInDB(String jdbcUrl, boolean shallRewrite2RegexPattern) {
            if (shallRewrite2RegexPattern) {
                return (List)this.splitableTableInDB.rewritePhysicsTabs(this.logicTabName, this.physicsTabInSplitableDB.get(jdbcUrl)).getRight();
            }
            return this.physicsTabInSplitableDB.get(jdbcUrl);
        }

        public Pair<Boolean, Set<String>> rewrite2RegexPattern() {
            HashSet rewriteRegexMatchPatterns = Sets.newHashSet();
            for (List<String> physicsTabs : this.physicsTabInSplitableDB.values()) {
                Pair<Boolean, List<String>> oneNodeOf = this.splitableTableInDB.rewritePhysicsTabs(this.logicTabName, physicsTabs);
                if (!((Boolean)oneNodeOf.getKey()).booleanValue()) {
                    return Pair.of((Object)false, Collections.emptySet());
                }
                rewriteRegexMatchPatterns.addAll((Collection)oneNodeOf.getValue());
            }
            return Pair.of((Object)true, (Object)rewriteRegexMatchPatterns);
        }
    }
}

