/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.ds;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.qlangtech.tis.datax.DataXJobSubmit;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.extension.TISExtensible;
import com.qlangtech.tis.plugin.ds.DBIdentity;
import com.qlangtech.tis.plugin.ds.DataSourceFactory;
import com.qlangtech.tis.plugin.ds.SplitableTableInDB;
import com.qlangtech.tis.plugin.ds.TableInDB;
import com.qlangtech.tis.sql.parser.tuple.creator.EntityName;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TISExtensible
public abstract class SplitTableStrategy
implements Describable<SplitTableStrategy>,
Serializable {
    public static final Pattern PATTERN_PHYSICS_TABLE = Pattern.compile("(\\S+?)(_\\d+)?");

    public abstract String getNodeDesc();

    public abstract boolean isSplittable();

    public abstract TableInDB createTableInDB(DBIdentity var1);

    public abstract DBPhysicsTable getMatchedPhysicsTable(DataSourceFactory var1, String var2, EntityName var3);

    public final List<String> getAllPhysicsTabs(DataSourceFactory dsFactory, DataXJobSubmit.TableDataXEntity tabEntity) {
        return this.getAllPhysicsTabs(dsFactory, tabEntity.getDbIdenetity(), tabEntity.getSourceTableName());
    }

    public abstract List<String> getAllPhysicsTabs(DataSourceFactory var1, String var2, String var3);

    public static class SplitTablePhysics2LogicNameConverter
    implements Function<String, String>,
    Serializable {
        private static final Logger logger = LoggerFactory.getLogger(SplitTablePhysics2LogicNameConverter.class);
        private final ConcurrentMap<String, String> physics2LogicTabNameConverter = Maps.newConcurrentMap();
        private final Set<UnrecognizedPhysicsTabs2LogicName> unrecognizedPhysicsTabs2LogicName = Sets.newHashSet();

        public SplitTablePhysics2LogicNameConverter(SplitableTableInDB splitTabInDB) {
            Pair<Boolean, Set<String>> regexPattern = null;
            for (Map.Entry<String, SplitableTableInDB.SplitableDB> dbEntry : splitTabInDB.tabs.entrySet()) {
                regexPattern = dbEntry.getValue().rewrite2RegexPattern();
                if (((Boolean)regexPattern.getKey()).booleanValue()) {
                    this.unrecognizedPhysicsTabs2LogicName.add(UnrecognizedPhysicsTabs2LogicName.create(dbEntry.getKey(), (Set)regexPattern.getRight()));
                }
                for (Map.Entry<String, List<String>> logicEntry : dbEntry.getValue().physicsTabInSplitableDB.entrySet()) {
                    for (String physicsTabName : logicEntry.getValue()) {
                        this.physics2LogicTabNameConverter.put(physicsTabName, dbEntry.getKey());
                    }
                }
            }
        }

        @Override
        public String apply(String physicsName) {
            String logicalTabName = (String)this.physics2LogicTabNameConverter.get(physicsName);
            if (logicalTabName == null) {
                for (UnrecognizedPhysicsTabs2LogicName recognize : this.unrecognizedPhysicsTabs2LogicName) {
                    if (!recognize.test(physicsName)) continue;
                    logger.info("physicsName:" + physicsName + " has been regonized by unrecognized PhysicsTabs2LogicName to logicName:" + recognize.logicTabName);
                    this.physics2LogicTabNameConverter.putIfAbsent(physicsName, recognize.logicTabName);
                    return recognize.logicTabName;
                }
                throw new IllegalStateException("physics tabName:" + physicsName + " can not find relevant logicalTabName,repo size:" + this.physics2LogicTabNameConverter.size() + ",unrecognizedPhysicsTabs2LogicName size:" + this.unrecognizedPhysicsTabs2LogicName.size());
            }
            return logicalTabName;
        }
    }

    public static class UnrecognizedPhysicsTabs2LogicName
    implements Serializable {
        private final String logicTabName;
        private final Pattern[] testPattern;

        private static UnrecognizedPhysicsTabs2LogicName create(String logicTabName, Set<String> regexPattern) {
            return new UnrecognizedPhysicsTabs2LogicName(logicTabName, (Pattern[])regexPattern.stream().map(regex -> Pattern.compile(regex)).toArray(Pattern[]::new));
        }

        public UnrecognizedPhysicsTabs2LogicName(String logicTabName, Pattern[] testPattern) {
            this.logicTabName = logicTabName;
            this.testPattern = Objects.requireNonNull(testPattern, "testPattern can not be null");
            if (testPattern.length < 1) {
                throw new IllegalArgumentException("testPattern array length can not small than 1");
            }
        }

        public boolean test(String physicsTabName) {
            for (Pattern p : this.testPattern) {
                if (!p.matcher(physicsTabName).matches()) continue;
                return true;
            }
            return false;
        }
    }

    public static class DBPhysicsTable {
        private final String jdbcUrl;
        private final EntityName physicsTab;

        public DBPhysicsTable(String jdbcUrl, EntityName physicsTab) {
            this.jdbcUrl = jdbcUrl;
            this.physicsTab = physicsTab;
        }

        public String getJdbcUrl() {
            return this.jdbcUrl;
        }

        public EntityName getPhysicsTab() {
            return this.physicsTab;
        }
    }
}

