/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.ds;

import com.google.common.collect.Maps;
import com.qlangtech.tis.plugin.ds.DataSourceMeta;
import com.qlangtech.tis.plugin.ds.JDBCConnection;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JDBCConnectionPool
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(DefaultJDBCConnectionPool.class);

    public static <CONN extends JDBCConnection> CONN getJDBCConnectionFromPool(JDBCConnection conn) {
        if (conn instanceof DelegatePoolJDBCConnection) {
            return (CONN)((DelegatePoolJDBCConnection)conn).conn;
        }
        return (CONN)conn;
    }

    public abstract JDBCConnection getConnection(String var1, boolean var2);

    public abstract JDBCConnection getConnection(String var1, boolean var2, Function<String, JDBCConnection> var3);

    public static JDBCConnectionPool create() {
        return new DefaultJDBCConnectionPool();
    }

    private static final class DelegatePoolJDBCConnection
    extends JDBCConnection {
        private final JDBCConnection conn;

        public DelegatePoolJDBCConnection(JDBCConnection conn, String url) {
            super(null, url);
            this.conn = conn;
        }

        @Override
        public final String getSchema() {
            return this.conn.getSchema();
        }

        @Override
        public String getCatalog() {
            return this.conn.getCatalog();
        }

        @Override
        public Statement createStatement() throws SQLException {
            return this.conn.createStatement();
        }

        @Override
        public PreparedStatement preparedStatement(String sql) throws SQLException {
            return this.conn.preparedStatement(sql);
        }

        @Override
        public Connection getConnection() {
            return this.conn.getConnection();
        }

        @Override
        public boolean query(String sql, DataSourceMeta.ResultProcess resultProcess) throws Exception {
            return this.conn.query(sql, resultProcess);
        }

        @Override
        public boolean execute(String sql) throws Exception {
            return this.conn.execute(sql);
        }

        @Override
        public void close() throws SQLException {
        }
    }

    private static class DefaultJDBCConnectionPool
    extends JDBCConnectionPool {
        private final ConcurrentMap<String, DelegatePoolJDBCConnection> connectionCache = Maps.newConcurrentMap();

        @Override
        public JDBCConnection getConnection(String jdbcUrl, boolean verify, Function<String, JDBCConnection> mappingFunction) {
            return this.connectionCache.computeIfAbsent(DefaultJDBCConnectionPool.createCacheKey(jdbcUrl, verify), mappingFunction.andThen(conn -> new DelegatePoolJDBCConnection((JDBCConnection)conn, conn.getUrl())));
        }

        private static String createCacheKey(String jdbcUrl, boolean verify) {
            return jdbcUrl + "_verify_" + verify;
        }

        @Override
        public JDBCConnection getConnection(String jdbcUrl, boolean verify) {
            return (JDBCConnection)this.connectionCache.get(DefaultJDBCConnectionPool.createCacheKey(jdbcUrl, verify));
        }

        @Override
        public void close() throws Exception {
            for (Map.Entry entry : this.connectionCache.entrySet()) {
                try {
                    ((DelegatePoolJDBCConnection)entry.getValue()).conn.close();
                }
                catch (SQLException e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

