/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.ds;

import com.qlangtech.tis.plugin.ds.DataSourceMeta;
import com.qlangtech.tis.plugin.ds.JDBCConnectionPool;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class JDBCConnection
implements AutoCloseable {
    public static ThreadLocal<JDBCConnectionPool> connectionPool = new ThreadLocal();
    private final Connection conn;
    private final String url;
    private final ConcurrentHashMap<String, String> initializedTabs = new ConcurrentHashMap();

    public final boolean initializeSinkTab(String tabName, Runnable initProcessor) {
        boolean[] initialized = new boolean[1];
        this.initializedTabs.computeIfAbsent(tabName, t -> {
            initProcessor.run();
            initialized[0] = true;
            return t;
        });
        return initialized[0];
    }

    public JDBCConnection(Connection conn, String url) {
        this.conn = conn;
        this.url = url;
    }

    public String getSchema() {
        try {
            return this.conn.getSchema();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public String getCatalog() {
        try {
            String catalog = this.conn.getCatalog();
            String result = StringUtils.defaultString((String)catalog, (String)this.getSchema());
            if (StringUtils.isEmpty((CharSequence)result)) {
                throw new IllegalStateException("connUrl:" + this.url + " relevant catalog can not be empty,catalog:" + catalog + ",schema:" + this.getSchema());
            }
            return result;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Statement createStatement() throws SQLException {
        return this.conn.createStatement();
    }

    public Connection getConnection() {
        return this.conn;
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public void close() throws SQLException {
        this.conn.close();
    }

    public PreparedStatement preparedStatement(String sql) throws SQLException {
        return this.conn.prepareStatement(sql);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean query(String sql, DataSourceMeta.ResultProcess resultProcess) throws Exception {
        Class<JDBCConnection> clazz = JDBCConnection.class;
        synchronized (JDBCConnection.class) {
            Statement stmt = this.conn.createStatement();
            try {
                boolean hasAnyRows;
                block19: {
                    boolean bl;
                    ResultSet result;
                    block18: {
                        hasAnyRows = false;
                        result = stmt.executeQuery(sql);
                        while (result.next()) {
                            hasAnyRows = true;
                            if (resultProcess.callback(result)) continue;
                            bl = hasAnyRows;
                            break block18;
                        }
                        break block19;
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return bl;
                    finally {
                        if (result != null) {
                            result.close();
                        }
                    }
                }
                boolean bl = hasAnyRows;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return bl;
            }
            catch (Exception e) {
                throw new RuntimeException(sql, e);
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
    }

    public boolean execute(String sql) throws Exception {
        Class<JDBCConnection> clazz = JDBCConnection.class;
        synchronized (JDBCConnection.class) {
            boolean bl;
            block9: {
                Statement stmt = this.conn.createStatement();
                try {
                    bl = stmt.execute(sql);
                    if (stmt == null) break block9;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return bl;
        }
    }
}

