/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.ds;

import com.alibaba.datax.common.util.Configuration;
import com.alibaba.datax.core.job.IJobContainerContext;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.datax.DataXName;
import com.qlangtech.tis.datax.IDataxProcessor;
import com.qlangtech.tis.datax.IDataxReader;
import com.qlangtech.tis.datax.StoreResourceType;
import com.qlangtech.tis.datax.impl.DataxProcessor;
import com.qlangtech.tis.datax.impl.DataxWriter;
import com.qlangtech.tis.plugin.ds.DBIdentity;
import com.qlangtech.tis.plugin.ds.DataSourceFactory;
import com.qlangtech.tis.plugin.ds.IDBReservedKeys;
import com.qlangtech.tis.plugin.ds.PostedDSProp;
import java.util.Objects;
import java.util.function.Function;

public interface IDataSourceFactoryGetter {
    public static IDataSourceFactoryGetter getWriterDataSourceFactoryGetter(Configuration originalConfig, IJobContainerContext containerContext) {
        return IDataSourceFactoryGetter.getDataSourceFactoryGetter(originalConfig, containerContext, res -> DataxWriter.load(null, res.getType(), res.getPipelineName(), true));
    }

    public static IDataSourceFactoryGetter getReaderDataSourceFactoryGetter(Configuration config, IJobContainerContext containerContext) {
        return IDataSourceFactoryGetter.getDataSourceFactoryGetter(config, containerContext, res -> {
            if (res.getType() != StoreResourceType.DataFlow) {
                IDataxProcessor processor = DataxProcessor.load(null, res.getType(), res.getPipelineName());
                IDataxReader reader = null;
                reader = processor.getReader(null);
                if (reader instanceof IDataSourceFactoryGetter) {
                    return reader;
                }
            }
            final DBIdentity dbFactoryId = DBIdentity.parseId((String)config.getString("dataSourceFactoryId"));
            return new IDataSourceFactoryGetter(){

                @Override
                public DataSourceFactory getDataSourceFactory() {
                    return TIS.getDataBasePlugin(new PostedDSProp(dbFactoryId));
                }

                @Override
                public Integer getRowFetchSize() {
                    return 2000;
                }
            };
        });
    }

    public static IDataSourceFactoryGetter getDataSourceFactoryGetter(Configuration originalConfig, IJobContainerContext containerContext, Function<DataXName, Object> callable) {
        DataXName dataXName = containerContext.getTISDataXName();
        StoreResourceType resType = StoreResourceType.parse((String)originalConfig.getString("storeResType"));
        if (dataXName == null) {
            throw new IllegalArgumentException("param dataXName:" + dataXName + "can not be null");
        }
        if (dataXName.getType() != resType) {
            throw new IllegalStateException("dataXName type:" + dataXName.getType() + " must be equal with resType:" + resType);
        }
        try {
            Object dataxPlugin = callable.apply(dataXName);
            Objects.requireNonNull(dataxPlugin, "dataXName:" + dataXName + " relevant instance can not be null");
            if (!(dataxPlugin instanceof IDataSourceFactoryGetter)) {
                throw new IllegalStateException("dataxWriter:" + dataxPlugin.getClass() + " mus be type of " + IDataSourceFactoryGetter.class);
            }
            return (IDataSourceFactoryGetter)dataxPlugin;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public DataSourceFactory getDataSourceFactory();

    default public IDBReservedKeys getDBReservedKeys() {
        return this.getDataSourceFactory();
    }

    default public Integer getRowFetchSize() {
        throw new UnsupportedOperationException();
    }
}

