/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.ds;

import com.alibaba.citrus.turbine.Context;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.extension.impl.XmlFile;
import com.qlangtech.tis.manage.common.CenterResource;
import com.qlangtech.tis.plugin.KeyedPluginStore;
import com.qlangtech.tis.plugin.PluginStore;
import com.qlangtech.tis.plugin.SetPluginsResult;
import com.qlangtech.tis.plugin.ds.DSKey;
import com.qlangtech.tis.plugin.ds.DataSourceFactory;
import com.qlangtech.tis.plugin.ds.FacadeDataSource;
import com.qlangtech.tis.plugin.ds.IFacadeDataSource;
import com.qlangtech.tis.util.IPluginContext;
import java.io.File;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;

public class DataSourceFactoryPluginStore
extends KeyedPluginStore<DataSourceFactory> {
    private final boolean shallUpdateDB;

    public DataSourceFactoryPluginStore(KeyedPluginStore.Key key, boolean shallUpdateDB) {
        super(key, new PluginStore.IPluginProcessCallback[0]);
        this.shallUpdateDB = shallUpdateDB;
    }

    public DSKey getDSKey() {
        return (DSKey)this.key;
    }

    public FacadeDataSource createFacadeDataSource() {
        DataSourceFactory plugin = this.getPlugin();
        if (plugin == null) {
            throw new IllegalStateException("dbName:" + this.key.keyVal + " relevant facade datasource has not been defined,file:" + this.getSerializeFileName());
        }
        if (!(plugin instanceof IFacadeDataSource)) {
            throw new IllegalStateException("plugin:" + plugin.identityValue() + " is not instanceOf IFacadeDataSource");
        }
        plugin.getTablesInDB();
        return ((IFacadeDataSource)((Object)plugin)).createFacadeDataSource();
    }

    public <DS extends DataSourceFactory> DS getDataSource() {
        return (DS)((DataSourceFactory)super.getPlugin());
    }

    @Override
    public DataSourceFactory getPlugin() {
        DataSourceFactory dsFactory = (DataSourceFactory)super.getPlugin();
        return dsFactory;
    }

    public void deleteDB() throws Exception {
        XmlFile targetFile = this.getTargetFile();
        if (this.getDSKey().isFacadeType()) {
            FileUtils.forceDelete((File)targetFile.getFile());
        } else {
            FileUtils.deleteDirectory((File)targetFile.getFile().getParentFile());
        }
    }

    @Override
    public void copyConfigFromRemote() {
        List subFiles = CenterResource.getSubFiles((String)("tis_plugin_config" + File.separator + this.key.getSubDirPath()), (boolean)false, (boolean)true);
        for (String f : subFiles) {
            CenterResource.copyFromRemote2Local((String)("tis_plugin_config" + File.separator + this.key.getSubDirPath() + File.separator + f), (boolean)true);
        }
    }

    @Override
    public synchronized SetPluginsResult setPlugins(IPluginContext pluginContext, Optional<Context> context, List<Descriptor.ParseDescribable<DataSourceFactory>> dlist, boolean update) {
        if (dlist.size() != 1) {
            throw new IllegalArgumentException("size of dlist must equal to 1");
        }
        if (!context.isPresent()) {
            throw new IllegalArgumentException("Context shall exist");
        }
        Context ctx = context.get();
        String dbName = this.key.keyVal.getVal();
        SetPluginsResult result = super.setPlugins(pluginContext, context, dlist, update);
        if (!result.success) {
            return result;
        }
        Descriptor.ParseDescribable<DataSourceFactory> dbDesc = dlist.get(0);
        pluginContext.addDb(dbDesc, dbName, ctx, this.shallUpdateDB && !update);
        return new SetPluginsResult(!ctx.hasErrors(), result.cfgChanged);
    }
}

