/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.ds;

import com.alibaba.citrus.turbine.Context;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.annotation.Public;
import com.qlangtech.tis.datax.DataXJobSubmit;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.extension.IDescribableManipulate;
import com.qlangtech.tis.lang.TisException;
import com.qlangtech.tis.plugin.IEndTypeGetter;
import com.qlangtech.tis.plugin.IPluginStore;
import com.qlangtech.tis.plugin.IdentityName;
import com.qlangtech.tis.plugin.annotation.FormField;
import com.qlangtech.tis.plugin.annotation.FormFieldType;
import com.qlangtech.tis.plugin.annotation.Validator;
import com.qlangtech.tis.plugin.ds.ColumnMetaData;
import com.qlangtech.tis.plugin.ds.DBConfig;
import com.qlangtech.tis.plugin.ds.DBIdentity;
import com.qlangtech.tis.plugin.ds.DataDumpers;
import com.qlangtech.tis.plugin.ds.DataSourceFactoryManipulate;
import com.qlangtech.tis.plugin.ds.DataSourceMeta;
import com.qlangtech.tis.plugin.ds.DataType;
import com.qlangtech.tis.plugin.ds.JDBCConnection;
import com.qlangtech.tis.plugin.ds.JDBCConnectionException;
import com.qlangtech.tis.plugin.ds.JDBCConnectionPool;
import com.qlangtech.tis.plugin.ds.JDBCTypes;
import com.qlangtech.tis.plugin.ds.PostedDSProp;
import com.qlangtech.tis.plugin.ds.TISTable;
import com.qlangtech.tis.plugin.ds.TableNotFoundException;
import com.qlangtech.tis.runtime.module.misc.IControlMsgHandler;
import com.qlangtech.tis.runtime.module.misc.IMessageHandler;
import com.qlangtech.tis.sql.parser.tuple.creator.EntityName;
import java.io.Serializable;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Wrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Public
public abstract class DataSourceFactory
implements Describable<DataSourceFactory>,
Serializable,
DBIdentity,
DataSourceMeta,
Wrapper {
    public static final String DS_TYPE_MYSQL = "MySQL";
    public static final String DS_TYPE_MYSQL_V8 = "MySQL-V8";
    @FormField(identity=true, ordinal=0, type=FormFieldType.INPUTTEXT, validate={Validator.require, Validator.identity})
    public String name;
    public static final String KEY_COLUMN_NAME = "COLUMN_NAME";
    public static final String KEY_REMARKS = "REMARKS";
    public static final String KEY_NULLABLE = "NULLABLE";
    public static final String KEY_DECIMAL_DIGITS = "DECIMAL_DIGITS";
    public static final String KEY_TYPE_NAME = "TYPE_NAME";
    public static final String KEY_DATA_TYPE = "DATA_TYPE";
    public static final String KEY_COLUMN_SIZE = "COLUMN_SIZE";

    public static <D extends DataSourceFactory> D load(String dbName) {
        return (D)TIS.getDataBasePlugin(PostedDSProp.parse(dbName));
    }

    public final String identityValue() {
        return this.name;
    }

    public void setReaderStatement(Statement stmt) throws SQLException {
    }

    public abstract DBConfig getDbConfig();

    public boolean skipDumpPhrase() {
        return false;
    }

    public abstract void visitFirstConnection(IConnProcessor var1);

    public DataDumpers getDataDumpers(TISTable table) {
        throw new UnsupportedOperationException("datasource:" + this.identityValue() + " is not support direct dump");
    }

    @Override
    public final Descriptor<DataSourceFactory> getDescriptor() {
        Descriptor descriptor = TIS.get().getDescriptor(this.getClass());
        Class expectDesClass = this.getExpectDesClass();
        if (!expectDesClass.isAssignableFrom(descriptor.getClass())) {
            throw new IllegalStateException(descriptor.getClass().getName() + " must implement the Descriptor of " + expectDesClass.getSimpleName());
        }
        return descriptor;
    }

    protected <C extends BaseDataSourceFactoryDescriptor> Class<C> getExpectDesClass() {
        return BaseDataSourceFactoryDescriptor.class;
    }

    protected void validateConnection(String jdbcUrl, IConnProcessor p) throws TableNotFoundException {
        JDBCConnection conn = null;
        try {
            conn = this.getConnection(jdbcUrl, Optional.empty(), true);
            p.vist(conn);
        }
        catch (TableNotFoundException e) {
            throw e;
        }
        catch (TisException e) {
            throw e;
        }
        catch (Exception e) {
            throw TisException.create((String)(e.getMessage() + ",jdbcUrl:" + jdbcUrl), (Throwable)e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public final JDBCConnection getConnection(String jdbcUrl, Optional<Properties> props, boolean verify) throws SQLException {
        JDBCConnectionPool connectionPool = JDBCConnection.connectionPool.get();
        JDBCConnection conn = null;
        if (connectionPool != null) {
            conn = connectionPool.getConnection(jdbcUrl, verify);
            if (conn == null) {
                return connectionPool.getConnection(jdbcUrl, verify, url -> {
                    try {
                        return this.createConnection(jdbcUrl, props, verify);
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            return conn;
        }
        return this.createConnection(jdbcUrl, props, verify);
    }

    protected JDBCConnection createConnection(String jdbcUrl, Optional<Properties> props, boolean verify) throws SQLException {
        throw new UnsupportedOperationException("class:" + this.getClass().getName() + ",jdbcUrl:" + jdbcUrl);
    }

    public JDBCConnection getConnection(String jdbcUrl, Optional<Properties> props, boolean usingPool, boolean verify) throws SQLException {
        return this.getConnection(jdbcUrl, props, verify);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ColumnMetaData> parseTableColMeta(boolean inSink, String jdbcUrl, JDBCConnection conn, EntityName table) throws SQLException, TableNotFoundException {
        table = this.logicTable2PhysicsTable(jdbcUrl, table);
        DatabaseMetaData metaData1 = null;
        ResultSet primaryKeys = null;
        ResultSet columns1 = null;
        Object colMeta = null;
        Object comment = null;
        Object typeName = null;
        try {
            metaData1 = conn.getConnection().getMetaData();
            try (ResultSet tables = metaData1.getTables(null, this.getDbSchema(), table.getTableName(), null);){
                int count = 0;
                ArrayList matchEntries = Lists.newArrayList();
                while (tables.next()) {
                    matchEntries.add(tables.getString("TABLE_NAME") + "(" + tables.getString("TABLE_TYPE") + "," + tables.getString("TABLE_SCHEM") + ")");
                    ++count;
                }
                if (count < 1) {
                    throw new TableNotFoundException((IdentityName)this, table.getFullName() + ",url:" + conn.getUrl());
                }
                if (count > 1) {
                    throw new IllegalStateException("duplicate table entities exist:" + String.join((CharSequence)",", matchEntries));
                }
            }
            primaryKeys = this.getPrimaryKeys(table, metaData1);
            columns1 = this.getColumnsMeta(table, conn, metaData1);
            HashSet<String> pkCols = this.createAddedCols(table);
            while (primaryKeys.next()) {
                String columnName = primaryKeys.getString(KEY_COLUMN_NAME);
                pkCols.add(columnName);
            }
            List<ColumnMetaData> list = this.wrapColsMeta(inSink, table, columns1, pkCols, conn);
            this.closeResultSet(columns1);
            this.closeResultSet(primaryKeys);
            return list;
        }
        catch (Throwable throwable) {
            this.closeResultSet(columns1);
            this.closeResultSet(primaryKeys);
            throw throwable;
        }
    }

    public List<ColumnMetaData> wrapColsMeta(boolean inSink, EntityName table, ResultSet columns1, JDBCConnection conn) throws SQLException, TableNotFoundException {
        return this.wrapColsMeta(inSink, table, columns1, Collections.emptySet(), conn);
    }

    public final List<ColumnMetaData> wrapColsMeta(boolean inSink, EntityName table, ResultSet columns1, Set<String> pkCols, JDBCConnection conn) throws SQLException, TableNotFoundException {
        return this.wrapColsMeta(inSink, table, columns1, this.createColumnMetaBuilder(table, columns1, pkCols, conn));
    }

    protected CreateColumnMeta createColumnMetaBuilder(EntityName table, ResultSet columns1, Set<String> pkCols, JDBCConnection conn) {
        return new CreateColumnMeta(pkCols, columns1);
    }

    public List<ColumnMetaData> wrapColsMeta(boolean inSink, EntityName table, ResultSet columns1, CreateColumnMeta columnMetaCreator) throws SQLException, TableNotFoundException {
        String colName = null;
        int i = 0;
        ArrayList columns = Lists.newArrayList();
        HashSet<String> addedCols = this.createAddedCols(table);
        while (columns1.next()) {
            colName = columns1.getString(KEY_COLUMN_NAME);
            if (!addedCols.add(colName)) continue;
            columns.add(columnMetaCreator.create(colName, i++));
        }
        return columns;
    }

    protected HashSet<String> createAddedCols(EntityName table) throws TableNotFoundException {
        return Sets.newHashSet();
    }

    protected EntityName logicTable2PhysicsTable(String jdbcUrl, EntityName table) {
        return table;
    }

    public List<String> getAllPhysicsTabs(DataXJobSubmit.TableDataXEntity tabEntity) {
        return Collections.singletonList(tabEntity.getSourceTableName());
    }

    private String getDbSchema() {
        String dbSchema = null;
        if (this instanceof ISchemaSupported) {
            dbSchema = ((ISchemaSupported)((Object)this)).getDBSchema();
        }
        return dbSchema;
    }

    protected List<ColumnMetaData> parseTableColMeta(boolean inSink, EntityName table, String jdbcUrl) throws TableNotFoundException {
        AtomicReference ref = new AtomicReference();
        this.validateConnection(jdbcUrl, conn -> {
            List<ColumnMetaData> columnMetaData = this.parseTableColMeta(inSink, jdbcUrl, conn, table);
            ref.set(columnMetaData);
        });
        return (List)ref.get();
    }

    protected ResultSet getColumnsMeta(EntityName table, JDBCConnection conn, DatabaseMetaData metaData1) throws SQLException {
        return metaData1.getColumns(null, this.getDbSchema(), table.getTableName(), null);
    }

    protected ResultSet getPrimaryKeys(EntityName table, DatabaseMetaData metaData1) throws SQLException {
        return metaData1.getPrimaryKeys(null, this.getDbSchema(), table.getTableName());
    }

    protected void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static class CreateColumnMeta {
        protected final Set<String> pkCols;
        protected final ResultSet columns1;

        public CreateColumnMeta(Set<String> pkCols, ResultSet columns1) {
            this.pkCols = pkCols;
            this.columns1 = columns1;
        }

        public ColumnMetaData create(String colName, int index) throws SQLException {
            String comment = this.columns1.getString(DataSourceFactory.KEY_REMARKS);
            ColumnMetaData colMeta = new ColumnMetaData(index, colName, this.getDataType(colName), this.pkCols.contains(colName), this.columns1.getBoolean(DataSourceFactory.KEY_NULLABLE));
            if (StringUtils.isNotEmpty((String)comment)) {
                colMeta.setComment(comment);
            }
            return colMeta;
        }

        protected DataType getDataType(String colName) throws SQLException {
            int decimalDigits = this.columns1.getInt(DataSourceFactory.KEY_DECIMAL_DIGITS);
            String typeName = this.columns1.getString(DataSourceFactory.KEY_TYPE_NAME);
            DataType colType = this.createColDataType(colName, typeName, this.columns1.getInt(DataSourceFactory.KEY_DATA_TYPE), this.columns1.getInt(DataSourceFactory.KEY_COLUMN_SIZE), decimalDigits);
            if (decimalDigits > 0) {
                colType.setDecimalDigits(Integer.valueOf(decimalDigits));
            }
            return colType;
        }

        protected DataType parseDataType(int dbColType, String typeName, int colSize) {
            return DataType.create((Integer)dbColType, (String)typeName, (Integer)colSize);
        }

        protected DataType createColDataType(String colName, String typeName, int dbColType, int colSize, int decimalDigits) throws SQLException {
            DataType type = this.parseDataType(dbColType, typeName, colSize);
            type.setDecimalDigits(Integer.valueOf(decimalDigits));
            if ((type.getJdbcType() == JDBCTypes.DECIMAL || type.getJdbcType() == JDBCTypes.NUMERIC) && decimalDigits == 0) {
                return DataType.create((Integer)(type.getColumnSize() > 10 ? JDBCTypes.BIGINT : JDBCTypes.INTEGER).getType(), (String)type.typeName, (Integer)type.getColumnSize());
            }
            return type;
        }
    }

    public static abstract class BaseDataSourceFactoryDescriptor<T extends DataSourceFactory>
    extends Descriptor<T>
    implements IEndTypeGetter,
    IDescribableManipulate<DataSourceFactoryManipulate> {
        private static final Logger logger = LoggerFactory.getLogger(BaseDataSourceFactoryDescriptor.class);

        @Override
        public final String getDisplayName() {
            return this.getDataSourceName();
        }

        @Override
        public Class<DataSourceFactoryManipulate> getManipulateExtendPoint() {
            return DataSourceFactoryManipulate.class;
        }

        @Override
        public final Optional<IPluginStore<DataSourceFactoryManipulate>> getManipulateStore() {
            return Optional.empty();
        }

        public Optional<String> getDefaultDataXReaderDescName() {
            return Optional.empty();
        }

        @Override
        public final Map<String, Object> getExtractProps() {
            Map<String, Object> eprops = super.getExtractProps();
            eprops.put("supportFacade", this.supportFacade());
            eprops.put("facadeSourceTypes", this.facadeSourceTypes());
            Optional<String> dataXReaderDesc = this.getDefaultDataXReaderDescName();
            if (dataXReaderDesc.isPresent()) {
                eprops.put("dataXReaderDesc", dataXReaderDesc.get());
            }
            return eprops;
        }

        protected abstract String getDataSourceName();

        protected abstract boolean supportFacade();

        protected List<String> facadeSourceTypes() {
            if (this.supportFacade()) {
                throw new UnsupportedOperationException("shall overwrite facadeSourceTypes");
            }
            return Collections.emptyList();
        }

        @Override
        protected final boolean verify(IControlMsgHandler msgHandler, Context context, Descriptor.PostFormVals postFormVals) {
            DataSourceFactory instance = (DataSourceFactory)postFormVals.newInstance();
            boolean valid = this.validateDSFactory(msgHandler, context, instance);
            return valid;
        }

        protected boolean validateConnection(JDBCConnection conn, T dsFactory, IControlMsgHandler msgHandler, Context context) throws TisException {
            return true;
        }

        protected boolean validateDSFactory(IControlMsgHandler msgHandler, Context context, T dsFactory) {
            DBConfig dbConfig = Objects.requireNonNull(((DataSourceFactory)dsFactory).getDbConfig(), "dbConfig can not be null");
            Throwable[] faild = new Throwable[1];
            boolean[] validateResult = new boolean[1];
            Object actionContext = context.getContext();
            try {
                if (!dbConfig.vistDbURL(false, (dbName, dbHost, jdbcUrl) -> {
                    try (JDBCConnection conn = dsFactory.getConnection(jdbcUrl, Optional.empty(), true);){
                        context.setContext(actionContext);
                        validateResult[0] = this.validateConnection(conn, dsFactory, msgHandler, context);
                    }
                    catch (Throwable e) {
                        faild[0] = e;
                        logger.warn(e.getMessage(), e);
                    }
                }, false, (IMessageHandler)msgHandler, context, 5)) {
                    return false;
                }
            }
            catch (JDBCConnectionException e) {
                logger.error(e.getMessage(), (Throwable)e);
                msgHandler.addErrorMessage(context, e.getMessage());
                return false;
            }
            if (faild[0] != null) {
                msgHandler.addErrorMessage(context, "\u8bf7\u786e\u8ba4\u8fde\u63a5\u53c2\u6570\u662f\u5426\u6b63\u786e:" + faild[0].getMessage());
                return false;
            }
            return validateResult[0];
        }
    }

    public static interface IConnProcessor {
        public void vist(JDBCConnection var1) throws SQLException, TableNotFoundException;
    }

    @Public
    public static interface ISchemaSupported {
        public static String getCDCTableTokens(Optional<ISchemaSupported> schemaSupport, String dbNanme, String tabName) {
            if (StringUtils.isEmpty((String)dbNanme)) {
                throw new IllegalArgumentException("param dbName can not be empty");
            }
            if (StringUtils.isEmpty((String)tabName)) {
                throw new IllegalArgumentException("param tabName can not be empty");
            }
            return Objects.requireNonNull(schemaSupport, "schemaSupport can not be null").filter(schema -> !schema.isUseDBNameAsSchemaName()).map(ISchemaSupported::getDBSchema).orElse(dbNanme) + "." + tabName;
        }

        public String getDBSchema();

        default public boolean isUseDBNameAsSchemaName() {
            return false;
        }
    }
}

